---
title: "module analysis::diff::edits::FileSystemChanges"
id: FileSystemChanges
slug: /Library/analysis/diff/edits/FileSystemChanges
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

#### Usage

```rascal
import analysis::diff::edits::FileSystemChanges;
```



## data FileSystemChange {#analysis-diff-edits-FileSystemChanges-FileSystemChange}
Representing file (and directory) change events.

```rascal
data FileSystemChange  
     = removed(loc file)
     | created(loc file)
     | renamed(loc from, loc to)
     | changed(loc file)
     ;
```


A [File System Change](../../../..//Library/analysis/diff/edits/FileSystemChanges.md#analysis-diff-edits-FileSystemChanges-FileSystemChange) describes what happened, or what will happen, to a file or directory:
* [Removed](../../../..//Library/analysis/diff/edits/FileSystemChanges.md#analysis-diff-edits-FileSystemChanges-removed)
* [FileSystemChanges-created](../../../..//Library/analysis/diff/edits/FileSystemChanges.md#analysis-diff-edits-FileSystemChanges-created)
* [Renamed](../../../..//Library/analysis/diff/edits/FileSystemChanges.md#analysis-diff-edits-FileSystemChanges-renamed)
* or [Changed](../../../..//Library/analysis/diff/edits/FileSystemChanges.md#analysis-diff-edits-FileSystemChanges-changed)

FileSystemChanges are an intermediate contract between the sources and the targets
of changes to files and directories on a file system. Typical sources are
[watch](../../../..//Library/IO.md#IO-watch) or source-to-source refactoring tools like "rename". Typical targets
are preview UI and patch execution tools in the UI or on the commandline,
or the listeners of [watch](../../../..//Library/IO.md#IO-watch) that can trigger incremental re-compilation or re-loading
features.

The location scheme which is passed to the respective constructors of [File System Change](../../../..//Library/analysis/diff/edits/FileSystemChanges.md#analysis-diff-edits-FileSystemChanges-FileSystemChange)
must have the [Watching](../../../..//Library/IO.md#IO-watching) and [Writing](../../../..//Library/IO.md#IO-writing) [IOCapability](../../../..//Library/IO.md#IO-IOCapability). Otherwise 
[IO](../../../..//Library/Exception.md#Exception-IO) errors can be expected.

For detailed changes _within_ files, see [Text Edits](../../../..//Library/analysis/diff/edits/TextEdits.md).

#### Benefits


* Implementations of file watchers can use [FileSystemChange](../../../..//Library/analysis/diff/edits/FileSystemChanges.md#analysis-diff-edits-FileSystemChanges-FileSystemChange) to report what happened.
* Implementations of file and directory diff tools can represent the differences
using [File System Change](../../../..//Library/analysis/diff/edits/FileSystemChanges.md#analysis-diff-edits-FileSystemChanges-FileSystemChange)

#### Pitfalls


* To represent the internal differences of files, have a look at [Text Edits](../../../..//Library/analysis/diff/edits/TextEdits.md) instead.
* Note that the concept of "file", as used here in the fields names of [File System Change](../../../..//Library/analysis/diff/edits/FileSystemChanges.md#analysis-diff-edits-FileSystemChanges-FileSystemChange), 
includes "directories". This is because directories are indeed a kind of files 
from the OS perspective, and because it allows us to unify the two concepts here.

