---
title: "module lang::json::\\syntax::JSON"
id: JSON
slug: /Library/lang/json/syntax/JSON
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

#### Usage

```rascal
import lang::json::\syntax::JSON;
```



## syntax JSONText {#lang-json-\syntax-JSON-JSONText}

```rascal
start syntax JSONText
	= Object
	| Array
	;
```

## syntax Value {#lang-json-\syntax-JSON-Value}

```rascal
syntax Value
	= Object
	| Array
	| NumericLiteral
	| StringLiteral
	| False: "false"
	| Null: "null"
	| True: "true"
	;
```

## syntax Object {#lang-json-\syntax-JSON-Object}

```rascal
syntax Object
	= Object: "{" { Member "," }* members "}"
	;
```

## syntax Member {#lang-json-\syntax-JSON-Member}

```rascal
syntax Member
	= Member: StringLiteral memberName ":" Value memberValue
	;
```

## syntax Array {#lang-json-\syntax-JSON-Array}

```rascal
syntax Array
	= Array: "[" { Value ","}* values "]"
	;
```

## syntax NumericLiteral {#lang-json-\syntax-JSON-NumericLiteral}

```rascal
lexical NumericLiteral
	= RealLiteral
	| IntegerLiteral
	;
```

## syntax RealLiteral {#lang-json-\syntax-JSON-RealLiteral}

```rascal
lexical RealLiteral
	= [\-]? [0] [E e] [+ \-]? [0-9]+
	| [\-]? [1-9] [0-9]* [E e] [+ \-]? [0-9]+
	| [\-]? [0] "." !>> "." [0-9]*   
	| [\-]? [1-9] [0-9]* "." !>> "." [0-9]*   
	| [\-]? [0] "." [0-9]* [E e] [+ \-]? [0-9]+  
	| [\-]? [1-9] [0-9]* "." [0-9]* [E e] [+ \-]? [0-9]+  
	;
```

## syntax IntegerLiteral {#lang-json-\syntax-JSON-IntegerLiteral}

```rascal
lexical IntegerLiteral
	= [\-]? "0" !>> [0-9] 
	| [\-]? [1-9] [0-9]* !>> [0-9] ;
```

## syntax StringLiteral {#lang-json-\syntax-JSON-StringLiteral}

```rascal
lexical StringLiteral
	= "\"" StringChar* chars "\"";
```

## syntax StringChar {#lang-json-\syntax-JSON-StringChar}

```rascal
lexical StringChar
	= ![\" \\]
	| "\\" [\" \\ / b f n r t] 
	| UnicodeEscape 
	;
```

## syntax UnicodeEscape {#lang-json-\syntax-JSON-UnicodeEscape}

```rascal
lexical UnicodeEscape
	= utf16: "\\" [u] [0-9 A-F a-f] [0-9 A-F a-f] [0-9 A-F a-f] [0-9 A-F a-f] 
    | utf32: "\\" [U] [0-9 A-F a-f] [0-9 A-F a-f] [0-9 A-F a-f] [0-9 A-F a-f] [0-9 A-F a-f] [0-9 A-F a-f] 
	;
```

## syntax JSONKeywords {#lang-json-\syntax-JSON-JSONKeywords}

```rascal
keyword JSONKeywords
	= "false"
	| "null"
	| "true"
	;
```

## syntax LAYOUT {#lang-json-\syntax-JSON-LAYOUT}

```rascal
layout LAYOUT
	= [\t-\n \r \ ]* !>> [\t-\n \r \ ]
	;
```

