/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.persistent;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.impl.persistent.Constructor;
import io.usethesource.vallang.impl.persistent.EmptySet;
import io.usethesource.vallang.impl.persistent.List;
import io.usethesource.vallang.impl.persistent.ListWriter;
import io.usethesource.vallang.impl.persistent.MapWriter;
import io.usethesource.vallang.impl.persistent.Node;
import io.usethesource.vallang.impl.persistent.SetWriter;
import io.usethesource.vallang.impl.persistent.Tuple;
import io.usethesource.vallang.impl.primitive.AbstractPrimitiveValueFactory;
import io.usethesource.vallang.impl.util.collections.ShareableValuesList;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.Map;

public class ValueFactory
extends AbstractPrimitiveValueFactory {
    private static final IList EMPTY_LIST = List.newList(TypeFactory.getInstance().voidType(), new ShareableValuesList());

    protected ValueFactory() {
    }

    public static ValueFactory getInstance() {
        return InstanceKeeper.instance;
    }

    @Override
    public IListWriter listWriter() {
        return new ListWriter();
    }

    @Override
    public IList list(IValue ... elements) {
        if (elements.length == 0) {
            return EMPTY_LIST;
        }
        IListWriter listWriter = this.listWriter();
        listWriter.append(elements);
        return (IList)listWriter.done();
    }

    @Override
    public ISet set(IValue ... elements) {
        if (elements.length == 0) {
            return EmptySet.EMPTY_SET;
        }
        ISetWriter setWriter = this.setWriter();
        setWriter.insert(elements);
        return (ISet)setWriter.done();
    }

    @Override
    public INode node(String name) {
        return Node.newNode(name, new IValue[0]);
    }

    @Override
    public INode node(String name, IValue ... children) {
        return Node.newNode(name, (IValue[])children.clone());
    }

    @Override
    public INode node(String name, IValue[] children, Map<String, IValue> keyArgValues) {
        return Node.newNode(name, (IValue[])children.clone()).asWithKeywordParameters().setParameters(keyArgValues);
    }

    @Override
    public IConstructor constructor(Type constructorType) {
        return Constructor.newConstructor(constructorType, new IValue[0]);
    }

    @Override
    public IConstructor constructor(Type constructorType, IValue ... children) {
        return Constructor.newConstructor(constructorType, (IValue[])children.clone());
    }

    @Override
    public IConstructor constructor(Type constructorType, IValue[] children, Map<String, IValue> kwParams) {
        return Constructor.newConstructor(constructorType, (IValue[])children.clone(), kwParams);
    }

    @Override
    public ITuple tuple() {
        return Tuple.newTuple(new IValue[0]);
    }

    @Override
    public ITuple tuple(IValue ... args) {
        return Tuple.newTuple((IValue[])args.clone());
    }

    @Override
    public ISetWriter setWriter() {
        return new SetWriter((a, b) -> this.tuple((IValue)a, (IValue)b));
    }

    @Override
    public IMapWriter mapWriter() {
        return new MapWriter();
    }

    public String toString() {
        return "VALLANG_PERSISTENT_FACTORY";
    }

    private static class InstanceKeeper {
        public static final ValueFactory instance = new ValueFactory();

        private InstanceKeeper() {
        }
    }
}

