/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.primitive;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.INumber;
import io.usethesource.vallang.IRational;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.impl.primitive.AbstractNumberValue;
import io.usethesource.vallang.impl.primitive.BigDecimalValue;
import io.usethesource.vallang.impl.primitive.BoolValue;
import io.usethesource.vallang.impl.primitive.ICanBecomeABigInteger;
import io.usethesource.vallang.impl.primitive.IntegerValue;
import io.usethesource.vallang.impl.primitive.RationalValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.checkerframework.checker.nullness.qual.Nullable;

class BigIntegerValue
extends AbstractNumberValue
implements IInteger,
ICanBecomeABigInteger {
    private static final Type INTEGER_TYPE = TypeFactory.getInstance().integerType();
    protected final BigInteger value;

    BigIntegerValue(BigInteger value) {
        if (value.equals(BigInteger.ZERO)) {
            value = BigInteger.ZERO;
        }
        if (value.equals(BigInteger.ONE)) {
            value = BigInteger.ONE;
        }
        this.value = value;
    }

    @Override
    public IInteger toInteger() {
        return this;
    }

    @Override
    public Type getType() {
        return INTEGER_TYPE;
    }

    @Override
    public int intValue() throws ArithmeticException {
        return this.value.intValueExact();
    }

    @Override
    public long longValue() throws ArithmeticException {
        return this.value.longValueExact();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public IReal toReal(int precision) {
        return BigDecimalValue.newReal(new BigDecimal(this.value));
    }

    @Override
    public IRational toRational() {
        return RationalValue.newRational(this, IntegerValue.INTEGER_ONE);
    }

    @Override
    public byte[] getTwosComplementRepresentation() {
        return this.value.toByteArray();
    }

    @Override
    public BigInteger toBigInteger() {
        return this.value;
    }

    @Override
    public IInteger add(IInteger other) {
        BigInteger o = ((ICanBecomeABigInteger)((Object)other)).toBigInteger();
        BigInteger result = this.value.add(o);
        if (result == this.value) {
            return this;
        }
        if (result == o) {
            return other;
        }
        int length = result.bitLength();
        if (length <= 31) {
            return IntegerValue.newInteger(result.intValue());
        }
        return IntegerValue.newInteger(result);
    }

    @Override
    public IReal add(IReal other) {
        return (IReal)other.add(this);
    }

    @Override
    public IRational add(IRational other) {
        return (IRational)other.add(this);
    }

    @Override
    public IInteger subtract(IInteger other) {
        BigInteger result = this.value.subtract(((ICanBecomeABigInteger)((Object)other)).toBigInteger());
        if (result == this.value) {
            return this;
        }
        int length = result.bitLength();
        if (length <= 31) {
            return IntegerValue.newInteger(result.intValue());
        }
        return IntegerValue.newInteger(result);
    }

    @Override
    public INumber subtract(IReal other) {
        return this.toReal(other.precision()).subtract(other);
    }

    @Override
    public INumber subtract(IRational other) {
        return this.toRational().subtract(other);
    }

    @Override
    public IInteger multiply(IInteger other) {
        BigInteger o = ((ICanBecomeABigInteger)((Object)other)).toBigInteger();
        BigInteger result = this.value.multiply(o);
        if (result == this.value) {
            return this;
        }
        if (result == o) {
            return other;
        }
        return IntegerValue.newInteger(result);
    }

    @Override
    public IReal multiply(IReal other) {
        return (IReal)other.multiply(this);
    }

    @Override
    public IRational multiply(IRational other) {
        return (IRational)other.multiply(this);
    }

    @Override
    public IInteger divide(IInteger other) {
        BigInteger result = this.value.divide(((ICanBecomeABigInteger)((Object)other)).toBigInteger());
        if (result == this.value) {
            return this;
        }
        int length = result.bitLength();
        if (length <= 31) {
            return IntegerValue.newInteger(result.intValue());
        }
        return IntegerValue.newInteger(result);
    }

    @Override
    public IRational divide(IRational other) {
        return this.toRational().divide(other);
    }

    @Override
    public INumber divide(IInteger other, int precision) {
        return this.toReal(precision).divide(other, precision);
    }

    @Override
    public INumber divide(IRational other, int precision) {
        return this.toReal(precision).divide(other, precision);
    }

    @Override
    public IReal divide(IReal other, int precision) {
        return this.toReal(precision).divide(other, precision);
    }

    @Override
    public IInteger mod(IInteger other) {
        BigInteger result = this.value.mod(((ICanBecomeABigInteger)((Object)other)).toBigInteger());
        if (other instanceof IntegerValue) {
            int integerResult = result.intValue();
            return IntegerValue.newInteger(integerResult);
        }
        return IntegerValue.newInteger(result);
    }

    @Override
    public IInteger remainder(IInteger other) {
        BigInteger result = this.value.remainder(((ICanBecomeABigInteger)((Object)other)).toBigInteger());
        if (other instanceof IntegerValue) {
            int integerResult = result.intValue();
            return IntegerValue.newInteger(integerResult);
        }
        return IntegerValue.newInteger(result);
    }

    @Override
    public IInteger negate() {
        return new BigIntegerValue(this.value.negate());
    }

    @Override
    public IBool equal(IInteger other) {
        return BoolValue.getBoolValue(this.compare(other) == 0);
    }

    @Override
    public IBool equal(IReal other) {
        return other.equal(this);
    }

    @Override
    public IBool equal(IRational other) {
        return other.equal(this);
    }

    @Override
    public IBool greater(IInteger other) {
        return BoolValue.getBoolValue(this.compare(other) > 0);
    }

    @Override
    public IBool greater(IReal other) {
        return other.less(this);
    }

    @Override
    public IBool greater(IRational other) {
        return other.less(this);
    }

    @Override
    public IBool greaterEqual(IInteger other) {
        return BoolValue.getBoolValue(this.compare(other) >= 0);
    }

    @Override
    public IBool greaterEqual(IReal other) {
        return other.lessEqual(this);
    }

    @Override
    public IBool greaterEqual(IRational other) {
        return other.lessEqual(this);
    }

    @Override
    public IBool less(IInteger other) {
        return BoolValue.getBoolValue(this.compare(other) < 0);
    }

    @Override
    public IBool less(IReal other) {
        return other.greater(this);
    }

    @Override
    public IBool less(IRational other) {
        return other.greater(this);
    }

    @Override
    public IBool lessEqual(IInteger other) {
        return BoolValue.getBoolValue(this.compare(other) <= 0);
    }

    @Override
    public IBool lessEqual(IReal other) {
        return other.greaterEqual(this);
    }

    @Override
    public IBool lessEqual(IRational other) {
        return other.greaterEqual(this);
    }

    @Override
    public int compare(IInteger other) {
        return this.value.compareTo(((ICanBecomeABigInteger)((Object)other)).toBigInteger());
    }

    @Override
    public int compare(INumber other) {
        if (this.isIntegerType(other)) {
            return this.compare(other.toInteger());
        }
        if (this.isRationalType(other)) {
            return this.toRational().compare(other);
        }
        assert (other instanceof IReal);
        return this.toReal(((IReal)other).precision()).compare(other);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() == this.getClass()) {
            BigIntegerValue otherInteger = (BigIntegerValue)o;
            return this.value.equals(otherInteger.value);
        }
        return false;
    }

    @Override
    public String getStringRepresentation() {
        return this.value.toString();
    }

    @Override
    public int signum() {
        return this.value.signum();
    }

    @Override
    public IInteger abs() {
        return IntegerValue.newInteger(this.value.abs());
    }
}

