/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.type;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.random.util.RandomUtil;
import io.usethesource.vallang.type.DefaultSubtypeOfValue;
import io.usethesource.vallang.type.ITypeVisitor;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

final class StringType
extends DefaultSubtypeOfValue {
    StringType() {
    }

    public static StringType getInstance() {
        return InstanceKeeper.sInstance;
    }

    @Override
    public TypeFactory.TypeReifier getTypeReifier(TypeFactory.TypeValues symbols) {
        return new Info(symbols);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return obj == StringType.getInstance();
    }

    @Override
    public int hashCode() {
        return 94903;
    }

    @Override
    public String toString() {
        return "str";
    }

    @Override
    public <T, E extends Throwable> T accept(ITypeVisitor<T, E> visitor) throws E {
        return visitor.visitString(this);
    }

    @Override
    protected boolean isSupertypeOf(Type type) {
        return type.isSubtypeOfString(this);
    }

    @Override
    public Type lub(Type other) {
        return other.lubWithString(this);
    }

    @Override
    public Type glb(Type type) {
        return type.glbWithString(this);
    }

    @Override
    public boolean intersects(Type other) {
        return other.intersectsWithString(this);
    }

    @Override
    protected boolean intersectsWithString(Type type) {
        return true;
    }

    @Override
    protected boolean isSubtypeOfString(Type type) {
        return true;
    }

    @Override
    protected Type lubWithString(Type type) {
        return this;
    }

    @Override
    protected Type glbWithString(Type type) {
        return this;
    }

    @Override
    public IValue randomValue(Random random, TypeFactory.RandomTypesConfig typesConfig, IValueFactory vf, TypeStore store, Map<Type, Type> typeParameters, int maxDepth, int maxWidth) {
        if (random.nextBoolean() || maxDepth <= 0) {
            return vf.string("");
        }
        return vf.string(RandomUtil.string(random, 1 + random.nextInt(maxDepth + 3)));
    }

    @Override
    public boolean isString() {
        return true;
    }

    public static class Info
    extends TypeFactory.TypeReifier {
        public Info(TypeFactory.TypeValues symbols) {
            super(symbols);
        }

        @Override
        public Type getSymbolConstructorType() {
            return this.symbols().typeSymbolConstructor("str", new Object[0]);
        }

        @Override
        public Type fromSymbol(IConstructor symbol, TypeStore store, Function<IConstructor, Set<IConstructor>> grammar) {
            return StringType.getInstance();
        }

        @Override
        public Type randomInstance(BiFunction<TypeStore, TypeFactory.RandomTypesConfig, Type> next, TypeStore store, TypeFactory.RandomTypesConfig rnd) {
            return this.tf().stringType();
        }
    }

    private static final class InstanceKeeper {
        private static final StringType sInstance = new StringType();

        private InstanceKeeper() {
        }
    }
}

