/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Declaration;
import org.rascalmpl.ast.IASTVisitor;

public abstract class Toplevel
extends AbstractAST {
    public Toplevel(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasDeclaration() {
        return false;
    }

    public Declaration getDeclaration() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isGivenVisibility() {
        return false;
    }

    public static class GivenVisibility
    extends Toplevel {
        private final Declaration declaration;

        public GivenVisibility(ISourceLocation src, IConstructor node, Declaration declaration) {
            super(src, node);
            this.declaration = declaration;
        }

        @Override
        public boolean isGivenVisibility() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitToplevelGivenVisibility(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.declaration.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.declaration.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof GivenVisibility)) {
                return false;
            }
            GivenVisibility tmp = (GivenVisibility)o;
            return tmp.declaration.equals(this.declaration);
        }

        @Override
        public int hashCode() {
            return 977 + 173 * this.declaration.hashCode();
        }

        @Override
        public Declaration getDeclaration() {
            return this.declaration;
        }

        @Override
        public boolean hasDeclaration() {
            return true;
        }

        @Override
        public Object clone() {
            return GivenVisibility.newInstance(this.getClass(), this.src, null, this.clone(this.declaration));
        }
    }
}

