/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.dap;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.lsp4j.debug.Breakpoint;
import org.eclipse.lsp4j.debug.Capabilities;
import org.eclipse.lsp4j.debug.ConfigurationDoneArguments;
import org.eclipse.lsp4j.debug.ContinueArguments;
import org.eclipse.lsp4j.debug.ContinueResponse;
import org.eclipse.lsp4j.debug.DisconnectArguments;
import org.eclipse.lsp4j.debug.EvaluateArguments;
import org.eclipse.lsp4j.debug.EvaluateResponse;
import org.eclipse.lsp4j.debug.ExceptionBreakpointsFilter;
import org.eclipse.lsp4j.debug.InitializeRequestArguments;
import org.eclipse.lsp4j.debug.NextArguments;
import org.eclipse.lsp4j.debug.PauseArguments;
import org.eclipse.lsp4j.debug.ProcessEventArguments;
import org.eclipse.lsp4j.debug.ProcessEventArgumentsStartMethod;
import org.eclipse.lsp4j.debug.Scope;
import org.eclipse.lsp4j.debug.ScopesArguments;
import org.eclipse.lsp4j.debug.ScopesResponse;
import org.eclipse.lsp4j.debug.SetBreakpointsArguments;
import org.eclipse.lsp4j.debug.SetBreakpointsResponse;
import org.eclipse.lsp4j.debug.Source;
import org.eclipse.lsp4j.debug.SourceBreakpoint;
import org.eclipse.lsp4j.debug.StackFrame;
import org.eclipse.lsp4j.debug.StackTraceArguments;
import org.eclipse.lsp4j.debug.StackTraceResponse;
import org.eclipse.lsp4j.debug.StepInArguments;
import org.eclipse.lsp4j.debug.StepOutArguments;
import org.eclipse.lsp4j.debug.Thread;
import org.eclipse.lsp4j.debug.ThreadEventArguments;
import org.eclipse.lsp4j.debug.ThreadsResponse;
import org.eclipse.lsp4j.debug.Variable;
import org.eclipse.lsp4j.debug.VariablesArguments;
import org.eclipse.lsp4j.debug.VariablesResponse;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.eclipse.lsp4j.debug.services.IDebugProtocolServer;
import org.rascalmpl.dap.RascalDebugEventTrigger;
import org.rascalmpl.dap.SuspendedState;
import org.rascalmpl.dap.breakpoint.BreakpointsCollection;
import org.rascalmpl.dap.variable.RascalVariable;
import org.rascalmpl.debug.DebugHandler;
import org.rascalmpl.debug.DebugMessageFactory;
import org.rascalmpl.debug.IRascalFrame;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.ideservices.IDEServices;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.utils.StringUtils;
import org.rascalmpl.library.Prelude;
import org.rascalmpl.library.util.Reflective;
import org.rascalmpl.parser.gtd.exception.ParseError;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.util.locations.ColumnMaps;
import org.rascalmpl.util.locations.LineColumnOffsetMap;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.ProductionAdapter;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class RascalDebugAdapter
implements IDebugProtocolServer {
    public static final int mainThreadID = 1;
    private final int expensiveScopeMinSize = 100;
    private IDebugProtocolClient client;
    private final RascalDebugEventTrigger eventTrigger;
    private final DebugHandler debugHandler;
    private final Evaluator evaluator;
    private final SuspendedState suspendedState;
    private final BreakpointsCollection breakpointsCollection;
    private final Pattern emptyAuthorityPathPattern = Pattern.compile("^\\w+:/\\w+[^/]");
    private final IDEServices services;
    private final ExecutorService ownExecutor;
    private final ColumnMaps columns;
    private int lineBase = 1;
    private int columnBase = 1;
    public static final ISourceLocation DEBUGGER_LOC = URIUtil.rootLocation("debugger");
    private static final String breakable = "breakable";

    public RascalDebugAdapter(DebugHandler debugHandler, Evaluator evaluator, IDEServices services, ExecutorService threadPool) {
        this.debugHandler = debugHandler;
        this.evaluator = evaluator;
        this.services = services;
        this.ownExecutor = threadPool;
        this.suspendedState = new SuspendedState(evaluator, services);
        this.breakpointsCollection = new BreakpointsCollection(debugHandler);
        this.eventTrigger = new RascalDebugEventTrigger(this, this.breakpointsCollection, this.suspendedState, debugHandler);
        debugHandler.setEventTrigger(this.eventTrigger);
        this.columns = new ColumnMaps(l -> {
            try {
                return Prelude.consumeInputStream(URIResolverRegistry.getInstance().getCharacterReader(l.top()));
            }
            catch (IOException e) {
                services.warning("Could not read contents of " + l.top(), (ISourceLocation)l);
                return "";
            }
        });
    }

    public void connect(IDebugProtocolClient client) {
        this.client = client;
        this.eventTrigger.setDebugProtocolClient(client);
    }

    @Override
    public CompletableFuture<Capabilities> initialize(InitializeRequestArguments args) {
        Boolean linesStartAt1 = args.getLinesStartAt1();
        Boolean columnsStartAt1 = args.getColumnsStartAt1();
        if (linesStartAt1 != null && !linesStartAt1.booleanValue()) {
            this.lineBase = 0;
        }
        if (columnsStartAt1 != null && !columnsStartAt1.booleanValue()) {
            this.columnBase = 0;
        }
        return CompletableFuture.supplyAsync(() -> {
            Capabilities capabilities = new Capabilities();
            capabilities.setSupportsConfigurationDoneRequest(true);
            capabilities.setExceptionBreakpointFilters(new ExceptionBreakpointsFilter[0]);
            capabilities.setSupportsStepBack(false);
            capabilities.setSupportsRestartFrame(false);
            capabilities.setSupportsSetVariable(false);
            capabilities.setSupportsRestartRequest(false);
            return capabilities;
        }, this.ownExecutor);
    }

    @Override
    public CompletableFuture<SetBreakpointsResponse> setBreakpoints(SetBreakpointsArguments args) {
        return CompletableFuture.supplyAsync(() -> {
            ITree parseTree;
            SetBreakpointsResponse response = new SetBreakpointsResponse();
            response.setBreakpoints(new Breakpoint[0]);
            String extension = args.getSource().getName().substring(args.getSource().getName().lastIndexOf(46) + 1);
            if (!extension.equals("rsc")) {
                return response;
            }
            ISourceLocation loc = this.getLocationFromPath(args.getSource().getPath());
            if (loc == null) {
                return response;
            }
            URIResolverRegistry reg = URIResolverRegistry.getInstance();
            if (!reg.exists(loc)) {
                return response;
            }
            String cannotSetMsg = String.format("Cannot set breakpoint%s", args.getBreakpoints().length > 1 ? "s" : "");
            try {
                parseTree = Reflective.parseModuleWithSpaces(loc);
            }
            catch (Throw t2) {
                IConstructor e;
                Type et;
                if (t2.getException().getType().isConstructor() && (et = (e = (IConstructor)t2.getException()).getConstructorType()) != RuntimeExceptionFactory.IO) {
                    this.services.warning(String.format("%s: %s", cannotSetMsg, t2.getMessage()), loc);
                }
                return response;
            }
            catch (ParseError e) {
                this.services.warning(String.format("%s: %s", cannotSetMsg, e.getMessage()), loc);
                return response;
            }
            this.breakpointsCollection.clearBreakpointsOfFile(loc.getPath());
            Breakpoint[] breakpoints = new Breakpoint[args.getBreakpoints().length];
            for (int i = 0; i < args.getBreakpoints().length; ++i) {
                SourceBreakpoint breakpoint = args.getBreakpoints()[i];
                ITree treeBreakableLocation = RascalDebugAdapter.locateBreakableTree(parseTree, breakpoint.getLine());
                if (treeBreakableLocation != null) {
                    ISourceLocation breakableLocation = TreeAdapter.getLocation(treeBreakableLocation);
                    this.breakpointsCollection.addBreakpoint(breakableLocation, args.getSource());
                }
                Breakpoint b = new Breakpoint();
                b.setId(i);
                b.setLine(breakpoint.getLine());
                b.setColumn(breakpoint.getColumn());
                b.setVerified(treeBreakableLocation != null);
                breakpoints[i] = b;
            }
            response.setBreakpoints(breakpoints);
            return response;
        }, this.ownExecutor);
    }

    private ISourceLocation getLocationFromPath(String path) {
        if (path.startsWith("/") || path.contains(":\\")) {
            try {
                return URIUtil.createFileLocation(path);
            }
            catch (URISyntaxException e) {
                this.services.warning(e.getMessage(), DEBUGGER_LOC);
                return null;
            }
        }
        URI uri = URI.create(path);
        try {
            String finalUri = uri.toString();
            Matcher matcher = this.emptyAuthorityPathPattern.matcher(finalUri);
            if (matcher.find()) {
                finalUri = finalUri.replaceFirst(":/", ":///");
            }
            return URIUtil.createFromURI(finalUri);
        }
        catch (URISyntaxException e) {
            this.services.warning(e.getMessage(), DEBUGGER_LOC);
            return null;
        }
    }

    private static ITree locateBreakableTree(ITree tree, int line) {
        ISourceLocation l = TreeAdapter.getLocation(tree);
        if (l == null) {
            throw new IllegalArgumentException("Missing location");
        }
        if (TreeAdapter.isAmb(tree)) {
            INode node = IRascalValueFactory.getInstance().node(breakable);
            if (ProductionAdapter.hasAttribute(TreeAdapter.getProduction(tree), IRascalValueFactory.getInstance().constructor(RascalValueFactory.Attr_Tag, node))) {
                return tree;
            }
            return null;
        }
        if (TreeAdapter.isAppl(tree) && !TreeAdapter.isLexical(tree)) {
            IList children = TreeAdapter.getArgs(tree);
            for (IValue child : children) {
                ITree result;
                ISourceLocation childLoc = TreeAdapter.getLocation((ITree)child);
                if (childLoc == null || childLoc.getBeginLine() > line || line > childLoc.getEndLine() || (result = RascalDebugAdapter.locateBreakableTree((ITree)child, line)) == null) continue;
                return result;
            }
        }
        INode node = IRascalValueFactory.getInstance().node(breakable);
        if (l.getBeginLine() == line && ProductionAdapter.hasAttribute(TreeAdapter.getProduction(tree), IRascalValueFactory.getInstance().constructor(RascalValueFactory.Attr_Tag, node))) {
            return tree;
        }
        return null;
    }

    @Override
    public CompletableFuture<Void> attach(Map<String, Object> args) {
        this.client.initialized();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> configurationDone(ConfigurationDoneArguments args) {
        return CompletableFuture.supplyAsync(() -> {
            ProcessEventArguments eventArgs = new ProcessEventArguments();
            eventArgs.setSystemProcessId((int)ProcessHandle.current().pid());
            eventArgs.setName("Rascal REPL");
            eventArgs.setIsLocalProcess(true);
            eventArgs.setStartMethod(ProcessEventArgumentsStartMethod.ATTACH);
            this.client.process(eventArgs);
            ThreadEventArguments thread = new ThreadEventArguments();
            thread.setThreadId(1);
            thread.setReason("started");
            this.client.thread(thread);
            return null;
        }, this.ownExecutor);
    }

    @Override
    public CompletableFuture<ThreadsResponse> threads() {
        return CompletableFuture.supplyAsync(() -> {
            ThreadsResponse response = new ThreadsResponse();
            Thread t2 = new Thread();
            t2.setId(1);
            t2.setName("Main Thread");
            response.setThreads(new Thread[]{t2});
            return response;
        }, this.ownExecutor);
    }

    @Override
    public CompletableFuture<StackTraceResponse> stackTrace(StackTraceArguments args) {
        if (args.getThreadId() != 1) {
            return CompletableFuture.completedFuture(new StackTraceResponse());
        }
        return CompletableFuture.supplyAsync(() -> {
            StackTraceResponse response = new StackTraceResponse();
            IRascalFrame[] stackFrames = this.suspendedState.getCurrentStackFrames();
            response.setTotalFrames(stackFrames.length);
            StackFrame[] stackFramesResponse = new StackFrame[stackFrames.length];
            IRascalFrame currentFrame = this.suspendedState.getCurrentStackFrame();
            ISourceLocation currentLoc = this.evaluator.getCurrentPointOfExecution() != null ? this.evaluator.getCurrentPointOfExecution() : URIUtil.rootLocation("stdin");
            stackFramesResponse[0] = this.createStackFrame(stackFrames.length - 1, currentLoc, currentFrame.getName());
            for (int i = 1; i < stackFramesResponse.length; ++i) {
                IRascalFrame f = stackFrames[stackFrames.length - i - 1];
                ISourceLocation loc = stackFrames[stackFrames.length - i].getCallerLocation();
                stackFramesResponse[i] = this.createStackFrame(stackFrames.length - i - 1, loc, f.getName());
            }
            response.setStackFrames(stackFramesResponse);
            return response;
        }, this.ownExecutor);
    }

    private int shiftLine(int line) {
        return line + this.lineBase - 1;
    }

    private int shiftColumn(int column) {
        return column + this.columnBase;
    }

    private StackFrame createStackFrame(int id, ISourceLocation loc, String name) {
        StackFrame frame = new StackFrame();
        frame.setId(id);
        frame.setName(name);
        if (loc != null) {
            LineColumnOffsetMap offsets = this.columns.get(loc);
            int line = this.shiftLine(loc.getBeginLine());
            int column = this.shiftColumn(offsets.translateColumn(loc.getBeginLine(), loc.getBeginColumn(), false));
            frame.setLine(line);
            frame.setColumn(column);
            frame.setSource(this.getSourceFromISourceLocation(loc));
        }
        return frame;
    }

    public Source getSourceFromISourceLocation(ISourceLocation loc) {
        Source source = new Source();
        File file = new File(loc.getPath());
        source.setName(file.getName());
        Object path = loc.getPath();
        if (!loc.getScheme().equals("file")) {
            path = loc.getScheme() + "://" + loc.getAuthority() + (String)path;
        }
        source.setPath((String)path);
        source.setSourceReference(-1);
        return source;
    }

    @Override
    public CompletableFuture<ScopesResponse> scopes(ScopesArguments args) {
        return CompletableFuture.supplyAsync(() -> {
            int frameId = args.getFrameId();
            ArrayList<Scope> scopes = new ArrayList<Scope>();
            IRascalFrame frame = this.suspendedState.getCurrentStackFrames()[frameId];
            ScopesResponse response = new ScopesResponse();
            scopes.add(this.createScope("Locals", frame.getFrameVariables().size(), "locals", frame.getFrameVariables().size() > 100, this.suspendedState.addScope(frame)));
            for (String importName : frame.getImports()) {
                IRascalFrame module = this.evaluator.getModule(importName);
                if (module == null || module.getFrameVariables().size() <= 0) continue;
                scopes.add(this.createScope("Module " + importName, module.getFrameVariables().size(), "module", module.getFrameVariables().size() > 100, this.suspendedState.addScope(module)));
            }
            response.setScopes(scopes.toArray(new Scope[scopes.size()]));
            return response;
        }, this.ownExecutor);
    }

    private Scope createScope(String name, int namedVariables, String presentationHint, boolean expensive, int variablesReference) {
        Scope scope = new Scope();
        scope.setName(name);
        scope.setNamedVariables(namedVariables);
        scope.setPresentationHint(presentationHint);
        scope.setExpensive(expensive);
        scope.setVariablesReference(variablesReference);
        return scope;
    }

    @Override
    public CompletableFuture<VariablesResponse> variables(VariablesArguments args) {
        return CompletableFuture.supplyAsync(() -> {
            int reference = args.getVariablesReference();
            int minIndex = args.getStart() != null ? args.getStart() : 0;
            int maxCount = args.getCount() != null ? args.getCount() : -1;
            VariablesResponse response = new VariablesResponse();
            List<RascalVariable> variables = this.suspendedState.getVariables(reference, minIndex, maxCount);
            response.setVariables((Variable[])variables.stream().map(var -> {
                Variable variable = new Variable();
                variable.setName(var.getName());
                variable.setType(var.getType().toString());
                variable.setValue(var.getDisplayValue());
                variable.setVariablesReference(var.getReferenceID());
                variable.setNamedVariables(var.getNamedVariables());
                variable.setIndexedVariables(var.getIndexedVariables());
                return variable;
            }).toArray(Variable[]::new));
            return response;
        }, this.ownExecutor);
    }

    @Override
    public CompletableFuture<ContinueResponse> continue_(ContinueArguments args) {
        return CompletableFuture.supplyAsync(() -> {
            ContinueResponse response = new ContinueResponse();
            response.setAllThreadsContinued(true);
            this.debugHandler.processMessage(DebugMessageFactory.requestResumption());
            return response;
        }, this.ownExecutor);
    }

    @Override
    public CompletableFuture<Void> next(NextArguments args) {
        return CompletableFuture.supplyAsync(() -> {
            this.debugHandler.processMessage(DebugMessageFactory.requestStepOver());
            return null;
        }, this.ownExecutor);
    }

    @Override
    public CompletableFuture<Void> disconnect(DisconnectArguments args) {
        this.ownExecutor.execute(new Runnable(){

            @Override
            public void run() {
                RascalDebugAdapter.this.debugHandler.processMessage(DebugMessageFactory.requestTermination());
                if (RascalDebugAdapter.this.suspendedState.isSuspended()) {
                    RascalDebugAdapter.this.debugHandler.processMessage(DebugMessageFactory.requestResumption());
                }
            }
        });
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> stepIn(StepInArguments args) {
        return CompletableFuture.supplyAsync(() -> {
            this.debugHandler.processMessage(DebugMessageFactory.requestStepInto());
            return null;
        }, this.ownExecutor);
    }

    @Override
    public CompletableFuture<Void> stepOut(StepOutArguments args) {
        return CompletableFuture.supplyAsync(() -> {
            this.debugHandler.processMessage(DebugMessageFactory.requestStepOut());
            return null;
        }, this.ownExecutor);
    }

    @Override
    public CompletableFuture<Void> pause(PauseArguments args) {
        return CompletableFuture.supplyAsync(() -> {
            this.debugHandler.processMessage(DebugMessageFactory.requestSuspension());
            return null;
        }, this.ownExecutor);
    }

    @Override
    public CompletableFuture<EvaluateResponse> evaluate(EvaluateArguments args) {
        return CompletableFuture.supplyAsync(() -> {
            EvaluateResponse response = new EvaluateResponse();
            String expr = args.getExpression();
            block7 : switch (args.getContext()) {
                case "hover": 
                case "clipboard": 
                case "repl": 
                case "watch": {
                    response.setResult("Only singular variable references are supported");
                    StringUtils.OffsetLengthTerm identSearchResult = StringUtils.findRascalIdentifierAtOffset(expr, 0);
                    if (identSearchResult == null || identSearchResult.offset != 0 || identSearchResult.length != expr.length()) break;
                    response.setResult("Undefined variable");
                    List<RascalVariable> variables = this.suspendedState.getVariables(args.getFrameId(), 0, -1);
                    for (RascalVariable var : variables) {
                        if (!var.getName().equals(expr)) continue;
                        response.setResult(var.getDisplayValue());
                        response.setType(var.getType().toString());
                        response.setVariablesReference(var.getReferenceID());
                        response.setNamedVariables(var.getNamedVariables());
                        response.setIndexedVariables(var.getIndexedVariables());
                        break block7;
                    }
                    break;
                }
                case "variables": {
                    response.setResult(expr);
                    break;
                }
            }
            return response;
        }, this.ownExecutor);
    }
}

