/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.values.parsetrees;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.io.StandardTextReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.rascalmpl.ast.CaseInsensitiveStringConstant;
import org.rascalmpl.ast.Char;
import org.rascalmpl.ast.Class;
import org.rascalmpl.ast.Nonterminal;
import org.rascalmpl.ast.Range;
import org.rascalmpl.ast.StringConstant;
import org.rascalmpl.ast.Sym;
import org.rascalmpl.ast.Type;
import org.rascalmpl.interpreter.asserts.NotYetImplemented;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.parser.ASTBuilder;
import org.rascalmpl.semantics.dynamic.QualifiedName;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.ValueFactoryFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.SymbolAdapter;

public class SymbolFactory {
    private static IValueFactory factory = ValueFactoryFactory.getValueFactory();
    private static ASTBuilder builder = new ASTBuilder();

    public static IConstructor typeToSymbol(ITree parseTree, boolean lex, String layout) {
        return SymbolFactory.typeToSymbol((Sym)builder.buildValue(parseTree), lex, layout);
    }

    public static IConstructor typeToSymbol(Sym type, boolean lex, String layout) {
        return (IConstructor)SymbolFactory.symbolAST2SymbolConstructor(type, lex, layout);
    }

    public static IConstructor typeToSymbol(Type type, boolean lex, String layout) {
        if (type.isUser()) {
            if (lex) {
                return factory.constructor(RascalValueFactory.Symbol_Lex, factory.string(((QualifiedName.Default)type.getUser().getName()).lastName()));
            }
            return factory.constructor(RascalValueFactory.Symbol_Sort, factory.string(Names.name(Names.lastName(type.getUser().getName()))));
        }
        if (type.isSymbol()) {
            return (IConstructor)SymbolFactory.symbolAST2SymbolConstructor(type.getSymbol(), lex, layout);
        }
        throw new RuntimeException("Can't convert type to symbol: " + type);
    }

    private static IValue symbolAST2SymbolConstructor(Sym symbol, boolean lex, String layout) {
        boolean noExpand;
        boolean bl = noExpand = lex || layout == null;
        if (symbol.isCaseInsensitiveLiteral()) {
            return SymbolFactory.ciliteral2Symbol(symbol.getCistring());
        }
        if (symbol.isCharacterClass()) {
            Class cc = symbol.getCharClass();
            return SymbolFactory.charclass2Symbol(cc);
        }
        if (symbol.isIter()) {
            if (noExpand) {
                return factory.constructor(RascalValueFactory.Symbol_Iter, SymbolFactory.symbolAST2SymbolConstructor(symbol.getSymbol(), lex, layout));
            }
            IConstructor layoutSymbol = factory.constructor(RascalValueFactory.Symbol_Layouts, factory.string(layout));
            IValue elementSym = SymbolFactory.symbolAST2SymbolConstructor(symbol.getSymbol(), lex, layout);
            IList seps = factory.list(layoutSymbol);
            return factory.constructor(RascalValueFactory.Symbol_IterSeps, elementSym, seps);
        }
        if (symbol.isIterStar()) {
            if (noExpand) {
                return factory.constructor(RascalValueFactory.Symbol_IterStar, SymbolFactory.symbolAST2SymbolConstructor(symbol.getSymbol(), lex, layout));
            }
            IConstructor layoutSymbol = factory.constructor(RascalValueFactory.Symbol_Layouts, factory.string(layout));
            IValue elementSym = SymbolFactory.symbolAST2SymbolConstructor(symbol.getSymbol(), lex, layout);
            IList seps = factory.list(layoutSymbol);
            return factory.constructor(RascalValueFactory.Symbol_IterStarSeps, elementSym, seps);
        }
        if (symbol.isIterSep()) {
            IConstructor layoutSymbol = factory.constructor(RascalValueFactory.Symbol_Layouts, factory.string(layout));
            IValue elementSym = SymbolFactory.symbolAST2SymbolConstructor(symbol.getSymbol(), lex, layout);
            IValue sepSym = SymbolFactory.symbolAST2SymbolConstructor(symbol.getSep(), lex, layout);
            IList seps = noExpand ? factory.list(sepSym) : factory.list(layoutSymbol, sepSym, layoutSymbol);
            return factory.constructor(RascalValueFactory.Symbol_IterSeps, elementSym, seps);
        }
        if (symbol.isIterStarSep()) {
            IConstructor layoutSymbol = factory.constructor(RascalValueFactory.Symbol_Layouts, factory.string(layout));
            IValue elementSym = SymbolFactory.symbolAST2SymbolConstructor(symbol.getSymbol(), lex, layout);
            IValue sepSym = SymbolFactory.symbolAST2SymbolConstructor(symbol.getSep(), lex, layout);
            IList seps = noExpand ? factory.list(sepSym) : factory.list(layoutSymbol, sepSym, layoutSymbol);
            return factory.constructor(RascalValueFactory.Symbol_IterStarSeps, elementSym, seps);
        }
        if (symbol.isLiteral()) {
            return SymbolFactory.literal2Symbol(symbol.getString());
        }
        if (symbol.isOptional()) {
            return factory.constructor(RascalValueFactory.Symbol_Opt, SymbolFactory.symbolAST2SymbolConstructor(symbol.getSymbol(), lex, layout));
        }
        if (symbol.isStart()) {
            Nonterminal nonterminal = symbol.getNonterminal();
            return factory.constructor(RascalValueFactory.Symbol_Start, factory.constructor(RascalValueFactory.Symbol_Sort, factory.string(((Nonterminal.Lexical)nonterminal).getString())));
        }
        if (symbol.isNonterminal()) {
            Nonterminal nonterminal = symbol.getNonterminal();
            IString name = factory.string(((Nonterminal.Lexical)nonterminal).getString());
            if (lex) {
                return factory.constructor(RascalValueFactory.Symbol_Lex, name);
            }
            return factory.constructor(RascalValueFactory.Symbol_Sort, name);
        }
        if (symbol.isSequence()) {
            List<Sym> symbols = symbol.getSequence();
            IConstructor layoutSymbol = factory.constructor(RascalValueFactory.Symbol_Layouts, factory.string(layout));
            IValue[] symValues = new IValue[noExpand ? symbols.size() : symbols.size() * 2 - 1];
            for (int i = symbols.size() - 1; i >= 0; i -= noExpand ? 1 : 2) {
                symValues[noExpand ? i : i * 2] = SymbolFactory.symbolAST2SymbolConstructor(symbols.get(i), lex, layout);
                if (noExpand || i <= 0) continue;
                symValues[i - 1] = layoutSymbol;
            }
            IList syms = factory.list(symValues);
            return factory.constructor(RascalValueFactory.Symbol_Seq, syms);
        }
        if (symbol.isAlternative()) {
            List<Sym> symbols = symbol.getAlternatives();
            IValue[] symValues = new IValue[symbols.size()];
            for (int i = symbols.size() - 1; i >= 0; --i) {
                symValues[i] = SymbolFactory.symbolAST2SymbolConstructor(symbols.get(i), lex, layout);
            }
            ISet syms = factory.set(symValues);
            return factory.constructor(RascalValueFactory.Symbol_Alt, syms);
        }
        if (symbol.isParametrized()) {
            List<Sym> symbols = symbol.getParameters();
            IValue[] symValues = new IValue[symbols.size()];
            for (int i = symbols.size() - 1; i >= 0; --i) {
                symValues[i] = SymbolFactory.symbolAST2SymbolConstructor(symbols.get(i), lex, layout);
            }
            IList syms = factory.list(symValues);
            return factory.constructor(RascalValueFactory.Symbol_ParameterizedSort, factory.string(((Nonterminal.Lexical)symbol.getNonterminal()).getString()), syms);
        }
        if (symbol.isParameter()) {
            IConstructor treeSymbol = factory.constructor(RascalValueFactory.Symbol_Adt, new IValue[]{factory.string("Tree"), factory.listWriter().done()});
            return factory.constructor(RascalValueFactory.Symbol_Parameter, factory.string(((Nonterminal.Lexical)symbol.getNonterminal()).getString()), treeSymbol);
        }
        if (symbol.isPrecede() || symbol.isNotPrecede() || symbol.isFollow() || symbol.isNotFollow() || symbol.isColumn() || symbol.isStartOfLine() || symbol.isEndOfLine() || symbol.isExcept()) {
            return SymbolFactory.symbolAST2SymbolConstructor(symbol.getSymbol(), lex, layout);
        }
        throw new RuntimeException("Symbol has unknown type: " + symbol);
    }

    private static IValue literal2Symbol(StringConstant sep) {
        try {
            String lit = ((StringConstant.Lexical)sep).getString();
            IValue string = new StandardTextReader().read(factory, new StringReader(lit));
            return factory.constructor(RascalValueFactory.Symbol_Lit, string);
        }
        catch (FactTypeUseException | IOException e) {
            throw new RuntimeException("Internal error: parsed stringconstant notation does not coincide with vallang stringconstant notation");
        }
    }

    private static IValue ciliteral2Symbol(CaseInsensitiveStringConstant constant) {
        try {
            Object lit = ((CaseInsensitiveStringConstant.Lexical)constant).getString();
            lit = "\"" + ((String)lit).substring(1, ((String)lit).length() - 1) + "\"";
            IValue string = new StandardTextReader().read(factory, new StringReader((String)lit));
            return factory.constructor(RascalValueFactory.Symbol_Cilit, string);
        }
        catch (FactTypeUseException | IOException e) {
            throw new RuntimeException("Internal error: parsed stringconstant notation does not coincide with vallang stringconstant notation");
        }
    }

    private static IConstructor charclass2Symbol(Class cc) {
        if (cc.isSimpleCharclass()) {
            return SymbolAdapter.normalizeCharClassRanges(SymbolAdapter.charclass(SymbolFactory.ranges2Ranges(cc.getRanges())));
        }
        if (cc.isComplement()) {
            return SymbolAdapter.complementCharClass(SymbolFactory.charclass2Symbol(cc.getCharClass()));
        }
        if (cc.isUnion()) {
            return SymbolAdapter.unionCharClasses(SymbolFactory.charclass2Symbol(cc.getLhs()), SymbolFactory.charclass2Symbol(cc.getRhs()));
        }
        if (cc.isIntersection()) {
            return SymbolAdapter.intersectCharClasses(SymbolFactory.charclass2Symbol(cc.getLhs()), SymbolFactory.charclass2Symbol(cc.getRhs()));
        }
        if (cc.isDifference()) {
            return SymbolAdapter.differencesCharClasses(SymbolFactory.charclass2Symbol(cc.getLhs()), SymbolFactory.charclass2Symbol(cc.getRhs()));
        }
        if (cc.isBracket()) {
            return SymbolFactory.charclass2Symbol(cc.getCharClass());
        }
        throw new NotYetImplemented(cc);
    }

    private static IList ranges2Ranges(List<Range> ranges) {
        IListWriter result = factory.listWriter();
        for (Range range : ranges) {
            if (range.isCharacter()) {
                IValue ch = SymbolFactory.char2int(range.getCharacter());
                result.append(factory.constructor(RascalValueFactory.CharRange_Range, ch, ch));
                continue;
            }
            if (!range.isFromTo()) continue;
            IValue from = SymbolFactory.char2int(range.getStart());
            IValue to = SymbolFactory.char2int(range.getEnd());
            result.append(factory.constructor(RascalValueFactory.CharRange_Range, from, to));
        }
        return (IList)result.done();
    }

    private static IValue char2int(Char character) {
        String s2 = ((Char.Lexical)character).getString();
        if (s2.startsWith("\\")) {
            if (ArrayUtils.contains(new int[]{97, 117, 85}, (int)s2.charAt(1))) {
                return factory.integer(Integer.parseUnsignedInt(s2.substring(2), 16));
            }
            int cha = s2.codePointAt(1);
            switch (cha) {
                case 116: {
                    return factory.integer(9);
                }
                case 110: {
                    return factory.integer(10);
                }
                case 114: {
                    return factory.integer(13);
                }
                case 102: {
                    return factory.integer(12);
                }
                case 98: {
                    return factory.integer(8);
                }
                case 34: {
                    return factory.integer(34);
                }
                case 39: {
                    return factory.integer(39);
                }
                case 45: {
                    return factory.integer(45);
                }
                case 60: {
                    return factory.integer(60);
                }
                case 62: {
                    return factory.integer(62);
                }
                case 92: {
                    return factory.integer(92);
                }
            }
            return factory.integer(cha);
        }
        int cha = s2.codePointAt(0);
        return factory.integer(cha);
    }

    public static IConstructor charClass(int ch) {
        return factory.constructor(RascalValueFactory.Symbol_CharClass, factory.list(factory.constructor(RascalValueFactory.CharRange_Range, factory.integer(ch), factory.integer(ch))));
    }

    public static IConstructor unionCharClasses(IConstructor lhs, IConstructor rhs) {
        if (lhs == rhs || lhs.equals(rhs)) {
            return lhs;
        }
        return SymbolFactory.charclass(SymbolFactory.unionRanges(SymbolAdapter.getRanges(lhs), SymbolAdapter.getRanges(rhs)));
    }

    public static IConstructor charclass(IList ranges) {
        return factory.constructor(RascalValueFactory.Symbol_CharClass, ranges);
    }

    public static IConstructor complementCharClass(IConstructor cc) {
        IConstructor everything = SymbolFactory.charclass(factory.list(SymbolFactory.range(1, 0x10FFFF)));
        return SymbolFactory.differencesCharClasses(everything, cc);
    }

    public static IConstructor differencesCharClasses(IConstructor lhs, IConstructor rhs) {
        if (lhs == rhs || lhs.equals(rhs)) {
            return factory.constructor(RascalValueFactory.Symbol_CharClass, factory.list(new IValue[0]));
        }
        return SymbolFactory.charclass(SymbolFactory.differenceRanges(SymbolAdapter.getRanges(lhs), SymbolAdapter.getRanges(rhs)));
    }

    private static IList newRange(int from, int to) {
        return from > to ? factory.list(new IValue[0]) : factory.list(SymbolFactory.range(from, to));
    }

    private static IList differenceRanges(IList l, IList r) {
        if (l.isEmpty() || r.isEmpty()) {
            return l;
        }
        IConstructor lhead = (IConstructor)l.get(0);
        IList ltail = l.delete(0);
        IConstructor rhead = (IConstructor)r.get(0);
        IList rtail = r.delete(0);
        if (SymbolFactory.rangeBegin(lhead) > SymbolFactory.rangeEnd(rhead)) {
            return SymbolFactory.differenceRanges(l, rtail);
        }
        if (SymbolFactory.rangeEnd(lhead) < SymbolFactory.rangeBegin(rhead)) {
            return SymbolFactory.differenceRanges(ltail, r).insert(lhead);
        }
        if (SymbolFactory.rangeBegin(lhead) >= SymbolFactory.rangeBegin(rhead) && SymbolFactory.rangeEnd(lhead) <= SymbolFactory.rangeEnd(rhead)) {
            return SymbolFactory.differenceRanges(ltail, r);
        }
        if (SymbolFactory.rangeBegin(rhead) >= SymbolFactory.rangeBegin(lhead) && SymbolFactory.rangeEnd(rhead) <= SymbolFactory.rangeEnd(lhead)) {
            return SymbolFactory.newRange(SymbolFactory.rangeBegin(lhead), SymbolFactory.rangeBegin(rhead) - 1).concat(SymbolFactory.differenceRanges(SymbolFactory.newRange(SymbolFactory.rangeEnd(rhead) + 1, SymbolFactory.rangeEnd(lhead)).concat(ltail), rtail));
        }
        if (SymbolFactory.rangeEnd(lhead) < SymbolFactory.rangeEnd(rhead)) {
            return SymbolFactory.newRange(SymbolFactory.rangeBegin(lhead), SymbolFactory.rangeBegin(rhead) - 1).concat(SymbolFactory.differenceRanges(ltail, r));
        }
        if (SymbolFactory.rangeBegin(lhead) > SymbolFactory.rangeBegin(rhead)) {
            return SymbolFactory.differenceRanges(SymbolFactory.newRange(SymbolFactory.rangeEnd(rhead) + 1, SymbolFactory.rangeEnd(lhead)).concat(ltail), rtail);
        }
        throw new IllegalArgumentException("did not expect to end up here! <l> - <r>");
    }

    public static IConstructor intersectCharClasses(IConstructor lhs, IConstructor rhs) {
        if (lhs == rhs || lhs.equals(rhs)) {
            return lhs;
        }
        return SymbolFactory.charclass(SymbolFactory.intersectRanges(SymbolAdapter.getRanges(lhs), SymbolAdapter.getRanges(rhs)));
    }

    private static IList intersectRanges(IList l, IList r) {
        if (l.isEmpty()) {
            return l;
        }
        if (r.isEmpty()) {
            return r;
        }
        IConstructor lhead = (IConstructor)l.get(0);
        IList ltail = l.delete(0);
        IConstructor rhead = (IConstructor)r.get(0);
        IList rtail = r.delete(0);
        if (SymbolFactory.rangeBegin(lhead) > SymbolFactory.rangeEnd(rhead)) {
            return SymbolFactory.intersectRanges(l, rtail);
        }
        if (SymbolFactory.rangeEnd(lhead) < SymbolFactory.rangeBegin(rhead)) {
            return SymbolFactory.intersectRanges(ltail, r);
        }
        if (SymbolFactory.rangeBegin(lhead) >= SymbolFactory.rangeBegin(rhead) && SymbolFactory.rangeEnd(lhead) <= SymbolFactory.rangeEnd(rhead)) {
            return SymbolFactory.intersectRanges(ltail, r).insert(lhead);
        }
        if (SymbolFactory.rangeBegin(rhead) >= SymbolFactory.rangeBegin(lhead) && SymbolFactory.rangeEnd(rhead) <= SymbolFactory.rangeEnd(lhead)) {
            return SymbolFactory.intersectRanges(l, rtail).insert(rhead);
        }
        if (SymbolFactory.rangeEnd(lhead) < SymbolFactory.rangeEnd(rhead)) {
            return SymbolFactory.intersectRanges(ltail, r).insert(SymbolFactory.range(SymbolFactory.rangeBegin(rhead), SymbolFactory.rangeEnd(lhead)));
        }
        if (SymbolFactory.rangeBegin(lhead) > SymbolFactory.rangeBegin(rhead)) {
            return SymbolFactory.intersectRanges(l, rtail).insert(SymbolFactory.range(SymbolFactory.rangeBegin(lhead), SymbolFactory.rangeEnd(rhead)));
        }
        throw new IllegalArgumentException("did not expect to end up here! <l> - <r>");
    }

    public static IConstructor normalizeCharClassRanges(IConstructor cc) {
        IList ranges = SymbolAdapter.getRanges(cc);
        IList result = factory.list(new IValue[0]);
        for (IValue range : ranges) {
            result = SymbolFactory.unionRanges(result, factory.list(range));
        }
        return SymbolFactory.charclass(result);
    }

    private static IList unionRanges(IList l, IList r) {
        if (l.isEmpty()) {
            return r;
        }
        if (r.isEmpty()) {
            return l;
        }
        IConstructor lhead = (IConstructor)l.get(0);
        IList ltail = l.delete(0);
        IConstructor rhead = (IConstructor)r.get(0);
        IList rtail = r.delete(0);
        if (SymbolFactory.rangeBegin(lhead) > SymbolFactory.rangeEnd(rhead) + 1) {
            return SymbolFactory.unionRanges(l, rtail).insert(rhead);
        }
        if (SymbolFactory.rangeEnd(lhead) + 1 < SymbolFactory.rangeBegin(rhead)) {
            return SymbolFactory.unionRanges(ltail, r).insert(lhead);
        }
        if (SymbolFactory.rangeBegin(lhead) >= SymbolFactory.rangeBegin(rhead) && SymbolFactory.rangeEnd(lhead) <= SymbolFactory.rangeEnd(rhead)) {
            return SymbolFactory.unionRanges(ltail, r);
        }
        if (SymbolFactory.rangeBegin(rhead) >= SymbolFactory.rangeBegin(lhead) && SymbolFactory.rangeEnd(rhead) <= SymbolFactory.rangeEnd(lhead)) {
            return SymbolFactory.unionRanges(l, rtail);
        }
        if (SymbolFactory.rangeEnd(lhead) < SymbolFactory.rangeEnd(rhead)) {
            return SymbolFactory.unionRanges(ltail.insert(SymbolFactory.range(SymbolFactory.rangeBegin(lhead), SymbolFactory.rangeEnd(rhead))), rtail);
        }
        if (SymbolFactory.rangeBegin(lhead) > SymbolFactory.rangeBegin(rhead)) {
            return SymbolFactory.unionRanges(ltail, rtail.insert(SymbolFactory.range(SymbolFactory.rangeBegin(rhead), SymbolFactory.rangeEnd(lhead))));
        }
        throw new IllegalArgumentException("did not expect to end up here! union(<l>,<r>)");
    }

    private static IConstructor range(int begin, int end) {
        return factory.constructor(RascalValueFactory.CharRange_Range, factory.integer(begin), factory.integer(end));
    }

    private static int rangeBegin(IConstructor range) {
        return ((IInteger)range.get("begin")).intValue();
    }

    private static int rangeEnd(IConstructor range) {
        return ((IInteger)range.get("end")).intValue();
    }
}

