/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;

public class BigDecimalCalculations {
    public static final BigDecimal PI = new BigDecimal("3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679821480865132823066470938446095505822317253594081284811174502841027019385211055596446229489549303819644288109756659334461284756482337867831652712019091456485669234603486104543266482133936072602491412737245870066063155881748815209209628292540917153643678925903600113305305488204665213841469519415116094330572703657595919530921861173819326117931051185480744623799627495673518857527248912279381830119491298336733624406566430860213949463952247371907021798609437027705392171762931767523846748184676694051320005681271452635608277857713427577896091736371787214684409012249534301465495853710507922796892589235420199561121290219608640344181598136297747713099605187072113499999983729780499510597317328160963185950244594553469083026425223082533446850352619311881710100031378387528865875332083814206171776691473035982534904287554687311595628638823537875937519577818577805321712268066130019278766111959092164201988");
    public static final BigDecimal halfPI = PI.divide(new BigDecimal(2));
    public static final BigDecimal twoPI = PI.multiply(new BigDecimal(2));
    public static final BigDecimal E = new BigDecimal("2.71828182845904523536028747135266249775724709369995957496696762772407663035354759457138217852516642742746639193200305992181741359662904357290033429526059563073813232862794349076323382988075319525101901157383418793070215408914993488416750924476146066808226480016847741185374234544243710753907774499206955170276183860626133138458300075204493382656029760673711320070932870912744374704723069697720931014169283681902551510865746377211125238978442505695369677078544996996794686445490598793163688923009879312773617821542499922957635148220826989519366803318252886939849646510582093923982948879332036250944311730123819706841614039701983767932068328237646480429531180232878250981945581530175671736133206981125099618188159304169035159888851934580727386673858942287922849989208680582574927961048419844436346324496848756023362482704197862320900216099023530436994184914631409343173814364054625315209618369088870701676839642437814059271456354906130310720851038375051011574770417189861068739696552126715468895703503540");
    private static final BigDecimal sincosNormalizePoint = BigDecimal.valueOf(500L);
    private static BigInteger maxBigDecimalPowExp = BigInteger.valueOf(999999999L);

    public static BigDecimal sin(BigDecimal x, int scale) {
        if (x.signum() == 0) {
            return BigDecimal.ZERO;
        }
        if (x.abs().compareTo(sincosNormalizePoint) >= 0) {
            x = x.remainder(twoPI, new MathContext(scale + 1));
        }
        if (x.signum() == -1) {
            return BigDecimalCalculations.sinTaylor(x.negate(), scale).negate();
        }
        return BigDecimalCalculations.sinTaylor(x, scale);
    }

    private static BigDecimal calculateConvergenceTolerance(int scale) {
        return BigDecimal.valueOf(5L).movePointLeft(scale + 1);
    }

    private static BigDecimal sinTaylor(BigDecimal x, int scale) {
        BigDecimal term;
        int sp1 = scale + 1;
        int i = 3;
        boolean addFlag = false;
        BigDecimal power = x;
        BigDecimal result = x;
        BigDecimal fac = new BigDecimal(6);
        BigDecimal tolerance = BigDecimalCalculations.calculateConvergenceTolerance(scale);
        do {
            power = power.multiply(x).multiply(x).setScale(sp1, RoundingMode.HALF_EVEN);
            term = power.divide(fac, sp1, RoundingMode.HALF_EVEN);
            result = addFlag ? result.add(term) : result.subtract(term);
            fac = fac.multiply(BigDecimal.valueOf((i += 2) - 1)).multiply(BigDecimal.valueOf(i));
            boolean bl = addFlag = !addFlag;
        } while (term.compareTo(tolerance) > 0);
        return result;
    }

    public static BigDecimal cos(BigDecimal x, int scale) {
        if (x.signum() == 0) {
            return BigDecimal.ONE;
        }
        if (x.abs().compareTo(sincosNormalizePoint) >= 0) {
            x = x.remainder(twoPI, new MathContext(scale + 1));
        }
        if (x.signum() == -1) {
            return BigDecimalCalculations.cosTaylor(x.negate(), scale);
        }
        return BigDecimalCalculations.cosTaylor(x, scale);
    }

    private static BigDecimal cosTaylor(BigDecimal x, int scale) {
        BigDecimal term;
        int sp1 = scale + 1;
        int i = 2;
        boolean addFlag = false;
        BigDecimal power = BigDecimal.ONE;
        BigDecimal result = BigDecimal.ONE;
        BigDecimal fac = new BigDecimal(2);
        BigDecimal tolerance = BigDecimalCalculations.calculateConvergenceTolerance(scale);
        do {
            power = power.multiply(x).multiply(x).setScale(sp1, RoundingMode.HALF_EVEN);
            term = power.divide(fac, sp1, RoundingMode.HALF_EVEN);
            result = addFlag ? result.add(term) : result.subtract(term);
            fac = fac.multiply(BigDecimal.valueOf((i += 2) - 1)).multiply(BigDecimal.valueOf(i));
            boolean bl = addFlag = !addFlag;
        } while (term.compareTo(tolerance) > 0);
        return result;
    }

    public static BigDecimal tan(BigDecimal x, int scale) {
        if (x.signum() == 0) {
            return BigDecimal.ZERO;
        }
        if (x.abs().compareTo(halfPI) > 0) {
            throw new ArithmeticException("x should be between -(pi/2) and (pi/2)");
        }
        return BigDecimalCalculations.sin(x, scale + 1).divide(BigDecimalCalculations.cos(x, scale + 1), scale, RoundingMode.HALF_UP);
    }

    private static BigDecimal intPower(BigDecimal x, BigInteger exponent, int scale) {
        boolean negativeExponent;
        boolean bl = negativeExponent = exponent.signum() == -1;
        if (negativeExponent) {
            exponent = exponent.negate();
        }
        if (exponent.equals(BigInteger.ZERO)) {
            return BigDecimal.ONE.setScale(scale);
        }
        MathContext mc = new MathContext(scale, RoundingMode.HALF_EVEN);
        if (exponent.equals(BigInteger.ONE)) {
            if (negativeExponent) {
                return BigDecimal.ONE.divide(x, mc);
            }
            return x.setScale(scale, RoundingMode.HALF_EVEN);
        }
        BigDecimal result = BigDecimal.valueOf(1L);
        if (exponent.compareTo(maxBigDecimalPowExp) >= 0) {
            BigDecimal maxExpPow = x.pow(maxBigDecimalPowExp.intValue(), mc);
            while (exponent.compareTo(maxBigDecimalPowExp) >= 0) {
                result = result.multiply(maxExpPow);
                exponent = exponent.subtract(maxBigDecimalPowExp);
            }
        }
        result = result.multiply(x.pow(exponent.intValue(), mc));
        if (negativeExponent) {
            return BigDecimal.ONE.divide(result, mc);
        }
        return result.setScale(scale, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal intRoot(BigDecimal x, BigInteger index, int scale) {
        BigDecimal xPrev;
        BigDecimal numerator;
        BigDecimal denominator;
        if (x.signum() < 0) {
            throw new ArithmeticException("x < 0");
        }
        int sp1 = scale + 1;
        BigDecimal n = x;
        BigDecimal i = new BigDecimal(index);
        BigDecimal im1 = i.subtract(BigDecimal.ONE);
        BigDecimal tolerance = BigDecimal.valueOf(5L).movePointLeft(sp1);
        BigInteger indexm1 = index.subtract(BigInteger.ONE);
        x = x.divide(i, scale, RoundingMode.HALF_EVEN);
        do {
            BigDecimal xToIm1 = BigDecimalCalculations.intPower(x, indexm1, sp1 + 1);
            BigDecimal xToI = x.multiply(xToIm1);
            numerator = n.add(im1.multiply(xToI));
            denominator = i.multiply(xToIm1);
            xPrev = x;
        } while ((x = denominator.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(sp1) : numerator.divide(denominator, sp1, RoundingMode.DOWN)).subtract(xPrev).abs().compareTo(tolerance) > 0);
        return x.setScale(scale, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal exp(BigDecimal x, int scale) {
        BigDecimal result;
        BigDecimal xWhole;
        boolean isNegative;
        if (x.signum() == 0) {
            return BigDecimal.valueOf(1L);
        }
        boolean bl = isNegative = x.signum() == -1;
        if (isNegative) {
            x = x.negate();
        }
        if ((xWhole = x.setScale(0, RoundingMode.DOWN)).signum() == 0) {
            result = BigDecimalCalculations.expTaylor(x, scale);
        } else {
            BigDecimal xFraction = x.subtract(xWhole);
            BigDecimal z = BigDecimal.valueOf(1L).add(xFraction.divide(xWhole, scale, RoundingMode.HALF_EVEN));
            BigDecimal t2 = BigDecimalCalculations.expTaylor(z, scale);
            result = BigDecimalCalculations.intPower(t2, xWhole.toBigInteger(), scale);
        }
        if (isNegative) {
            return BigDecimal.ONE.divide(result, new MathContext(scale, RoundingMode.HALF_EVEN));
        }
        return result;
    }

    private static BigDecimal expTaylor(BigDecimal x, int scale) {
        BigDecimal sumPrev;
        BigDecimal factorial = BigDecimal.valueOf(1L);
        BigDecimal xPower = x;
        BigDecimal sum = x.add(BigDecimal.valueOf(1L));
        int i = 2;
        do {
            xPower = xPower.multiply(x).setScale(scale, RoundingMode.HALF_EVEN);
            factorial = factorial.multiply(BigDecimal.valueOf(i));
            BigDecimal term = xPower.divide(factorial, scale, RoundingMode.HALF_EVEN);
            sumPrev = sum;
            sum = sum.add(term);
            ++i;
        } while (sum.compareTo(sumPrev) != 0);
        return sum;
    }

    public static BigDecimal ln(BigDecimal x, int scale) {
        if (x.signum() <= 0) {
            throw new ArithmeticException("x <= 0");
        }
        int magnitude = x.toString().length() - x.scale() - 1;
        if (magnitude < 3) {
            return BigDecimalCalculations.lnNewton(x, scale);
        }
        BigDecimal root = BigDecimalCalculations.intRoot(x, BigInteger.valueOf(magnitude), scale);
        BigDecimal lnRoot = BigDecimalCalculations.lnNewton(root, scale);
        return BigDecimal.valueOf(magnitude).multiply(lnRoot).setScale(scale, RoundingMode.HALF_EVEN);
    }

    private static BigDecimal lnNewton(BigDecimal x, int scale) {
        BigDecimal eToX;
        int sp1 = scale + 1;
        BigDecimal n = x;
        BigDecimal tolerance = BigDecimal.valueOf(5L).movePointLeft(sp1);
        while ((eToX = BigDecimalCalculations.exp(x, sp1)).compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal term = eToX.subtract(n).divide(eToX, sp1, RoundingMode.DOWN);
            x = x.subtract(term);
            if (term.compareTo(tolerance) > 0) continue;
        }
        return x.setScale(scale, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal sqrt(BigDecimal x, int scale) {
        BigInteger ixPrev;
        if (x.signum() < 0) {
            throw new ArithmeticException("x < 0");
        }
        if (x.signum() == 0) {
            return BigDecimal.ZERO.setScale(scale);
        }
        BigInteger n = x.movePointRight(scale << 1).toBigInteger();
        int bits = n.bitLength() + 1 >> 1;
        BigInteger ix = n.shiftRight(bits);
        do {
            ixPrev = ix;
        } while ((ix = ix.add(n.divide(ix)).shiftRight(1)).compareTo(ixPrev) != 0);
        return new BigDecimal(ix, scale);
    }

    public static BigDecimal pow(BigDecimal a, BigDecimal b, int scale) {
        if (a.signum() == -1) {
            throw new ArithmeticException("x < 0");
        }
        if (a.equals(BigDecimal.ZERO)) {
            return BigDecimal.ZERO;
        }
        scale = Math.max(Math.max(a.precision(), b.precision()), scale) + 1;
        MathContext mc = new MathContext(scale, RoundingMode.HALF_UP);
        BigDecimal remainer = b.remainder(BigDecimal.ONE, mc);
        if (remainer.equals(BigDecimal.ZERO)) {
            return a.pow(b.intValue(), mc);
        }
        return BigDecimalCalculations.exp(b.multiply(BigDecimalCalculations.ln(a, scale), mc), scale).setScale(scale - 1, RoundingMode.HALF_EVEN);
    }
}

