/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.random.util;

import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.UndeclaredAbstractDataTypeException;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class RandomUtil {
    private static final StringGen alphaOnly = new CharRanges(new int[]{97, 65}, new int[]{122, 90});
    private static final StringGen numeric = new CharRanges(new int[]{48}, new int[]{57});
    private static final StringGen generalStrangeChars = new CharRanges(new int[]{0, 33, 161}, new int[]{9, 47, 172});
    private static final StringGen normalUnicode = new CharRanges(new int[]{256, 13312, 53248}, new int[]{512, 19712, 55040});
    private static final StringGen strangeUnicode = new CharRanges(new int[]{73728, 131072}, new int[]{74879, 136703});
    private static final StringGen whiteSpace = new CharSets(32, 9, 10, 9);
    private static final StringGen strangeWhiteSpace = new CharSets(133, 160, 5760, 8192, 8232, 8233, 8287, 12288);
    private static final StringGen rascalEscapes = new CharSets(34, 39, 62, 92, 60, 64, 96);
    private static final StringGen[] generators = new StringGen[]{alphaOnly, new MixGenerators(alphaOnly, numeric), new MixGenerators(alphaOnly, numeric), numeric, normalUnicode, new MixGenerators(alphaOnly, numeric, generalStrangeChars), new MixGenerators(alphaOnly, numeric, whiteSpace), new MixGenerators(strangeWhiteSpace, whiteSpace), new MixGenerators(normalUnicode, strangeUnicode), new MixGenerators(alphaOnly, numeric, rascalEscapes), new MixGenerators(alphaOnly, numeric, generalStrangeChars, normalUnicode, whiteSpace, rascalEscapes)};

    private static boolean validCodePoint(int cp) {
        return Character.isDefined(cp) && Character.isValidCodePoint(cp) && Character.getType(cp) != 0;
    }

    private static String sanitize(String unclean) {
        char[] chars = unclean.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isHighSurrogate(c)) {
                if (++i < chars.length) {
                    int cp = Character.toCodePoint(c, chars[i]);
                    if (RandomUtil.validCodePoint(cp) && Character.isSurrogatePair(c, chars[i])) continue;
                    chars[i - 1] = 95;
                    chars[i] = 95;
                    continue;
                }
                chars[i - 1] = 95;
                continue;
            }
            if (Character.isLowSurrogate(c)) {
                chars[i] = 95;
                continue;
            }
            if (RandomUtil.validCodePoint(c)) continue;
            chars[i] = 95;
        }
        return new String(chars);
    }

    public static boolean oneEvery(Random random, int n) {
        return random.nextInt(n) == 0;
    }

    public static String string(Random rand, int depth) {
        StringGen randomGenerator = generators[rand.nextInt(generators.length)];
        StringBuilder result = new StringBuilder(depth * 2);
        randomGenerator.generate(rand, depth, result);
        return RandomUtil.sanitize(result.toString());
    }

    public static String stringAlphaNumeric(Random rand, int depth) {
        StringBuilder result = new StringBuilder(depth);
        new MixGenerators(alphaOnly, numeric).generate(rand, depth, result);
        return RandomUtil.sanitize(result.toString());
    }

    public static String stringAlpha(Random rand, int depth) {
        StringBuilder result = new StringBuilder(depth);
        alphaOnly.generate(rand, depth, result);
        return RandomUtil.sanitize(result.toString());
    }

    public static String stringNumeric(Random rand, int depth) {
        StringBuilder result = new StringBuilder(depth);
        numeric.generate(rand, depth, result);
        return RandomUtil.sanitize(result.toString());
    }

    public static String stringAllKindsOfWhitespace(Random rand, int depth) {
        StringBuilder result = new StringBuilder(depth);
        new MixGenerators(whiteSpace, strangeWhiteSpace).generate(rand, depth, result);
        return RandomUtil.sanitize(result.toString());
    }

    public static IValue randomADT(Type type, Random random, TypeFactory.RandomTypesConfig typesConfig, IValueFactory vf, TypeStore store, Map<Type, Type> typeParameters, int maxDepth, int maxWidth) {
        Type uninstantiatedADT = store.lookupAbstractDataType(type.getName());
        if (uninstantiatedADT == null) {
            throw new UndeclaredAbstractDataTypeException(type);
        }
        HashMap<Type, Type> bindings = new HashMap<Type, Type>();
        uninstantiatedADT.match(type, bindings);
        Set<Type> candidates = store.lookupAlternatives(uninstantiatedADT);
        if (candidates.isEmpty()) {
            throw new RuntimeException("can not generate constructors for non-existing ADT: " + String.valueOf(type));
        }
        Type constructor = RandomUtil.pickRandom(random, candidates);
        if (maxDepth <= 0) {
            Type original = constructor;
            Iterator<Type> it = candidates.iterator();
            while (RandomUtil.alwaysIncreasesDepth(constructor) && it.hasNext()) {
                constructor = it.next();
            }
            if (RandomUtil.alwaysIncreasesDepth(constructor)) {
                constructor = original;
            }
        }
        return RandomUtil.generateConstructor(constructor, random, typesConfig, vf, store, bindings, maxDepth, maxWidth);
    }

    private static boolean alwaysIncreasesDepth(Type constructor) {
        for (int i = 0; i < constructor.getArity(); ++i) {
            Type argType = constructor.getFieldType(i);
            if (argType.isAbstractData()) {
                return true;
            }
            if (!argType.isTuple() || !RandomUtil.alwaysIncreasesDepth(argType)) continue;
            return true;
        }
        return false;
    }

    private static Type pickRandom(Random random, Collection<Type> types) {
        int nth = random.nextInt(types.size());
        int index = 0;
        for (Type t2 : types) {
            if (index == nth) {
                return t2;
            }
            ++index;
        }
        throw new AssertionError((Object)"Dead code");
    }

    private static IValue generateConstructor(Type type, Random random, TypeFactory.RandomTypesConfig typesConfig, IValueFactory vf, TypeStore store, Map<Type, Type> bindings, int maxDepth, int maxWidth) {
        Map<String, Type> kwParamsType = store.getKeywordParameters(type);
        if (type.getArity() == 0 && kwParamsType.size() == 0) {
            return vf.constructor(type);
        }
        IValue[] args = new IValue[type.getArity()];
        Type instantiatedConstructor = type.instantiate(bindings);
        for (int i = 0; i < args.length; ++i) {
            args[i] = instantiatedConstructor.getFieldType(i).randomValue(random, typesConfig, vf, store, bindings, maxDepth - 1, maxWidth);
        }
        if (kwParamsType.size() > 0 && random.nextInt(3) == 0 && maxDepth > 0) {
            return vf.constructor(type, args, RandomUtil.generateMappedArgs(kwParamsType, random, typesConfig, vf, store, bindings, maxDepth - 1, maxWidth));
        }
        return vf.constructor(type, args);
    }

    private static Map<String, IValue> generateMappedArgs(Map<String, Type> types, Random random, TypeFactory.RandomTypesConfig typesConfig, IValueFactory vf, TypeStore store, Map<Type, Type> bindings, int maxDepth, int maxWidth) {
        HashMap<String, IValue> result = new HashMap<String, IValue>();
        for (Map.Entry<String, Type> tp : types.entrySet()) {
            if (random.nextBoolean()) continue;
            result.put(tp.getKey(), tp.getValue().randomValue(random, typesConfig, vf, store, bindings, maxDepth, maxWidth));
        }
        return result;
    }

    private static class MixGenerators
    implements StringGen {
        private StringGen[] generators;

        public MixGenerators(StringGen ... generators) {
            this.generators = generators;
        }

        @Override
        public void generate(Random rand, int length, StringBuilder result) {
            int chunk;
            for (int left = length; left > 0; left -= chunk) {
                chunk = 1 + rand.nextInt(left);
                this.generators[rand.nextInt(this.generators.length)].generate(rand, chunk, result);
            }
        }
    }

    private static class CharSets
    implements StringGen {
        private int[] chars;

        public CharSets(int ... chars) {
            this.chars = chars;
        }

        @Override
        public void generate(Random rand, int length, StringBuilder result) {
            for (int c = 0; c < length; ++c) {
                result.appendCodePoint(this.chars[rand.nextInt(this.chars.length)]);
            }
        }
    }

    private static class CharRanges
    implements StringGen {
        private int[] start;
        private int[] stop;

        public CharRanges(int[] start, int[] stop) {
            assert (start.length == stop.length);
            this.start = start;
            this.stop = stop;
        }

        @Override
        public void generate(Random rand, int length, StringBuilder result) {
            for (int c = 0; c < length; ++c) {
                int r = rand.nextInt(this.start.length);
                result.appendCodePoint(this.generateCodePoint(rand, this.start[r], this.stop[r]));
            }
        }

        private int generateCodePoint(Random rand, int start, int stop) {
            int range = stop - start;
            int result = 0;
            while (!RandomUtil.validCodePoint(result = start + rand.nextInt(range + 1))) {
            }
            return result;
        }
    }

    private static interface StringGen {
        public void generate(Random var1, int var2, StringBuilder var3);
    }
}

