/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Statement;

public abstract class FunctionBody
extends AbstractAST {
    public FunctionBody(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasStatements() {
        return false;
    }

    public List<Statement> getStatements() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isDefault() {
        return false;
    }

    public static class Default
    extends FunctionBody {
        private final List<Statement> statements;

        public Default(ISourceLocation src, IConstructor node, List<Statement> statements) {
            super(src, node);
            this.statements = statements;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitFunctionBodyDefault(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            for (AbstractAST abstractAST : this.statements) {
                ISourceLocation $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Default)) {
                return false;
            }
            Default tmp = (Default)o;
            return tmp.statements.equals(this.statements);
        }

        @Override
        public int hashCode() {
            return 29 + 571 * this.statements.hashCode();
        }

        @Override
        public List<Statement> getStatements() {
            return this.statements;
        }

        @Override
        public boolean hasStatements() {
            return true;
        }

        @Override
        public Object clone() {
            return Default.newInstance(this.getClass(), this.src, null, this.clone(this.statements));
        }
    }
}

