/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.KeywordArgument_Expression;
import org.rascalmpl.ast.OptionalComma;

public abstract class KeywordArguments_Expression
extends AbstractAST {
    public KeywordArguments_Expression(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasKeywordArgumentList() {
        return false;
    }

    public List<KeywordArgument_Expression> getKeywordArgumentList() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasOptionalComma() {
        return false;
    }

    public OptionalComma getOptionalComma() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isDefault() {
        return false;
    }

    public boolean isNone() {
        return false;
    }

    public static class None
    extends KeywordArguments_Expression {
        public None(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isNone() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitKeywordArguments_ExpressionNone(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof None)) {
                return false;
            }
            None tmp = (None)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 239;
        }

        @Override
        public Object clone() {
            return None.newInstance(this.getClass(), this.src, null);
        }
    }

    public static class Default
    extends KeywordArguments_Expression {
        private final OptionalComma optionalComma;
        private final List<KeywordArgument_Expression> keywordArgumentList;

        public Default(ISourceLocation src, IConstructor node, OptionalComma optionalComma, List<KeywordArgument_Expression> keywordArgumentList) {
            super(src, node);
            this.optionalComma = optionalComma;
            this.keywordArgumentList = keywordArgumentList;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitKeywordArguments_ExpressionDefault(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.optionalComma.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.optionalComma.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.keywordArgumentList) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Default)) {
                return false;
            }
            Default tmp = (Default)o;
            return tmp.optionalComma.equals(this.optionalComma) && tmp.keywordArgumentList.equals(this.keywordArgumentList);
        }

        @Override
        public int hashCode() {
            return 823 + 43 * this.optionalComma.hashCode() + 733 * this.keywordArgumentList.hashCode();
        }

        @Override
        public OptionalComma getOptionalComma() {
            return this.optionalComma;
        }

        @Override
        public boolean hasOptionalComma() {
            return true;
        }

        @Override
        public List<KeywordArgument_Expression> getKeywordArgumentList() {
            return this.keywordArgumentList;
        }

        @Override
        public boolean hasKeywordArgumentList() {
            return true;
        }

        @Override
        public Object clone() {
            return Default.newInstance(this.getClass(), this.src, null, this.clone(this.optionalComma), this.clone(this.keywordArgumentList));
        }
    }
}

