/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.exceptions;

import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.exceptions.StackTrace;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.interpreter.env.Environment;

public class RascalStackOverflowError
extends RuntimeException {
    private static final long serialVersionUID = -3947588548271683963L;
    private final Environment deepestEnvironment;
    private final AbstractAST currentAST;

    public RascalStackOverflowError(AbstractAST current, Environment deepest) {
        this.deepestEnvironment = deepest;
        this.currentAST = current;
    }

    public Throw makeThrow() {
        StackTrace trace = new StackTrace();
        for (Environment env = this.deepestEnvironment; env != null; env = env.getCallerScope()) {
            trace.add(env.getLocation(), env.getName());
        }
        return RuntimeExceptionFactory.stackOverflow(this.currentAST, trace);
    }

    public Environment getEnvironment() {
        return this.deepestEnvironment;
    }
}

