/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ideservices;

import engineering.swat.watch.DaemonThreadPool;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.jline.terminal.Terminal;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.ideservices.BasicIDEServices;
import org.rascalmpl.ideservices.GsonUtils;
import org.rascalmpl.ideservices.IRemoteIDEServices;
import org.rascalmpl.uri.URIUtil;

public class RemoteIDEServices
extends BasicIDEServices {
    private final IRemoteIDEServices server;

    public RemoteIDEServices(int ideServicesPort, PrintWriter stderr, IRascalMonitor monitor, Terminal terminal, ISourceLocation projectRoot) {
        super(stderr, monitor, terminal, projectRoot);
        try {
            Socket socket = new Socket(InetAddress.getLoopbackAddress(), ideServicesPort);
            socket.setTcpNoDelay(true);
            Launcher<IRemoteIDEServices> clientLauncher = new Launcher.Builder<IRemoteIDEServices>().setRemoteInterface(IRemoteIDEServices.class).setLocalService(this).setInput(socket.getInputStream()).setOutput(socket.getOutputStream()).configureGson(GsonUtils::configureGson).setExecutorService(DaemonThreadPool.buildConstrainedCached("rascal-ide-services", Math.max(2, Math.min(6, Runtime.getRuntime().availableProcessors() - 2)))).create();
            clientLauncher.startListening();
            this.server = clientLauncher.getRemoteProxy();
        }
        catch (Throwable e) {
            throw new RuntimeException("Error setting up Remote IDE Services connection", e);
        }
    }

    @Override
    public void edit(ISourceLocation loc, int viewColumn) {
        this.server.edit(loc, viewColumn);
    }

    @Override
    public void browse(URI uri, IString title, IInteger viewColumn) {
        this.server.browse(uri, title, viewColumn);
    }

    @Override
    public ISourceLocation resolveProjectLocation(ISourceLocation input) {
        try {
            return this.server.resolveProjectLocation(input).get(1L, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            this.warning("Error resolving project location", URIUtil.unknownLocation());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return input;
    }

    @Override
    public void startDebuggingSession(int serverPort) {
        this.server.startDebuggingSession(serverPort);
    }

    @Override
    public void registerDebugServerPort(int processID, int serverPort) {
        this.server.registerDebugServerPort(processID, serverPort);
    }

    @Override
    public void applyFileSystemEdits(IList edits) {
        this.server.applyDocumentsEdits(new IRemoteIDEServices.DocumentEditsParameter(edits));
    }

    @Override
    public void registerDiagnostics(IList messages, ISourceLocation projectRoot) {
        this.server.registerDiagnostics(new IRemoteIDEServices.RegisterDiagnosticsParameters(messages));
    }

    @Override
    public void unregisterDiagnostics(IList resources) {
        this.server.unregisterDiagnostics((ISourceLocation[])resources.stream().map(ISourceLocation.class::cast).toArray(ISourceLocation[]::new));
    }

    @Override
    public void registerLocations(IString scheme, IString auth, IMap map) {
        super.registerLocations(scheme, auth, map);
        this.server.registerLocations(scheme, auth, IRemoteIDEServices.mapLocLocToLocArray(map));
    }
}

