/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.matching;

import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.matching.AbstractBooleanResult;
import org.rascalmpl.interpreter.matching.IMatchingResult;
import org.rascalmpl.interpreter.matching.IVarPattern;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.staticErrors.UninitializedPatternMatch;
import org.rascalmpl.types.NonTerminalType;
import org.rascalmpl.values.RascalValueFactory;

public abstract class AbstractMatchingResult
extends AbstractBooleanResult
implements IMatchingResult {
    protected Result<IValue> subject = null;
    private final AbstractAST ast;

    public AbstractMatchingResult(IEvaluatorContext ctx, AbstractAST ast) {
        super(ctx);
        this.ast = ast;
    }

    @Override
    public AbstractAST getAST() {
        return this.ast;
    }

    @Override
    public void initMatch(Result<IValue> subject) {
        if (subject.isVoid()) {
            throw new UninitializedPatternMatch("Uninitialized pattern match: trying to match a value of the type 'void'", this.ctx.getCurrentAST());
        }
        this.init();
        this.subject = subject;
    }

    @Override
    public boolean mayMatch(Type subjectType, Environment env) {
        return this.mayMatch(this.getType(env, null), subjectType);
    }

    protected void checkInitialized() {
        if (!this.initialized) {
            throw new ImplementationError("hasNext or match called before initMatch", this.ast.getLocation());
        }
    }

    @Override
    public boolean hasNext() {
        return this.initialized && this.hasNext;
    }

    @Override
    public List<IVarPattern> getVariables() {
        return new LinkedList<IVarPattern>();
    }

    boolean matchChildren(Iterator<IValue> subjChildren, Iterator<IMatchingResult> iterator) {
        while (iterator.hasNext()) {
            if (iterator.next().next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public IValue toIValue() {
        return this.getAST().interpret(this.ctx.getEvaluator()).getValue();
    }

    @Override
    public abstract Type getType(Environment var1, HashMap<String, IVarPattern> var2);

    public HashMap<String, IVarPattern> merge(HashMap<String, IVarPattern> left, List<IVarPattern> right) {
        if (left == null) {
            HashMap<String, IVarPattern> res = new HashMap<String, IVarPattern>();
            for (IVarPattern vpr : right) {
                res.put(vpr.name(), vpr);
            }
            return res;
        }
        for (IVarPattern vpr : right) {
            String name = vpr.name();
            if (left.containsKey(name)) {
                IVarPattern vpl = left.get(name);
                if (vpl.isVarIntroducing() || !vpr.isVarIntroducing()) continue;
                left.put(name, vpr);
                continue;
            }
            left.put(name, vpr);
        }
        return left;
    }

    @Override
    public abstract boolean next();

    protected boolean mayMatch(Type small, Type large) {
        if (small.equivalent(large)) {
            return true;
        }
        if (small.isBottom() || large.isBottom()) {
            return false;
        }
        if (small.isSubtypeOf(large) || large.isSubtypeOf(small)) {
            return true;
        }
        if (small instanceof NonTerminalType && large instanceof NonTerminalType) {
            return small.equals(large);
        }
        if (small instanceof NonTerminalType) {
            return large.isSubtypeOf(RascalValueFactory.Tree);
        }
        if (large instanceof NonTerminalType) {
            return small.isSubtypeOf(RascalValueFactory.Tree);
        }
        if (small.isList() && large.isList() || small.isSet() && large.isSet()) {
            return this.mayMatch(small.getElementType(), large.getElementType());
        }
        if (small.isMap() && large.isMap()) {
            return this.mayMatch(small.getKeyType(), large.getKeyType()) && this.mayMatch(small.getValueType(), large.getValueType());
        }
        if (small.isTuple() && large.isTuple()) {
            if (small.getArity() != large.getArity()) {
                return false;
            }
            for (int i = 0; i < large.getArity(); ++i) {
                if (!this.mayMatch(small.getFieldType(i), large.getFieldType(i))) continue;
                return true;
            }
            return false;
        }
        if (small.isConstructor() && large.isConstructor()) {
            if (small.getName().equals(large.getName())) {
                return false;
            }
            for (int i = 0; i < large.getArity(); ++i) {
                if (!this.mayMatch(small.getFieldType(i), large.getFieldType(i))) continue;
                return true;
            }
            return false;
        }
        if (small.isConstructor() && large.isAbstractData()) {
            return small.getAbstractDataType().equivalent(large);
        }
        if (small.isAbstractData() && large.isConstructor()) {
            return small.equivalent(large.getAbstractDataType());
        }
        return false;
    }

    @Override
    public void updateType(Type type) {
    }
}

