/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.matching;

import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.matching.AbstractMatchingResult;
import org.rascalmpl.interpreter.matching.IMatchingResult;
import org.rascalmpl.interpreter.matching.IVarPattern;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.types.TypeReachability;
import org.rascalmpl.values.iterators.IteratorFactory;

public class DescendantPattern
extends AbstractMatchingResult {
    private IMatchingResult pat;
    private Iterator<?> iterator;

    public DescendantPattern(IEvaluatorContext ctx, Expression.Descendant x, IMatchingResult pat) {
        super(ctx, x);
        this.pat = pat;
    }

    @Override
    public Type getType(Environment env, HashMap<String, IVarPattern> patternVars) {
        return TypeFactory.getInstance().valueType();
    }

    @Override
    public boolean mayMatch(Type subjectType, Environment env) {
        return TypeReachability.mayOccurIn(this.getType(env, null), subjectType, env);
    }

    @Override
    public List<IVarPattern> getVariables() {
        return this.pat.getVariables();
    }

    @Override
    public void initMatch(Result<IValue> subject) {
        super.initMatch(subject);
        this.iterator = IteratorFactory.make(this.ctx, this.pat, ResultFactory.makeResult(subject.getValue().getType(), subject.getValue(), this.ctx), false);
        this.hasNext = true;
    }

    @Override
    public boolean hasNext() {
        if (!this.initialized) {
            return false;
        }
        if (this.hasNext) {
            boolean hn;
            boolean bl = hn = this.pat.hasNext() || this.iterator.hasNext();
            if (!hn) {
                this.hasNext = false;
            }
            return hn;
        }
        return false;
    }

    @Override
    public boolean next() {
        while (this.pat.hasNext()) {
            if (!this.pat.next()) continue;
            return true;
        }
        while (this.iterator.hasNext()) {
            IValue v = (IValue)this.iterator.next();
            this.pat.initMatch(ResultFactory.makeResult(v.getType(), v, this.ctx));
            while (this.pat.hasNext()) {
                if (!this.pat.next()) continue;
                return true;
            }
        }
        this.hasNext = false;
        return false;
    }
}

