/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.matching;

import io.usethesource.vallang.ISet;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.control_exceptions.InterruptException;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.matching.AbstractMatchingResult;
import org.rascalmpl.interpreter.matching.DesignatedTypedMultiVariablePattern;
import org.rascalmpl.interpreter.matching.IBooleanResult;
import org.rascalmpl.interpreter.matching.IMatchingResult;
import org.rascalmpl.interpreter.matching.IVarPattern;
import org.rascalmpl.interpreter.matching.LiteralPattern;
import org.rascalmpl.interpreter.matching.MultiVariablePattern;
import org.rascalmpl.interpreter.matching.QualifiedNamePattern;
import org.rascalmpl.interpreter.matching.SubSetGenerator;
import org.rascalmpl.interpreter.matching.TypedMultiVariablePattern;
import org.rascalmpl.interpreter.matching.TypedVariablePattern;
import org.rascalmpl.interpreter.result.IRascalResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.RedeclaredVariable;
import org.rascalmpl.values.iterators.SingleIValueIterator;

public class SetPattern
extends AbstractMatchingResult {
    private final boolean bindTypeParameters;
    private List<IMatchingResult> patternChildren;
    private int patternSize;
    private ISet setSubject;
    private Type setSubjectType;
    private Type setSubjectElementType;
    private ISet fixedSetElements;
    private ISet availableSetElements;
    private int nVar;
    private HashSet<String> patVars;
    private HashMap<String, IVarPattern> allVars;
    private String[] varName;
    private IValue[] varVal;
    private IMatchingResult[] varPat;
    private boolean[] isSetVar;
    private boolean[] isBinding;
    private boolean[] isNested;
    private Iterator<?>[] varGen;
    private int currentVar;
    private boolean firstMatch;
    private boolean debug = false;
    private Type staticSetSubjectType;
    private Type staticSubjectElementType;

    public SetPattern(IEvaluatorContext ctx, Expression x, List<IMatchingResult> list, boolean bindTypeParameters) {
        super(ctx, x);
        this.bindTypeParameters = bindTypeParameters;
        this.patternChildren = list;
        this.patternSize = list.size();
    }

    @Override
    public Type getType(Environment env, HashMap<String, IVarPattern> patternVars) {
        if (this.patternSize == 0) {
            return this.tf.setType(this.tf.voidType());
        }
        Type elemType = this.tf.voidType();
        for (int i = 0; i < this.patternSize; ++i) {
            IMatchingResult child = this.patternChildren.get(i);
            Type childType = child.getType(env, patternVars);
            patternVars = this.merge(patternVars, this.patternChildren.get(i).getVariables());
            if (this.debug) {
                System.err.println(" i = " + i + ": " + this.patternChildren.get(i) + ", type = " + childType);
            }
            boolean isMultiVar = child instanceof MultiVariablePattern || child instanceof DesignatedTypedMultiVariablePattern;
            elemType = childType.isSet() && isMultiVar ? elemType.lub(childType.getElementType()) : elemType.lub(childType);
        }
        if (this.debug) {
            System.err.println("SetPattern.getType: " + this + " returns " + this.tf.setType(elemType));
        }
        return this.tf.setType(elemType);
    }

    @Override
    public List<IVarPattern> getVariables() {
        LinkedList<IVarPattern> res = new LinkedList<IVarPattern>();
        for (int i = 0; i < this.patternChildren.size(); ++i) {
            res.addAll(this.patternChildren.get(i).getVariables());
        }
        return res;
    }

    private boolean isSetVar(int i) {
        return this.isSetVar[i];
    }

    private void sortVars() {
        int i;
        String[] newVarName = new String[this.patternSize];
        ISet[] newVarVal = new ISet[this.patternSize];
        IMatchingResult[] newVarPat = new IMatchingResult[this.patternSize];
        boolean[] newIsSetVar = new boolean[this.patternSize];
        boolean[] newIsBinding = new boolean[this.patternSize];
        boolean[] newIsNested = new boolean[this.patternSize];
        int nw = 0;
        for (i = 0; i < this.nVar; ++i) {
            if (this.isSetVar(i)) continue;
            newVarName[nw] = this.varName[i];
            newVarVal[nw] = this.varVal[i];
            newVarPat[nw] = this.varPat[i];
            newIsSetVar[nw] = this.isSetVar[i];
            newIsBinding[nw] = this.isBinding[i];
            newIsNested[nw] = this.isNested[i];
            ++nw;
        }
        for (i = 0; i < this.nVar; ++i) {
            if (!this.isSetVar(i)) continue;
            newVarName[nw] = this.varName[i];
            newVarVal[nw] = this.varVal[i];
            newVarPat[nw] = this.varPat[i];
            newIsSetVar[nw] = this.isSetVar[i];
            newIsBinding[nw] = this.isBinding[i];
            newIsNested[nw] = this.isNested[i];
            ++nw;
        }
        assert (nw == this.nVar);
        for (i = 0; i < this.nVar; ++i) {
            this.varName[i] = newVarName[i];
            this.varVal[i] = newVarVal[i];
            this.varPat[i] = newVarPat[i];
            this.isSetVar[i] = newIsSetVar[i];
            this.isBinding[i] = newIsBinding[i];
            this.isNested[i] = newIsNested[i];
        }
    }

    private void printVars() {
        for (int i = 0; i < this.nVar; ++i) {
            System.err.printf("%d: %s, isSetVar=%b, isBinding=%b, isNested=%b, val=%s\n", i, this.varName[i], this.isSetVar(i), this.isBinding[i], this.isNested[i], this.varVal[i]);
        }
    }

    private boolean declaredAsSetVar(String name) {
        for (int i = 0; i < this.nVar; ++i) {
            if (!this.varName[i].equals(name)) continue;
            return this.isSetVar(i);
        }
        return false;
    }

    @Override
    public void initMatch(Result<IValue> subject) {
        super.initMatch(subject);
        if (!subject.getValue().getType().isSet()) {
            this.hasNext = false;
            return;
        }
        this.setSubject = (ISet)subject.getValue();
        if (this.debug) {
            System.err.println("\n*** begin initMatch for " + this + " := " + this.setSubject);
        }
        this.setSubjectType = this.setSubject.getType();
        this.staticSetSubjectType = subject.getStaticType();
        this.setSubjectElementType = this.setSubject.getElementType();
        Type type = this.staticSubjectElementType = this.staticSetSubjectType.isSet() ? this.staticSetSubjectType.getElementType() : this.tf.valueType();
        if (this.debug) {
            System.err.println("setSubjectType = " + this.setSubjectType + ", staticSetSubjectType = " + this.staticSetSubjectType + ", setSubjectElementType = " + this.setSubjectElementType + ", staticSubjectElementType =" + this.staticSubjectElementType);
        }
        Environment env = this.ctx.getCurrentEnvt();
        this.fixedSetElements = this.ctx.getValueFactory().set(new IValue[0]);
        this.nVar = 0;
        this.patVars = new HashSet();
        this.allVars = new HashMap();
        this.varName = new String[this.patternSize];
        this.isSetVar = new boolean[this.patternSize];
        this.isBinding = new boolean[this.patternSize];
        this.isNested = new boolean[this.patternSize];
        this.varVal = new IValue[this.patternSize];
        this.varPat = new IMatchingResult[this.patternSize];
        this.varGen = new Iterator[this.patternSize];
        for (int i = 0; i < this.patternSize; ++i) {
            String name;
            Type childType;
            IMatchingResult child = this.patternChildren.get(i);
            if (this.debug) {
                System.err.println("child = " + child);
            }
            if (child instanceof TypedMultiVariablePattern) {
                TypedMultiVariablePattern tmv = (TypedMultiVariablePattern)child;
                child = new DesignatedTypedMultiVariablePattern(this.ctx, (Expression)tmv.getAST(), this.tf.setType(tmv.getType(env, null)), tmv.getName(), this.bindTypeParameters);
                this.patternChildren.set(i, child);
            }
            if (child instanceof DesignatedTypedMultiVariablePattern) {
                DesignatedTypedMultiVariablePattern tmvVar = (DesignatedTypedMultiVariablePattern)child;
                childType = child.getType(env, null);
                String name2 = tmvVar.getName();
                if (!tmvVar.isAnonymous() && this.allVars.containsKey(name2)) {
                    throw new RedeclaredVariable(name2, this.getAST());
                }
                if (childType.comparable(this.staticSetSubjectType)) {
                    if (!tmvVar.isAnonymous()) {
                        this.patVars.add(name2);
                        this.allVars.put(name2, (IVarPattern)((Object)child));
                    }
                    this.varName[this.nVar] = name2;
                    this.varPat[this.nVar] = child;
                    this.isSetVar[this.nVar] = true;
                    this.isBinding[this.nVar] = true;
                    this.isNested[this.nVar] = false;
                    ++this.nVar;
                    continue;
                }
                this.hasNext = false;
                return;
            }
            if (child instanceof TypedVariablePattern) {
                TypedVariablePattern patVar = (TypedVariablePattern)child;
                childType = child.getType(env, null);
                String name3 = ((TypedVariablePattern)child).getName();
                if (!patVar.isAnonymous() && this.allVars.containsKey(name3)) {
                    throw new RedeclaredVariable(name3, this.getAST());
                }
                if (childType.comparable(this.staticSubjectElementType)) {
                    if (!patVar.isAnonymous()) {
                        this.patVars.add(name3);
                        this.allVars.put(name3, (IVarPattern)((Object)child));
                    }
                    this.varName[this.nVar] = name3;
                    this.varPat[this.nVar] = child;
                    this.isSetVar[this.nVar] = false;
                    this.isBinding[this.nVar] = true;
                    this.isNested[this.nVar] = false;
                    ++this.nVar;
                    continue;
                }
                this.hasNext = false;
                return;
            }
            if (child instanceof MultiVariablePattern) {
                MultiVariablePattern multiVar = (MultiVariablePattern)child;
                this.varName[this.nVar] = name = multiVar.getName();
                this.varPat[this.nVar] = child;
                this.isSetVar[this.nVar] = true;
                this.isBinding[this.nVar] = true;
                this.isNested[this.nVar] = false;
                ++this.nVar;
                continue;
            }
            if (child instanceof QualifiedNamePattern) {
                IRascalResult varRes;
                QualifiedNamePattern qualName = (QualifiedNamePattern)child;
                name = qualName.getName();
                if (!qualName.isAnonymous() && this.allVars.containsKey(name)) {
                    if (this.patVars.contains(name)) continue;
                    this.varName[this.nVar] = name;
                    this.varPat[this.nVar] = child;
                    this.isSetVar[this.nVar] = this.declaredAsSetVar(name);
                    this.isBinding[this.nVar] = false;
                    this.isNested[this.nVar] = false;
                    ++this.nVar;
                    continue;
                }
                if (qualName.isAnonymous()) {
                    this.varName[this.nVar] = name;
                    this.varPat[this.nVar] = child;
                    this.isSetVar[this.nVar] = false;
                    this.isBinding[this.nVar] = false;
                    this.isNested[this.nVar] = false;
                    ++this.nVar;
                    continue;
                }
                if (this.debug) {
                    System.err.println("Non-anonymous var, not seen before: " + name);
                }
                if ((varRes = env.getFrameVariable(name)) == null || qualName.bindingInstance()) {
                    this.varName[this.nVar] = name;
                    this.varPat[this.nVar] = child;
                    this.isSetVar[this.nVar] = false;
                    this.isBinding[this.nVar] = true;
                    this.isNested[this.nVar] = false;
                    ++this.nVar;
                    continue;
                }
                if (((Result)varRes).getValue() != null) {
                    Type varType = ((Result)varRes).getStaticType();
                    if (varType.comparable(this.staticSetSubjectType)) {
                        this.fixedSetElements = this.fixedSetElements.union((ISet)((Result)varRes).getValue());
                        continue;
                    }
                    if (varType.comparable(this.staticSubjectElementType)) {
                        this.fixedSetElements = this.fixedSetElements.insert((IValue)((Result)varRes).getValue());
                        continue;
                    }
                    this.hasNext = false;
                    return;
                }
                if (!((Result)varRes).getStaticType().comparable(this.staticSetSubjectType) && !((Result)varRes).getStaticType().comparable(this.staticSubjectElementType)) continue;
                if (!name.equals("_")) {
                    this.patVars.add(name);
                    this.allVars.put(name, (IVarPattern)((Object)child));
                }
                this.varName[this.nVar] = name;
                this.varPat[this.nVar] = child;
                this.isSetVar[this.nVar] = ((Result)varRes).getStaticType().isSet();
                this.isBinding[this.nVar] = false;
                this.isNested[this.nVar] = false;
                ++this.nVar;
                continue;
            }
            if (child instanceof LiteralPattern) {
                IValue lit = ((LiteralPattern)child).toIValue(env);
                childType = child.getType(env, null);
                if (!childType.comparable(this.staticSubjectElementType)) {
                    this.hasNext = false;
                    return;
                }
                this.fixedSetElements = this.fixedSetElements.insert(lit);
                if (!this.debug) continue;
                System.err.println("fixedSetElements => " + this.fixedSetElements);
                continue;
            }
            Type childType2 = child.getType(env, null);
            if (!childType2.comparable(this.staticSubjectElementType)) {
                this.hasNext = false;
                return;
            }
            List<IVarPattern> childVars = child.getVariables();
            if (!childVars.isEmpty()) {
                boolean varIntro = false;
                for (IVarPattern vp : childVars) {
                    if (this.debug) {
                        System.err.println("var =" + vp);
                    }
                    IVarPattern prev = this.allVars.get(vp.name());
                    boolean vpVarIntro = vp.isVarIntroducing();
                    boolean bl = varIntro = varIntro || vpVarIntro;
                    if (prev != null && !vpVarIntro) continue;
                    this.allVars.put(vp.name(), vp);
                }
                this.varName[this.nVar] = child.toString();
                this.varPat[this.nVar] = child;
                this.isSetVar[this.nVar] = false;
                this.isBinding[this.nVar] = varIntro;
                this.isNested[this.nVar] = true;
                ++this.nVar;
                continue;
            }
            this.fixedSetElements = this.fixedSetElements.insert(child.toIValue());
            if (!this.debug) continue;
            System.err.println("fixedSetElements => " + this.fixedSetElements);
        }
        this.firstMatch = true;
        this.hasNext = this.fixedSetElements.isSubsetOf(this.setSubject);
        if (this.debug) {
            System.err.println("fixedSetElements => " + this.fixedSetElements);
            System.err.println("setSubject => " + this.setSubject);
        }
        this.availableSetElements = this.setSubject.subtract(this.fixedSetElements);
        this.sortVars();
        if (this.debug) {
            System.err.println("Pattern " + this);
            this.printVars();
            System.err.printf("hasNext = %b\n", this.hasNext);
            System.err.println("FixedSetElements: " + this.fixedSetElements);
            System.err.println("availableSetElements: " + this.availableSetElements);
            if (this.debug) {
                System.err.println("*** end initMatch for " + this + "\n");
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.initialized && this.hasNext;
    }

    private ISet available() {
        ISet avail = this.availableSetElements;
        for (int j = 0; j < this.currentVar; ++j) {
            if (this.isSetVar(j)) {
                if (this.varVal[j] == null) continue;
                avail = avail.subtract((ISet)this.varVal[j]);
                continue;
            }
            if (this.varVal[j] == null) continue;
            avail = avail.delete(this.varVal[j]);
        }
        return avail;
    }

    private boolean unexploredAlternatives() {
        assert (this.currentVar == this.nVar);
        for (int j = 0; j < this.nVar; ++j) {
            if (this.isSetVar(j)) {
                if (!this.varGen[j].hasNext()) continue;
                return true;
            }
            if (this.isNested[j] && this.varPat[j].hasNext()) {
                return true;
            }
            if (!this.varGen[j].hasNext()) continue;
            return true;
        }
        return false;
    }

    private boolean makeGen(int i, ISet elements) {
        if (this.debug) {
            System.err.println("makeGen: " + i + ", " + elements);
        }
        Environment env = this.ctx.getCurrentEnvt();
        if (this.varPat[i] instanceof QualifiedNamePattern) {
            QualifiedNamePattern qualName = (QualifiedNamePattern)this.varPat[i];
            String name = qualName.getName();
            if (this.isBinding[i] || qualName.isAnonymous() || env.getFrameVariable(name) == null || ((Result)env.getFrameVariable(name)).getValue() == null) {
                if (this.isSetVar(i)) {
                    this.varGen[i] = new SubSetGenerator(elements, this.ctx);
                } else {
                    if (elements.size() == 0) {
                        return false;
                    }
                    this.varGen[i] = elements.iterator();
                }
            } else {
                Object val = ((Result)env.getFrameVariable(name)).getValue();
                if (val != null) {
                    if (val != null && val.getType().isSet()) {
                        this.isSetVar[i] = true;
                        if (elements.equals(val)) {
                            this.varGen[i] = new SingleIValueIterator((IValue)val);
                            return true;
                        }
                        return false;
                    }
                    if (elements.contains((IValue)val)) {
                        this.varGen[i] = new SingleIValueIterator((IValue)val);
                    } else {
                        return false;
                    }
                }
            }
            return true;
        }
        if (this.isSetVar(i)) {
            this.varGen[i] = new SubSetGenerator(elements, this.ctx);
            return true;
        }
        if (elements.size() == 0) {
            return false;
        }
        this.varGen[i] = elements.iterator();
        return true;
    }

    @Override
    public boolean next() {
        this.checkInitialized();
        if (!this.hasNext) {
            return false;
        }
        if (this.firstMatch) {
            this.hasNext = false;
            this.firstMatch = false;
            if (this.nVar == 0) {
                return this.fixedSetElements.equals(this.setSubject);
            }
            if (!this.fixedSetElements.isSubsetOf(this.setSubject)) {
                return false;
            }
            if (this.patternSize == 1 && (this.isSetVar(0) || this.availableSetElements.size() == 1)) {
                IValue elem;
                if (this.isSetVar(0)) {
                    this.varVal[0] = this.availableSetElements;
                    elem = this.availableSetElements;
                } else if (this.availableSetElements.getType().isSet()) {
                    ISet set = this.availableSetElements;
                    assert (set.size() == 1);
                    elem = (IValue)set.iterator().next();
                    this.varVal[0] = elem;
                } else {
                    elem = this.availableSetElements;
                    this.varVal[0] = elem;
                }
                this.varPat[0].initMatch(ResultFactory.makeResult(elem.getType(), elem, this.ctx));
                this.hasNext = this.varPat[0].hasNext();
            }
            this.currentVar = 0;
            if (!this.makeGen(this.currentVar, this.availableSetElements)) {
                return false;
            }
        } else {
            this.currentVar = this.nVar - 1;
        }
        this.hasNext = true;
        if (this.debug) {
            System.err.println("\nStart assigning Vars for " + this + ":= " + this.subject);
        }
        if (this.patternSize == 1 && (this.isSetVar(0) || this.availableSetElements.size() == 1)) {
            this.hasNext = false;
            return this.varPat[0].hasNext() && this.varPat[0].next();
        }
        do {
            Result<IValue> r;
            if (this.ctx.isInterrupted()) {
                throw new InterruptException(this.ctx.getStackTrace(), this.ctx.getCurrentAST().getLocation());
            }
            if (this.debug) {
                System.err.println("\n=== MAIN: Pattern = " + this + ":= " + this.subject + "\ncurrentVar[" + this.currentVar + "]=" + this.varName[this.currentVar]);
            }
            if (this.debug) {
                this.printVars();
            }
            IValue v = null;
            boolean b = false;
            if (this.isNested[this.currentVar]) {
                if (this.varPat[this.currentVar].hasNext()) {
                    b = this.varPat[this.currentVar].next();
                    if (b) {
                        v = this.varVal[this.currentVar];
                    }
                } else if (this.varGen[this.currentVar].hasNext()) {
                    v = (IValue)this.varGen[this.currentVar].next();
                    r = ResultFactory.makeResult(v.getType(), v, this.ctx);
                    this.varPat[this.currentVar].initMatch(r);
                    b = this.varPat[this.currentVar].next();
                    if (b) {
                        this.varVal[this.currentVar] = v;
                    }
                }
            } else if (this.isSetVar[this.currentVar]) {
                if (this.varGen[this.currentVar].hasNext()) {
                    v = (IValue)this.varGen[this.currentVar].next();
                    r = ResultFactory.makeResult(v.getType().lub(this.setSubjectType), v, this.ctx);
                    this.varPat[this.currentVar].initMatch(r);
                    b = this.varPat[this.currentVar].next();
                    if (b) {
                        this.varVal[this.currentVar] = v;
                        this.ctx.getCurrentEnvt().storeVariable(this.varName[this.currentVar], r);
                        if (this.debug) {
                            System.err.println("Store in " + this.varName[this.currentVar] + ": " + r + " / " + v + " / " + v.getType() + " / " + ((Result)this.ctx.getCurrentEnvt().getFrameVariable(this.varName[this.currentVar])).getStaticType());
                        }
                    }
                }
            } else if (this.isBinding[this.currentVar]) {
                if (this.varGen[this.currentVar].hasNext()) {
                    v = (IValue)this.varGen[this.currentVar].next();
                    r = ResultFactory.makeResult(v.getType(), v, this.ctx);
                    this.varPat[this.currentVar].initMatch(r);
                    b = this.varPat[this.currentVar].next();
                    if (b) {
                        this.varVal[this.currentVar] = v;
                        this.ctx.getCurrentEnvt().storeVariable(this.varName[this.currentVar], r);
                        if (this.debug) {
                            System.err.println("Store in " + this.varName[this.currentVar] + ": " + r + " / " + v + " / " + v.getType() + " / " + ((Result)this.ctx.getCurrentEnvt().getFrameVariable(this.varName[this.currentVar])).getStaticType());
                        }
                    }
                }
            } else if (this.varPat[this.currentVar] instanceof QualifiedNamePattern && ((QualifiedNamePattern)this.varPat[this.currentVar]).isAnonymous()) {
                if (this.varGen[this.currentVar].hasNext()) {
                    v = (IValue)this.varGen[this.currentVar].next();
                    r = ResultFactory.makeResult(v.getType(), v, this.ctx);
                    this.varPat[this.currentVar].initMatch(r);
                    b = this.varPat[this.currentVar].next();
                    if (b) {
                        this.varVal[this.currentVar] = v;
                    }
                }
            } else if (!this.isBinding[this.currentVar] && (this.varPat[this.currentVar] instanceof QualifiedNamePattern || this.varPat[this.currentVar] instanceof TypedVariablePattern) && this.varGen[this.currentVar].hasNext()) {
                v = (IValue)this.varGen[this.currentVar].next();
                r = ResultFactory.makeResult(v.getType(), v, this.ctx);
                this.varPat[this.currentVar].initMatch(r);
                b = this.varPat[this.currentVar].next();
                if (this.debug) {
                    System.err.println("Try match " + this.varName[this.currentVar] + ": " + r + " / " + v + " / " + v.getType());
                }
                if (b) {
                    this.varVal[this.currentVar] = v;
                    if (this.debug) {
                        System.err.println("Matches " + this.varName[this.currentVar] + ": " + r + " / " + v + " / " + v.getType());
                    }
                }
            } else if (this.debug) {
                System.err.println("CANNOT HANDLE THIS 2");
            }
            if (b) {
                ++this.currentVar;
                ISet avail = this.available();
                if (this.currentVar <= this.nVar - 1) {
                    if (this.makeGen(this.currentVar, avail)) continue;
                    this.varGen[this.currentVar] = null;
                    --this.currentVar;
                    continue;
                }
                if (!avail.isEmpty()) {
                    if (this.debug) {
                        System.err.println("nomatch: currentVar = " + this.currentVar + " avail = " + this.available());
                    }
                    --this.currentVar;
                    continue;
                }
                this.hasNext = this.unexploredAlternatives();
                if (this.debug) {
                    System.err.println("currentVar > nVar -1\n" + this + ":= " + this.subject + " returns true, hasNext = " + this.hasNext + ", available = " + this.available());
                }
                return true;
            }
            if (!this.varGen[this.currentVar].hasNext()) {
                this.varGen[this.currentVar] = null;
                --this.currentVar;
            }
            if (!this.debug) continue;
            System.err.println("currentVar becomes: " + this.currentVar);
        } while (this.currentVar >= 0 && this.currentVar < this.nVar);
        if (this.currentVar < 0) {
            this.hasNext = false;
            if (this.debug) {
                System.err.println("Pattern " + this + " := " + this.subject + " returns false");
            }
            return false;
        }
        this.hasNext = this.unexploredAlternatives();
        if (this.debug) {
            System.err.println("Pattern " + this + " := " + this.subject + " returns true, hasNext = " + this.hasNext + ", available = " + this.available());
        }
        return this.available().isEmpty();
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("{");
        String sep = "";
        for (IBooleanResult iBooleanResult : this.patternChildren) {
            res.append(sep);
            sep = ", ";
            res.append(iBooleanResult.toString());
        }
        res.append("}");
        return res.toString();
    }
}

