/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.matching;

import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.Name;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.matching.AbstractMatchingResult;
import org.rascalmpl.interpreter.matching.IVarPattern;
import org.rascalmpl.interpreter.result.AbstractFunction;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.utils.Names;

public class TypedVariablePattern
extends AbstractMatchingResult
implements IVarPattern {
    private String name;
    protected final Type declaredType;
    protected final Type instantiatedDeclaredType;
    private boolean anonymous = false;
    private boolean debug = false;
    protected boolean alreadyStored = false;
    private final boolean bindTypeParameters;

    public TypedVariablePattern(IEvaluatorContext ctx, Expression x, Type type, Name name, boolean bindTypeParameters) {
        super(ctx, x);
        assert (type != TypeFactory.getInstance().voidType());
        this.name = Names.name(name);
        this.bindTypeParameters = bindTypeParameters;
        this.declaredType = type;
        this.instantiatedDeclaredType = type.instantiate(ctx.getCurrentEnvt().getStaticTypeBindings());
        this.anonymous = Names.name(name).equals("_");
        if (this.debug) {
            System.err.println("AbstractPatternTypedVariabe: " + name);
        }
    }

    public TypedVariablePattern(IEvaluatorContext ctx, Expression x, Type type, String name, boolean bindTypeParameters) {
        super(ctx, x);
        this.name = name;
        this.declaredType = type;
        this.instantiatedDeclaredType = type.instantiate(ctx.getCurrentEnvt().getStaticTypeBindings());
        this.anonymous = name.equals("_");
        this.bindTypeParameters = bindTypeParameters;
        if (this.debug) {
            System.err.println("AbstractPatternTypedVariabe: " + name);
        }
    }

    @Override
    public Type getType(Environment env, HashMap<String, IVarPattern> patternVars) {
        return this.declaredType;
    }

    @Override
    public List<IVarPattern> getVariables() {
        LinkedList<IVarPattern> res = new LinkedList<IVarPattern>();
        res.addFirst(this);
        return res;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    public boolean next() {
        if (this.debug) {
            System.err.println("AbstractTypedVariable.next");
        }
        this.checkInitialized();
        if (!this.hasNext) {
            return false;
        }
        this.hasNext = false;
        if (this.debug) {
            System.err.println("Subject: " + this.subject + " name: " + this.name + " getType: ");
            System.err.println("AbstractTypedVariable.next: " + this.subject + "(type=" + this.subject.getStaticType() + ") with " + this.declaredType + " " + this.name);
        }
        if (this.subject.getValue().getType().isSubtypeOf(this.declaredType)) {
            Type dynType;
            if (this.debug) {
                System.err.println("matches");
            }
            if (this.bindTypeParameters) {
                try {
                    HashMap<Type, Type> staticBindings = new HashMap<Type, Type>(this.ctx.getCurrentEnvt().getStaticTypeBindings());
                    this.declaredType.match(this.subject.getStaticType(), staticBindings);
                    this.ctx.getCurrentEnvt().storeStaticTypeBindings(staticBindings);
                    HashMap<Type, Type> dynBindings = new HashMap<Type, Type>(this.ctx.getCurrentEnvt().getDynamicTypeBindings());
                    Type dynMatchType = this.subject.getValue().getType();
                    if (dynMatchType.isOpen()) {
                        dynMatchType = AbstractFunction.renameType(dynMatchType, new HashMap<Type, Type>(), this.ctx.getCurrentAST().getLocation());
                    }
                    if (!this.declaredType.match(dynMatchType, dynBindings)) {
                        return false;
                    }
                    this.ctx.getCurrentEnvt().storeDynamicTypeBindings(dynBindings);
                    this.ctx.getCurrentEnvt().declareAndStoreInferredInnerScopeVariable(this.name, ResultFactory.makeResult(this.declaredType, this.subject.getValue(), this.ctx));
                    this.alreadyStored = true;
                    return true;
                }
                catch (FactTypeUseException staticBindings) {
                    // empty catch block
                }
            }
            if ((dynType = this.subject.getValue().getType()).isOpen()) {
                dynType = AbstractFunction.renameType(dynType, new HashMap<Type, Type>(), this.ctx.getCurrentAST().getLocation());
            }
            if (!dynType.isSubtypeOf(this.declaredType.instantiate(this.ctx.getCurrentEnvt().getDynamicTypeBindings()))) {
                return false;
            }
            if (this.anonymous) {
                return true;
            }
            this.ctx.getCurrentEnvt().declareAndStoreInferredInnerScopeVariable(this.name, ResultFactory.makeResult(this.declaredType, this.subject.getValue(), this.ctx));
            this.alreadyStored = true;
            return true;
        }
        if (this.debug) {
            System.err.println("no match");
        }
        return false;
    }

    public String toString() {
        return this.declaredType + " " + this.name;
    }

    @Override
    public boolean isVarIntroducing() {
        return true;
    }

    @Override
    public String name() {
        return this.getName();
    }

    @Override
    public Type getType() {
        return this.declaredType;
    }

    public boolean bindingInstance() {
        return this.alreadyStored;
    }
}

