/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.tools.JavaFileObject;
import org.rascalmpl.interpreter.utils.JavaFileObjectImpl;
import org.rascalmpl.library.Prelude;

final class ClassLoaderImpl
extends ClassLoader {
    private final Map<String, JavaFileObjectImpl> classes = new HashMap<String, JavaFileObjectImpl>();

    ClassLoaderImpl(ClassLoader parentClassLoader) {
        super(parentClassLoader);
    }

    public void outputClassesToJar(String qualifiedClassName, OutputStream output) throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, qualifiedClassName);
        try (JarOutputStream target = new JarOutputStream(output, manifest);){
            for (Map.Entry<String, JavaFileObjectImpl> entry : this.classes.entrySet()) {
                String className = entry.getKey();
                JavaFileObjectImpl file = entry.getValue();
                JarEntry jarEntry = new JarEntry(className);
                jarEntry.setTime(file.getLastModified());
                target.putNextEntry(jarEntry);
                target.write(file.getByteCode());
                target.closeEntry();
            }
        }
    }

    public Class<?> inputClassesFromJar(InputStream in) throws IOException, ClassNotFoundException, URISyntaxException {
        try (JarInputStream jarIn = new JarInputStream(in);){
            JarEntry jarEntry;
            Manifest mf = jarIn.getManifest();
            String mainClass = (String)mf.getMainAttributes().get(Attributes.Name.MAIN_CLASS);
            if (mainClass == null) {
                throw new IOException("missing Main-Class in jar manifest");
            }
            while ((jarEntry = jarIn.getNextJarEntry()) != null) {
                if (jarEntry.isDirectory()) continue;
                String className = jarEntry.getName();
                JavaFileObjectImpl file = new JavaFileObjectImpl(className, JavaFileObject.Kind.CLASS);
                try (OutputStream fo = file.openOutputStream();){
                    fo.write(Prelude.consumeInputStream(jarIn));
                }
                this.add(className, file);
            }
            Class<?> clazz = this.loadClass(mainClass);
            return clazz;
        }
    }

    Collection<JavaFileObjectImpl> files() {
        return Collections.unmodifiableCollection(this.classes.values());
    }

    @Override
    protected Class<?> findClass(String qualifiedClassName) throws ClassNotFoundException {
        JavaFileObject file = this.classes.get(qualifiedClassName);
        if (file != null) {
            byte[] bytes = ((JavaFileObjectImpl)file).getByteCode();
            return this.defineClass(qualifiedClassName, bytes, 0, bytes.length);
        }
        return super.findClass(qualifiedClassName);
    }

    void add(String qualifiedClassName, JavaFileObject javaFile) {
        this.classes.put(qualifiedClassName, (JavaFileObjectImpl)javaFile);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        String qualifiedClassName;
        JavaFileObjectImpl file;
        if (name.endsWith(".class") && (file = this.classes.get(qualifiedClassName = name.substring(0, name.length() - ".class".length()).replace('/', '.'))) != null) {
            return new ByteArrayInputStream(file.getByteCode());
        }
        return super.getResourceAsStream(name);
    }
}

