/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.stack.edge;

import java.util.Arrays;
import org.rascalmpl.parser.gtd.result.AbstractContainerNode;
import org.rascalmpl.parser.gtd.stack.AbstractStackNode;
import org.rascalmpl.parser.gtd.util.IntegerMap;
import org.rascalmpl.parser.gtd.util.IntegerObjectList;

public class EdgesSet<P> {
    public static final int DEFAULT_RESULT_STORE_ID = -1;
    private static final int DEFAULT_SIZE = 8;
    private AbstractStackNode<P>[] edges;
    private int size;
    private int lastVisitedLevel = -1;
    private IntegerMap lastVisitedFilteredLevel;
    private AbstractContainerNode<P> lastResults;
    private IntegerObjectList<AbstractContainerNode<P>> lastFilteredResults;

    public EdgesSet() {
        this.edges = new AbstractStackNode[8];
        this.size = 0;
    }

    public EdgesSet(int initialSize) {
        this.edges = new AbstractStackNode[initialSize];
        this.size = 0;
    }

    private void enlarge() {
        this.edges = (AbstractStackNode[])Arrays.copyOf(this.edges, this.size << 1, this.edges.getClass());
    }

    public void add(AbstractStackNode<P> edge) {
        while (this.size >= this.edges.length) {
            this.enlarge();
        }
        this.edges[this.size++] = edge;
    }

    public boolean contains(AbstractStackNode<P> node) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.edges[i] != node) continue;
            return true;
        }
        return false;
    }

    public boolean containsBefore(AbstractStackNode<P> node, int limit) {
        for (int i = limit - 1; i >= 0; --i) {
            if (this.edges[i] != node) continue;
            return true;
        }
        return false;
    }

    public boolean containsAfter(AbstractStackNode<P> node, int limit) {
        if (limit >= 0) {
            for (int i = this.size - 1; i >= limit; --i) {
                if (this.edges[i] != node) continue;
                return true;
            }
        }
        return false;
    }

    public AbstractStackNode<P> get(int index) {
        return this.edges[index];
    }

    public void setLastVisitedLevel(int level, int resultStoreId) {
        if (resultStoreId == -1) {
            this.lastVisitedLevel = level;
        } else {
            if (this.lastVisitedFilteredLevel == null) {
                this.lastVisitedFilteredLevel = new IntegerMap();
            }
            this.lastVisitedFilteredLevel.put(resultStoreId, level);
        }
    }

    public int getLastVisitedLevel(int resultStoreId) {
        if (resultStoreId == -1) {
            return this.lastVisitedLevel;
        }
        if (this.lastVisitedFilteredLevel == null) {
            this.lastVisitedFilteredLevel = new IntegerMap();
            return -1;
        }
        return this.lastVisitedFilteredLevel.get(resultStoreId);
    }

    public void setLastResult(AbstractContainerNode<P> lastResult, int resultStoreId) {
        if (resultStoreId == -1) {
            this.lastResults = lastResult;
        } else {
            if (this.lastFilteredResults == null) {
                this.lastFilteredResults = new IntegerObjectList(8);
            }
            this.lastFilteredResults.add(resultStoreId, lastResult);
        }
    }

    public AbstractContainerNode<P> getLastResult(int resultStoreId) {
        if (resultStoreId == -1) {
            return this.lastResults;
        }
        if (this.lastFilteredResults == null) {
            this.lastFilteredResults = new IntegerObjectList(8);
            return null;
        }
        return this.lastFilteredResults.findValue(resultStoreId);
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("EdgesSet[{");
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(this.edges[i].getName() + "=" + this.edges[i].getId() + "." + this.edges[i].getDot() + "@" + this.edges[i].getStartLocation());
        }
        builder.append("}");
        if (this.lastVisitedLevel >= 0) {
            builder.append(",lastVisitedLevel=" + this.lastVisitedLevel);
        }
        if (this.lastResults != null) {
            builder.append(",lastResults=" + this.lastResults);
        }
        builder.append("]");
        return builder.toString();
    }
}

