/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.stack.filter.match;

import org.rascalmpl.parser.gtd.location.PositionStore;
import org.rascalmpl.parser.gtd.stack.filter.ICompletionFilter;

public class CharMatchRestriction
implements ICompletionFilter {
    private final int[][] ranges;

    public CharMatchRestriction(int[][] ranges) {
        this.ranges = ranges;
    }

    @Override
    public boolean isFiltered(int[] input, int start, int end, PositionStore positionStore) {
        if (end - start != 1) {
            return false;
        }
        int character = input[start];
        for (int i = this.ranges.length - 1; i >= 0; --i) {
            int[] range = this.ranges[i];
            if (character < range[0] || character > range[1]) continue;
            return true;
        }
        return true;
    }

    @Override
    public boolean isEqual(ICompletionFilter otherCompletionFilter) {
        if (!(otherCompletionFilter instanceof CharMatchRestriction)) {
            return false;
        }
        CharMatchRestriction otherCharMatchFilter = (CharMatchRestriction)otherCompletionFilter;
        int[][] otherRanges = otherCharMatchFilter.ranges;
        block0: for (int i = this.ranges.length - 1; i >= 0; --i) {
            int[] range = this.ranges[i];
            for (int j = otherRanges.length - 1; j >= 0; --j) {
                int[] otherRange = otherRanges[j];
                if (range[0] == otherRange[0] && range[1] == otherRange[1]) continue block0;
            }
            return false;
        }
        return true;
    }
}

