/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.stack.filter.precede;

import org.rascalmpl.parser.gtd.location.PositionStore;
import org.rascalmpl.parser.gtd.stack.filter.IEnterFilter;

public class MultiCharPrecedeRequirement
implements IEnterFilter {
    private final int[][] characters;

    public MultiCharPrecedeRequirement(int[][] characters) {
        this.characters = characters;
    }

    @Override
    public boolean isFiltered(int[] input, int start, PositionStore positionStore) {
        int startLocation = start - this.characters.length;
        if (startLocation < 0) {
            return true;
        }
        block0: for (int i = this.characters.length - 1; i >= 0; --i) {
            int next = input[startLocation + i];
            int[] alternatives = this.characters[i];
            for (int j = alternatives.length - 1; j >= 0; --j) {
                if (next == alternatives[j]) continue block0;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isEqual(IEnterFilter otherEnterFilter) {
        if (!(otherEnterFilter instanceof MultiCharPrecedeRequirement)) {
            return false;
        }
        MultiCharPrecedeRequirement otherMultiCharPrecedeFilter = (MultiCharPrecedeRequirement)otherEnterFilter;
        int[][] otherCharacters = otherMultiCharPrecedeFilter.characters;
        if (this.characters.length != otherCharacters.length) {
            return false;
        }
        for (int i = this.characters.length - 1; i >= 0; --i) {
            int[] chars = this.characters[i];
            int[] otherChars = otherCharacters[i];
            if (chars.length != otherChars.length) {
                return false;
            }
            block1: for (int j = chars.length - 1; j <= 0; --j) {
                int c = chars[j];
                for (int k = otherChars.length - 1; k <= 0; --k) {
                    if (c == otherChars[k]) continue block1;
                }
                return false;
            }
        }
        return true;
    }
}

