/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.util;

public class IntegerMap {
    private static final int DEFAULT_BIT_SIZE = 2;
    private Entry[] entries;
    private int hashMask;
    private int bitSize = 2;
    private int threshold;
    private int load;

    public IntegerMap() {
        int nrOfEntries = 1 << 2;
        this.hashMask = nrOfEntries - 1;
        this.entries = new Entry[nrOfEntries];
        this.threshold = nrOfEntries;
        this.load = 0;
    }

    private void rehash() {
        int nrOfEntries = 1 << ++this.bitSize;
        int newHashMask = nrOfEntries - 1;
        Entry[] oldEntries = this.entries;
        Entry[] newEntries = new Entry[nrOfEntries];
        Entry currentEntryRoot = new Entry(-1, -1, null);
        Entry shiftedEntryRoot = new Entry(-1, -1, null);
        int oldSize = oldEntries.length;
        for (int i = oldSize - 1; i >= 0; --i) {
            Entry e = oldEntries[i];
            if (e == null) continue;
            Entry lastCurrentEntry = currentEntryRoot;
            Entry lastShiftedEntry = shiftedEntryRoot;
            int lastPosition = -1;
            do {
                int position;
                if ((position = e.key & newHashMask) == i) {
                    if (position != lastPosition) {
                        lastCurrentEntry.next = e;
                    }
                    lastCurrentEntry = e;
                    continue;
                }
                if (position != lastPosition) {
                    lastShiftedEntry.next = e;
                }
                lastShiftedEntry = e;
            } while ((e = e.next) != null);
            lastCurrentEntry.next = null;
            lastShiftedEntry.next = null;
            newEntries[i] = currentEntryRoot.next;
            newEntries[i | oldSize] = shiftedEntryRoot.next;
        }
        this.threshold <<= 1;
        this.entries = newEntries;
        this.hashMask = newHashMask;
    }

    private void ensureCapacity() {
        if (this.load > this.threshold) {
            this.rehash();
        }
    }

    public int put(int key, int value) {
        this.ensureCapacity();
        int position = key & this.hashMask;
        Entry currentStartEntry = this.entries[position];
        if (currentStartEntry != null) {
            Entry entry = currentStartEntry;
            do {
                if (entry.key != key) continue;
                int oldValue = entry.value;
                entry.value = value;
                return oldValue;
            } while ((entry = entry.next) != null);
        }
        this.entries[position] = new Entry(key, value, currentStartEntry);
        ++this.load;
        return -1;
    }

    public void putUnsafe(int key, int value) {
        this.ensureCapacity();
        int position = key & this.hashMask;
        this.entries[position] = new Entry(key, value, this.entries[position]);
        ++this.load;
    }

    public int get(int key) {
        int position = key & this.hashMask;
        Entry entry = this.entries[position];
        while (entry != null) {
            if (entry.key == key) {
                return entry.value;
            }
            entry = entry.next;
        }
        return -1;
    }

    public int remove(int key) {
        int position = key & this.hashMask;
        Entry previous = null;
        Entry currentStartEntry = this.entries[position];
        if (currentStartEntry != null) {
            Entry entry = currentStartEntry;
            do {
                if (entry.key == key) {
                    if (previous == null) {
                        this.entries[position] = entry.next;
                    } else {
                        previous.next = entry.next;
                    }
                    --this.load;
                    return entry.value;
                }
                previous = entry;
            } while ((entry = entry.next) != null);
        }
        return -1;
    }

    public int size() {
        return this.load;
    }

    public void clear() {
        this.bitSize = 2;
        int nrOfEntries = 1 << 2;
        this.hashMask = nrOfEntries - 1;
        this.entries = new Entry[nrOfEntries];
        this.threshold = nrOfEntries;
        this.load = 0;
    }

    private static class Entry {
        public final int key;
        public int value;
        public Entry next;

        public Entry(int key, int value, Entry next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

