/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.repl.completers;

import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValueFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.IRascalValueFactory;

public class RascalLocationCompletion
implements Completer {
    private static final IValueFactory VF = IRascalValueFactory.getInstance();
    private static final URIResolverRegistry REG = URIResolverRegistry.getInstance();

    @Override
    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        if (!line.word().startsWith("|")) {
            return;
        }
        try {
            String locCandidate = line.word().substring(1);
            if (!locCandidate.contains("://")) {
                this.completeSchema(candidates, locCandidate);
                return;
            }
            if (this.completeAuthorities(candidates, locCandidate)) {
                return;
            }
            ISourceLocation directory = VF.sourceLocation(new URI(locCandidate));
            String fileName = "";
            if (!REG.isDirectory(directory)) {
                String fullPath = directory.getPath();
                int lastSeparator = fullPath.lastIndexOf(47);
                fileName = fullPath.substring(lastSeparator + 1);
                fullPath = fullPath.substring(0, lastSeparator + 1);
                if (!REG.isDirectory(directory = VF.sourceLocation(directory.getScheme(), directory.getAuthority(), fullPath))) {
                    return;
                }
            }
            for (String currentFile : REG.listEntries(directory)) {
                if (!currentFile.startsWith(fileName)) continue;
                this.add(candidates, URIUtil.getChildLocation(directory, currentFile));
            }
        }
        catch (IOException | URISyntaxException exception) {
            // empty catch block
        }
    }

    private void add(List<Candidate> candidates, ISourceLocation loc) {
        Object locCandidate = loc.toString();
        if (REG.isDirectory(loc) && !((String)(locCandidate = ((String)locCandidate).substring(0, ((String)locCandidate).length() - 1))).endsWith("/")) {
            locCandidate = (String)locCandidate + "/";
        }
        candidates.add(new Candidate((String)locCandidate, (String)locCandidate, "location", null, null, null, false));
    }

    private boolean completeAuthorities(List<Candidate> candidates, String locCandidate) throws URISyntaxException, IOException {
        int lastSeparator = locCandidate.lastIndexOf(47);
        if (lastSeparator > 3 && locCandidate.substring(lastSeparator - 2, lastSeparator + 1).equals("://")) {
            String scheme = locCandidate.substring(0, lastSeparator - 2);
            String partialAuthority = locCandidate.substring(lastSeparator + 1);
            ISourceLocation root = VF.sourceLocation(scheme, "", "");
            for (String candidate : REG.listEntries(root)) {
                if (!candidate.startsWith(partialAuthority)) continue;
                this.add(candidates, URIUtil.correctLocation(scheme, candidate, ""));
            }
            return true;
        }
        return false;
    }

    private void completeSchema(List<Candidate> candidates, String locCandidate) {
        this.filterCandidates(REG.getRegisteredInputSchemes(), candidates, locCandidate);
        this.filterCandidates(REG.getRegisteredLogicalSchemes(), candidates, locCandidate);
        this.filterCandidates(REG.getRegisteredOutputSchemes(), candidates, locCandidate);
    }

    private void filterCandidates(Set<String> src, List<Candidate> target, String prefix) {
        for (String s2 : src) {
            if (!s2.startsWith(prefix)) continue;
            this.add(target, URIUtil.rootLocation(s2));
        }
    }
}

