/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.repl.output;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.rascalmpl.repl.output.IOutputPrinter;

public interface IBinaryOutputPrinter
extends IOutputPrinter {
    default public void write(OutputStream target) throws IOException {
        throw new RuntimeException("Write to output stream only supported in case of binary output (such as images)");
    }

    default public InputStream asInputStream() {
        ByteArrayInputStream byteArrayInputStream;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            this.write(result);
            byteArrayInputStream = new ByteArrayInputStream(result.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    result.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new IllegalStateException("Write or Close should not have thrown an exception", ex);
            }
        }
        result.close();
        return byteArrayInputStream;
    }
}

