/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.repl.parametric;

import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jline.reader.Completer;
import org.jline.reader.Parser;
import org.jline.reader.impl.DefaultParser;
import org.jline.terminal.Terminal;
import org.rascalmpl.ideservices.IDEServices;
import org.rascalmpl.repl.IREPLService;
import org.rascalmpl.repl.output.ICommandOutput;
import org.rascalmpl.repl.parametric.ILanguageProtocol;
import org.rascalmpl.repl.parametric.ParametricCompleter;
import org.rascalmpl.repl.streams.StreamUtil;

public class ParametricReplService
implements IREPLService {
    private final ILanguageProtocol lang;
    private final @Nullable Path historyFile;
    private final IDEServices ide;
    private PrintWriter out;
    private PrintWriter err;

    public ParametricReplService(ILanguageProtocol lang, IDEServices ide, @Nullable Path historyFile) {
        this.lang = lang;
        this.historyFile = historyFile;
        this.ide = ide;
    }

    @Override
    public String name() {
        return "Parametric REPL";
    }

    @Override
    public IDEServices connect(Terminal term, boolean ansiColorSupported, boolean unicodeSupported) {
        this.out = term.writer();
        this.err = StreamUtil.generateErrorStream(term, term.writer());
        this.lang.initialize(term.reader(), this.out, this.err, this.ide);
        return this.ide;
    }

    @Override
    public void disconnect() {
        if (this.err != null) {
            this.err.close();
        }
    }

    @Override
    public String prompt(boolean ansiColorsSupported, boolean unicodeSupported) {
        return this.lang.getPrompt();
    }

    @Override
    public ICommandOutput handleInput(String input) throws InterruptedException {
        return this.lang.handleInput(input);
    }

    @Override
    public void handleInterrupt() throws InterruptedException {
        this.lang.cancelRunningCommandRequested();
    }

    @Override
    public String parseErrorPrompt(boolean ansiColorSupported, boolean unicodeSupported) {
        return ">> Parse error";
    }

    @Override
    public PrintWriter errorWriter() {
        return this.err;
    }

    @Override
    public PrintWriter outputWriter() {
        return this.out;
    }

    @Override
    public void flush() {
        this.err.flush();
        this.out.flush();
    }

    @Override
    public String interruptedPrompt(boolean ansiColorsSupported, boolean unicodeSupported) {
        return ">> Interrupted";
    }

    @Override
    public boolean supportsCompletion() {
        return this.lang.supportsCompletion();
    }

    @Override
    public List<Completer> completers() {
        return Collections.singletonList(new ParametricCompleter(this.lang));
    }

    @Override
    public Parser inputParser() {
        return new DefaultParser();
    }

    @Override
    public boolean storeHistory() {
        return this.historyFile == null;
    }

    @Override
    public Path historyFile() {
        return this.historyFile;
    }
}

