/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.runtime;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.IValue;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.interpreter.control_exceptions.Filtered;
import org.rascalmpl.interpreter.control_exceptions.MatchFailed;
import org.rascalmpl.parser.gtd.result.action.IActionExecutor;
import org.rascalmpl.values.functions.IFunction;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class RascalFunctionActionExecutor
implements IActionExecutor<ITree> {
    private final boolean isPure;
    private List<IFunction> filters;

    public RascalFunctionActionExecutor(ISet functions, boolean isPure) {
        this.isPure = isPure;
        assert (!functions.isEmpty());
        this.filters = functions.stream().map(v -> (IFunction)v).collect(Collectors.toList());
    }

    @Override
    public void completed(Object environment, boolean filtered) {
    }

    @Override
    public Object createRootEnvironment() {
        return new Object();
    }

    @Override
    public Object enteringListNode(Object production, int index, Object environment) {
        return environment;
    }

    @Override
    public Object enteringListProduction(Object production, Object env) {
        return env;
    }

    @Override
    public Object enteringNode(Object production, int index, Object environment) {
        return environment;
    }

    @Override
    public Object enteringProduction(Object production, Object env) {
        return env;
    }

    @Override
    public void exitedListProduction(Object production, boolean filtered, Object environment) {
    }

    @Override
    public void exitedProduction(Object production, boolean filtered, Object environment) {
    }

    @Override
    public ITree filterAmbiguity(ITree ambCluster, Object environment) {
        if (!TreeAdapter.isAmb(ambCluster)) {
            return ambCluster;
        }
        if (TreeAdapter.getAlternatives(ambCluster).size() == 0) {
            return null;
        }
        if (this.filters == null) {
            return ambCluster;
        }
        Iterator<IFunction> iterator = this.filters.iterator();
        if (iterator.hasNext()) {
            IFunction f = iterator.next();
            try {
                ITree result = (ITree)f.call(ambCluster);
                if (!TreeAdapter.isAmb(result)) {
                    return result;
                }
                if (TreeAdapter.getAlternatives(result).size() == 1) {
                    return (ITree)TreeAdapter.getAlternatives(result).iterator().next();
                }
                return result;
            }
            catch (MatchFailed m4) {
                return ambCluster;
            }
            catch (Throw t2) {
                IValue exc = t2.getException();
                if (exc.getType().isAbstractData() && ((IConstructor)exc).getConstructorType() == RuntimeExceptionFactory.CallFailed) {
                    return ambCluster;
                }
                throw t2;
            }
            catch (Filtered x) {
                return null;
            }
        }
        return ambCluster;
    }

    @Override
    public ITree filterCycle(ITree cycle, Object environment) {
        return cycle;
    }

    @Override
    public ITree filterListAmbiguity(ITree ambCluster, Object environment) {
        return this.filterAmbiguity(ambCluster, environment);
    }

    @Override
    public ITree filterListCycle(ITree cycle, Object environment) {
        return cycle;
    }

    @Override
    public ITree filterListProduction(ITree tree, Object environment) {
        return tree;
    }

    @Override
    public ITree filterProduction(ITree tree, Object environment) {
        if (this.filters == null) {
            return tree;
        }
        Iterator<IFunction> iterator = this.filters.iterator();
        if (iterator.hasNext()) {
            IFunction f = iterator.next();
            try {
                ITree result = (ITree)f.call(tree);
                if (!TreeAdapter.isAmb(result)) {
                    return result;
                }
                if (TreeAdapter.getAlternatives(result).size() == 1) {
                    return (ITree)TreeAdapter.getAlternatives(result).iterator().next();
                }
                return result;
            }
            catch (MatchFailed m4) {
                return tree;
            }
            catch (Throw t2) {
                IValue exc = t2.getException();
                if (exc.getType().isAbstractData() && ((IConstructor)exc).getConstructorType() == RuntimeExceptionFactory.CallFailed) {
                    return tree;
                }
                throw t2;
            }
            catch (Filtered x) {
                return null;
            }
        }
        return tree;
    }

    @Override
    public boolean isImpure(Object rhs) {
        return !this.isPure;
    }
}

