/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.semantics.dynamic;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.util.List;
import java.util.Map;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Assignable;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.Name;
import org.rascalmpl.ast.OptionalExpression;
import org.rascalmpl.ast.QualifiedName;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.interpreter.AssignableEvaluator;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.UndeclaredAnnotation;
import org.rascalmpl.interpreter.staticErrors.UndeclaredField;
import org.rascalmpl.interpreter.staticErrors.UndeclaredVariable;
import org.rascalmpl.interpreter.staticErrors.UnexpectedType;
import org.rascalmpl.interpreter.staticErrors.UninitializedVariable;
import org.rascalmpl.interpreter.staticErrors.UnsupportedOperation;
import org.rascalmpl.interpreter.staticErrors.UnsupportedSlice;
import org.rascalmpl.interpreter.staticErrors.UnsupportedSubscript;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.types.NonTerminalType;

public abstract class Assignable
extends org.rascalmpl.ast.Assignable {
    public Assignable(ISourceLocation __param1, IConstructor tree) {
        super(__param1, tree);
    }

    public static class Variable
    extends Assignable.Variable {
        public Variable(ISourceLocation __param1, IConstructor tree, QualifiedName __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public Result<IValue> assignment(AssignableEvaluator __eval) {
            QualifiedName qname = this.getQualifiedName();
            Result<IValue> previous = __eval.__getEnv().getVariable(qname);
            if (previous != null && previous.getValue() != null) {
                Result<IValue> newResult = __eval.newResult(previous, __eval.__getValue());
                newResult.setInferredType(previous.hasInferredType());
                __eval.__setValue(newResult);
                __eval.__getEnv().storeVariable(qname, __eval.__getValue());
                return __eval.__getValue();
            }
            switch (__eval.__getOperator()) {
                case Default: 
                case IsDefined: {
                    __eval.__getEnv().storeVariable(qname, __eval.__getValue());
                    return __eval.__getValue();
                }
            }
            throw new UninitializedVariable(Names.fullName(qname), this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            Result<IValue> var = __eval.getCurrentEnvt().getSimpleVariable(this.getQualifiedName());
            if (var != null) {
                return var;
            }
            throw new UndeclaredVariable(Names.fullName(this.getQualifiedName()), this);
        }
    }

    public static class Tuple
    extends Assignable.Tuple {
        public Tuple(ISourceLocation __param1, IConstructor tree, List<org.rascalmpl.ast.Assignable> __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public Result<IValue> assignment(AssignableEvaluator __eval) {
            List<org.rascalmpl.ast.Assignable> arguments = this.getElements();
            TypeFactory tf = AssignableEvaluator.__getTf();
            Type tupleTemplate = tf.tupleType((Type[])arguments.stream().map(a -> tf.valueType()).toArray(Type[]::new));
            if (!__eval.__getValue().getStaticType().comparable(tupleTemplate)) {
                throw new UnexpectedType(tupleTemplate, __eval.__getValue().getStaticType(), this);
            }
            Type tupleType = __eval.__getValue().getStaticType();
            ITuple tuple = (ITuple)__eval.__getValue().getValue();
            IValue[] results = new IValue[arguments.size()];
            Type[] resultTypes = new Type[arguments.size()];
            for (int i = 0; i < arguments.size(); ++i) {
                Type argType = tupleType.getFieldType(i);
                IValue arg = tuple.get(i);
                Result<IValue> result = ResultFactory.makeResult(argType, arg, __eval.__getEval());
                AssignableEvaluator ae = new AssignableEvaluator(__eval.__getEnv(), null, result, __eval.__getEval());
                Result<IValue> argResult = arguments.get(i).assignment(ae);
                results[i] = argResult.getValue();
                resultTypes[i] = argResult.getStaticType();
            }
            return ResultFactory.makeResult(AssignableEvaluator.__getTf().tupleType(resultTypes), __eval.__getEval().getValueFactory().tuple(results), __eval.__getEval());
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            throw new ImplementationError("Tuple in assignable does not represent a value:" + this);
        }
    }

    public static class SliceStep
    extends Assignable.SliceStep {
        public SliceStep(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Assignable __param2, OptionalExpression __param3, Expression __param4, OptionalExpression __param5) {
            super(__param1, tree, __param2, __param3, __param4, __param5);
        }

        @Override
        public Result<IValue> assignment(AssignableEvaluator __eval) {
            Result<IValue> result;
            Result<IValue> rec = this.getReceiver().interpret((Evaluator)__eval.__getEval());
            Result<IValue> first = null;
            if (this.getOptFirst().hasExpression()) {
                first = this.getOptFirst().getExpression().interpret((Evaluator)__eval.__getEval());
            }
            Result<IValue> second = this.getSecond().interpret((Evaluator)__eval.__getEval());
            Result<IValue> end = null;
            if (this.getOptLast().hasExpression()) {
                end = this.getOptLast().getExpression().interpret((Evaluator)__eval.__getEval());
            }
            assert (rec != null && rec.getValue() != null);
            if (first != null && !first.getStaticType().isInteger()) {
                throw new UnsupportedSubscript(rec.getStaticType(), first.getStaticType(), this);
            }
            if (!second.getStaticType().isInteger()) {
                throw new UnsupportedSubscript(rec.getStaticType(), second.getStaticType(), this);
            }
            if (end != null && !end.getStaticType().isInteger()) {
                throw new UnsupportedSubscript(rec.getStaticType(), end.getStaticType(), this);
            }
            int len = rec.getStaticType().isList() ? ((IList)rec.getValue()).length() : (rec.getStaticType().isString() ? ((IString)rec.getValue()).length() : (rec.getStaticType().isNode() ? ((INode)rec.getValue()).arity() : 0));
            int firstIndex = 0;
            int secondIndex = 1;
            int endIndex = len;
            if (first != null && (firstIndex = ((IInteger)first.getValue()).intValue()) < 0) {
                firstIndex += len;
            }
            if (end != null && (endIndex = ((IInteger)end.getValue()).intValue()) < 0) {
                endIndex += len;
            }
            if ((secondIndex = ((IInteger)second.getValue()).intValue()) < 0) {
                secondIndex += len;
            }
            if (first != null || end != null) {
                if (first == null && secondIndex > endIndex) {
                    firstIndex = len - 1;
                }
                if (end == null && secondIndex < firstIndex) {
                    endIndex = -1;
                }
            }
            if (rec.getStaticType().isList()) {
                try {
                    IList list = (IList)rec.getValue();
                    IValue repl = __eval.__getValue().getValue();
                    if (!repl.getType().isList()) {
                        throw new UnexpectedType(rec.getStaticType(), repl.getType(), __eval.__getEval().getCurrentAST());
                    }
                    __eval.__setValue(__eval.newResult(list, __eval.__getValue()));
                    list = list.replace(firstIndex, secondIndex, endIndex, (IList)repl);
                    result = ResultFactory.makeResult(rec.hasInferredType() ? rec.getStaticType().lub(list.getType()) : rec.getStaticType(), list, __eval.__getEval());
                }
                catch (IndexOutOfBoundsException e) {
                    throw RuntimeExceptionFactory.indexOutOfBounds((IInteger)first.getValue(), __eval.__getEval().getCurrentAST(), __eval.__getEval().getStackTrace());
                }
            } else if (rec.getStaticType().isString()) {
                try {
                    IString str = (IString)rec.getValue();
                    IValue repl = __eval.__getValue().getValue();
                    if (!repl.getType().isString()) {
                        throw new UnexpectedType(rec.getStaticType(), repl.getType(), __eval.__getEval().getCurrentAST());
                    }
                    __eval.__setValue(__eval.newResult(str, __eval.__getValue()));
                    str = str.replace(firstIndex, secondIndex, endIndex, (IString)repl);
                    result = ResultFactory.makeResult(rec.hasInferredType() ? rec.getStaticType().lub(str.getType()) : rec.getStaticType(), str, __eval.__getEval());
                }
                catch (IndexOutOfBoundsException e) {
                    throw RuntimeExceptionFactory.indexOutOfBounds((IInteger)first.getValue(), __eval.__getEval().getCurrentAST(), __eval.__getEval().getStackTrace());
                }
            } else if (rec.getStaticType().isNode()) {
                try {
                    INode node = (INode)rec.getValue();
                    IValue repl = __eval.__getValue().getValue();
                    if (!repl.getType().isList()) {
                        throw new UnexpectedType(rec.getStaticType(), repl.getType(), __eval.__getEval().getCurrentAST());
                    }
                    __eval.__setValue(__eval.newResult(node, __eval.__getValue()));
                    node = node.replace(firstIndex, secondIndex, endIndex, (IList)repl);
                    result = ResultFactory.makeResult(rec.hasInferredType() ? rec.getStaticType().lub(node.getType()) : rec.getStaticType(), node, __eval.__getEval());
                }
                catch (IndexOutOfBoundsException e) {
                    throw RuntimeExceptionFactory.indexOutOfBounds((IInteger)first.getValue(), __eval.__getEval().getCurrentAST(), __eval.__getEval().getStackTrace());
                }
            } else {
                throw new UnsupportedSlice(rec.getStaticType(), (AbstractAST)this);
            }
            return __eval.recur(this, result);
        }
    }

    public static class Slice
    extends Assignable.Slice {
        public Slice(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Assignable __param2, OptionalExpression __param3, OptionalExpression __param4) {
            super(__param1, tree, __param2, __param3, __param4);
        }

        @Override
        public Result<IValue> assignment(AssignableEvaluator __eval) {
            Result<IValue> result;
            Result<IValue> rec = this.getReceiver().interpret((Evaluator)__eval.__getEval());
            Result<IValue> first = null;
            if (this.getOptFirst().hasExpression()) {
                first = this.getOptFirst().getExpression().interpret((Evaluator)__eval.__getEval());
            }
            Result<IValue> end = null;
            if (this.getOptLast().hasExpression()) {
                end = this.getOptLast().getExpression().interpret((Evaluator)__eval.__getEval());
            }
            assert (rec != null && rec.getValue() != null);
            if (first != null && !first.getStaticType().isInteger()) {
                throw new UnsupportedSubscript(rec.getStaticType(), first.getStaticType(), this);
            }
            if (end != null && !end.getStaticType().isInteger()) {
                throw new UnsupportedSubscript(rec.getStaticType(), end.getStaticType(), this);
            }
            int len = rec.getStaticType().isList() ? ((IList)rec.getValue()).length() : (rec.getStaticType().isString() ? ((IString)rec.getValue()).length() : (rec.getStaticType().isNode() ? ((INode)rec.getValue()).arity() : 0));
            int firstIndex = 0;
            int secondIndex = 1;
            int endIndex = len;
            if (first != null && (firstIndex = ((IInteger)first.getValue()).intValue()) < 0) {
                firstIndex += len;
            }
            if (end != null && (endIndex = ((IInteger)end.getValue()).intValue()) < 0) {
                endIndex += len;
            }
            int n = secondIndex = firstIndex <= endIndex ? firstIndex + 1 : firstIndex - 1;
            if (rec.getStaticType().isList()) {
                try {
                    IList list = (IList)rec.getValue();
                    IValue repl = __eval.__getValue().getValue();
                    if (!repl.getType().isList()) {
                        throw new UnexpectedType(rec.getStaticType(), repl.getType(), __eval.__getEval().getCurrentAST());
                    }
                    __eval.__setValue(__eval.newResult(list, __eval.__getValue()));
                    list = list.replace(firstIndex, secondIndex, endIndex, (IList)repl);
                    result = ResultFactory.makeResult(rec.hasInferredType() ? rec.getStaticType().lub(list.getType()) : rec.getStaticType(), list, __eval.__getEval());
                }
                catch (IndexOutOfBoundsException e) {
                    throw RuntimeExceptionFactory.indexOutOfBounds((IInteger)first.getValue(), __eval.__getEval().getCurrentAST(), __eval.__getEval().getStackTrace());
                }
            } else if (rec.getStaticType().isString()) {
                try {
                    IString str = (IString)rec.getValue();
                    IValue repl = __eval.__getValue().getValue();
                    if (!repl.getType().isString()) {
                        throw new UnexpectedType(rec.getStaticType(), repl.getType(), __eval.__getEval().getCurrentAST());
                    }
                    __eval.__setValue(__eval.newResult(str, __eval.__getValue()));
                    str = str.replace(firstIndex, secondIndex, endIndex, (IString)repl);
                    result = ResultFactory.makeResult(rec.hasInferredType() ? rec.getStaticType().lub(str.getType()) : rec.getStaticType(), str, __eval.__getEval());
                }
                catch (IndexOutOfBoundsException e) {
                    throw RuntimeExceptionFactory.indexOutOfBounds((IInteger)first.getValue(), __eval.__getEval().getCurrentAST(), __eval.__getEval().getStackTrace());
                }
            } else if (rec.getStaticType().isNode()) {
                try {
                    INode node = (INode)rec.getValue();
                    IValue repl = __eval.__getValue().getValue();
                    if (!repl.getType().isList()) {
                        throw new UnexpectedType(rec.getStaticType(), repl.getType(), __eval.__getEval().getCurrentAST());
                    }
                    __eval.__setValue(__eval.newResult(node, __eval.__getValue()));
                    node = node.replace(firstIndex, secondIndex, endIndex, (IList)repl);
                    result = ResultFactory.makeResult(rec.hasInferredType() ? rec.getStaticType().lub(node.getType()) : rec.getStaticType(), node, __eval.__getEval());
                }
                catch (IndexOutOfBoundsException e) {
                    throw RuntimeExceptionFactory.indexOutOfBounds((IInteger)first.getValue(), __eval.__getEval().getCurrentAST(), __eval.__getEval().getStackTrace());
                }
            } else {
                throw new UnsupportedSlice(rec.getStaticType(), (AbstractAST)this);
            }
            return __eval.recur(this, result);
        }
    }

    public static class Subscript
    extends Assignable.Subscript {
        public Subscript(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Assignable __param2, Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Result<IValue> assignment(AssignableEvaluator __eval) {
            void var4_22;
            __eval.__getEval().setCurrentAST(this);
            Result<IValue> rec = this.getReceiver().interpret(__eval.__getEval());
            Result<IValue> subscript = this.getSubscript().interpret(__eval.__getEval());
            if (rec == null || rec.getValue() == null) {
                throw new UninitializedVariable(this.getReceiver());
            }
            if (rec.getStaticType().isList() && subscript.getStaticType().isInteger()) {
                try {
                    IList list = (IList)rec.getValue();
                    int index = ((IInteger)subscript.getValue()).intValue();
                    if (index < 0) {
                        index += list.length();
                    }
                    __eval.__setValue(__eval.newResult(list.get(index), __eval.__getValue()));
                    list = list.put(index, __eval.__getValue().getValue());
                    Result result = ResultFactory.makeResult(rec.hasInferredType() ? rec.getStaticType().lub(list.getType()) : rec.getStaticType(), list, __eval.__getEval());
                    return __eval.recur(this, (Result<IValue>)var4_22);
                }
                catch (IndexOutOfBoundsException e) {
                    throw RuntimeExceptionFactory.indexOutOfBounds((IInteger)subscript.getValue(), __eval.__getEval().getCurrentAST(), __eval.__getEval().getStackTrace());
                }
            } else if (rec.getStaticType().isMap()) {
                Type keyType = rec.getStaticType().getKeyType();
                if (!rec.hasInferredType() && !subscript.getStaticType().isSubtypeOf(keyType)) throw new UnexpectedType(keyType, subscript.getStaticType(), this.getSubscript());
                IValue oldValue = ((IMap)rec.getValue()).get(subscript.getValue());
                Result<IValue> oldResult = null;
                if (oldValue != null) {
                    Type oldType = rec.getStaticType().getValueType();
                    oldResult = Subscript.makeResult(oldType, oldValue, __eval.getEvaluator());
                    oldResult.setInferredType(rec.hasInferredType());
                    __eval.__setValue(__eval.newResult(oldResult, __eval.__getValue()));
                    IMap map = ((IMap)rec.getValue()).put(subscript.getValue(), __eval.__getValue().getValue());
                    Result result = Subscript.makeResult(rec.hasInferredType() ? rec.getStaticType().lub(map.getType()) : rec.getStaticType(), map, __eval.__getEval());
                    return __eval.recur(this, (Result<IValue>)var4_22);
                } else {
                    __eval.newResult(oldResult, __eval.__getValue());
                    IMap map = ((IMap)rec.getValue()).put(subscript.getValue(), __eval.__getValue().getValue());
                    Result result = Subscript.makeResult(rec.hasInferredType() ? rec.getStaticType().lub(map.getType()) : rec.getStaticType(), map, __eval.__getEval());
                }
                return __eval.recur(this, (Result<IValue>)var4_22);
            } else if (rec.getStaticType().isNode() && subscript.getStaticType().isInteger()) {
                IConstructor node;
                int index = ((IInteger)subscript.getValue()).intValue();
                if (index >= (node = (IConstructor)rec.getValue()).arity()) {
                    throw RuntimeExceptionFactory.indexOutOfBounds((IInteger)subscript.getValue(), __eval.__getEval().getCurrentAST(), __eval.__getEval().getStackTrace());
                }
                __eval.__setValue(__eval.newResult(node.get(index), __eval.__getValue()));
                node = node.set(index, __eval.__getValue().getValue());
                Result result = ResultFactory.makeResult(rec.getStaticType(), node, __eval.__getEval());
                return __eval.recur(this, (Result<IValue>)var4_22);
            } else if (rec.getStaticType().isTuple() && subscript.getStaticType().isInteger()) {
                ITuple tuple;
                int index = ((IInteger)subscript.getValue()).intValue();
                if (index >= (tuple = (ITuple)rec.getValue()).arity()) {
                    throw RuntimeExceptionFactory.indexOutOfBounds((IInteger)subscript.getValue(), __eval.__getEval().getCurrentAST(), __eval.__getEval().getStackTrace());
                }
                __eval.__setValue(__eval.newResult(tuple.get(index), __eval.__getValue()));
                tuple = tuple.set(index, __eval.__getValue().getValue());
                Result result = ResultFactory.makeResult(rec.getStaticType(), tuple, __eval.__getEval());
                return __eval.recur(this, (Result<IValue>)var4_22);
            } else {
                if (!rec.getStaticType().isRelation() || !subscript.getStaticType().isSubtypeOf(rec.getStaticType().getFieldType(0))) throw new UnsupportedSubscript(rec.getStaticType(), subscript.getStaticType(), this);
                ISet rel = (ISet)rec.getValue();
                IValue sub = subscript.getValue();
                if (rec.getStaticType().getArity() != 2) {
                    throw new UnsupportedSubscript(rec.getStaticType(), subscript.getStaticType(), this);
                }
                if (!__eval.__getValue().getStaticType().isSubtypeOf(rec.getStaticType().getFieldType(1))) {
                    throw new UnexpectedType(rec.getStaticType().getFieldType(1), __eval.__getValue().getStaticType(), __eval.__getEval().getCurrentAST());
                }
                rel = rel.insert(__eval.__getEval().getValueFactory().tuple(sub, __eval.__getValue().getValue()));
                Result result = ResultFactory.makeResult(rec.getStaticType(), rel, __eval.__getEval());
            }
            return __eval.recur(this, (Result<IValue>)var4_22);
        }

        private Result<IValue> normalizedResult(IEvaluator<Result<IValue>> __eval, Type t2, IValue v) {
            Map<Type, Type> bindings = __eval.getCurrentEnvt().getStaticTypeBindings();
            Type instance = bindings.size() > 0 ? t2.instantiate(bindings) : t2;
            if (v != null) {
                this.checkType(v.getType(), instance);
            }
            return ResultFactory.makeResult(instance, v, __eval);
        }

        private void checkType(Type given, Type expected) {
            if (expected.isFunction()) {
                return;
            }
            if (!given.isSubtypeOf(expected)) {
                throw new UnexpectedType(expected, given, this);
            }
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            Result<IValue> receiver = this.getReceiver().interpret(__eval);
            Result<IValue> subscript = this.getSubscript().interpret(__eval);
            assert (receiver != null && receiver.getValue() != null);
            if (receiver.getStaticType().isList()) {
                if (subscript.getStaticType().isInteger()) {
                    IList list = (IList)receiver.getValue();
                    IValue result = list.get(((IInteger)subscript.getValue()).intValue());
                    Type type = receiver.getStaticType().getElementType();
                    return this.normalizedResult(__eval, type, result);
                }
                throw new UnexpectedType(Evaluator.__getTf().integerType(), subscript.getStaticType(), this);
            }
            if (receiver.getStaticType().isMap()) {
                Type keyType = receiver.getStaticType().getKeyType();
                if (receiver.hasInferredType() || subscript.getStaticType().isSubtypeOf(keyType)) {
                    IValue result = ((IMap)receiver.getValue()).get(subscript.getValue());
                    if (result == null) {
                        throw RuntimeExceptionFactory.noSuchKey(subscript.getValue(), this, __eval.getStackTrace());
                    }
                    Type type = receiver.getStaticType().getValueType();
                    return ResultFactory.makeResult(type, result, __eval);
                }
                throw new UnexpectedType(keyType, subscript.getStaticType(), this.getSubscript());
            }
            throw new UnsupportedOperation("subscript", receiver.getStaticType(), this);
        }

        @Override
        public Result<IBool> isDefined(IEvaluator<Result<IValue>> __eval) {
            Result<IValue> subscript = this.getSubscript().interpret(__eval);
            return this.getReceiver().interpret(__eval.getEvaluator()).isKeyDefined(new Result[]{subscript});
        }
    }

    public static class IfDefinedOrDefault
    extends Assignable.IfDefinedOrDefault {
        public IfDefinedOrDefault(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Assignable __param2, Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public Result<IValue> assignment(AssignableEvaluator ae) {
            if (this.getReceiver().isDefined(ae.getEvaluator()).getValue().getValue()) {
                return this.getReceiver().assignment(ae);
            }
            ae.__setValue(ae.newResult(this.lubResult(this.getDefaultExpression().interpret((Evaluator)ae.__getEval()), ae.__getValue(), ae), ae.__getValue()));
            ae.__setOperator(AssignableEvaluator.AssignmentOperator.Default);
            return this.getReceiver().assignment(ae);
        }

        private Result<IValue> lubResult(Result<IValue> newValue, Result<IValue> oldValue, AssignableEvaluator ae) {
            return ResultFactory.makeResult(oldValue.getStaticType().lub(newValue.getStaticType()), newValue.getValue(), ae.__getEval());
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            throw new ImplementationError("ifdefined assignable does not represent a value");
        }
    }

    public static class FieldAccess
    extends Assignable.FieldAccess {
        public FieldAccess(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Assignable __param2, Name __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public Result<IValue> assignment(AssignableEvaluator __eval) {
            Result<IValue> receiver = this.getReceiver().interpret((Evaluator)__eval.__getEval());
            String label = Names.name(this.getField());
            if (receiver == null || receiver.getValue() == null) {
                throw new UninitializedVariable(label, this.getReceiver());
            }
            if (receiver.getStaticType().isTuple()) {
                int idx = receiver.getStaticType().getFieldIndex(label);
                if (idx < 0) {
                    throw new UndeclaredField(label, receiver.getStaticType(), this);
                }
                __eval.__setValue(__eval.newResult(((ITuple)receiver.getValue()).get(idx), __eval.__getValue()));
                ITuple result = ((ITuple)receiver.getValue()).set(idx, __eval.__getValue().getValue());
                return __eval.recur(this, ResultFactory.makeResult(receiver.getStaticType(), result, __eval.__getEval()));
            }
            if (receiver.getStaticType() instanceof NonTerminalType) {
                Result<IValue> result = receiver.fieldUpdate(label, __eval.__getValue(), __eval.getCurrentEnvt().getStore());
                __eval.__setValue(__eval.newResult(receiver.fieldAccess(label, __eval.getCurrentEnvt().getStore()), __eval.__getValue()));
                if (!result.getStaticType().isSubtypeOf(receiver.getStaticType())) {
                    throw new UnexpectedType(receiver.getStaticType(), result.getStaticType(), __eval.getCurrentAST());
                }
                return __eval.recur(this, result);
            }
            if (receiver.getStaticType().isConstructor() || receiver.getStaticType().isAbstractData()) {
                IConstructor cons = (IConstructor)receiver.getValue();
                Type node = cons.getConstructorType();
                if (node.hasField(label)) {
                    int index = node.getFieldIndex(label);
                    if (!__eval.__getValue().getStaticType().isSubtypeOf(node.getFieldType(index))) {
                        throw new UnexpectedType(node.getFieldType(index), __eval.__getValue().getStaticType(), this);
                    }
                    __eval.__setValue(__eval.newResult(cons.get(index), __eval.__getValue()));
                    IConstructor result = cons.set(index, __eval.__getValue().getValue());
                    return __eval.recur(this, ResultFactory.makeResult(receiver.getStaticType(), result, __eval.__getEval()));
                }
                if (cons.getUninstantiatedConstructorType().hasKeywordField(label, __eval.getCurrentEnvt().getStore())) {
                    Type declaredType = __eval.getCurrentEnvt().getStore().getKeywordParameterType(cons.getUninstantiatedConstructorType(), label);
                    if (!__eval.__getValue().getStaticType().isSubtypeOf(declaredType)) {
                        throw new UnexpectedType(declaredType, __eval.__getValue().getStaticType(), this);
                    }
                    Object paramValue = cons.asWithKeywordParameters().getParameter(label);
                    if (paramValue == null) {
                        __eval.__getOperator();
                        paramValue = __eval.__getOperator().name().equals(AssignableEvaluator.AssignmentOperator.IsDefined.name()) && __eval.__getValue() != null ? __eval.__getValue().getValue() : receiver.fieldAccess(label, __eval.getCurrentEnvt().getStore()).getValue();
                    }
                    __eval.__setValue(__eval.newResult((IValue)paramValue, __eval.__getValue()));
                    IConstructor result = cons.asWithKeywordParameters().setParameter(label, __eval.__getValue().getValue());
                    return __eval.recur(this, ResultFactory.makeResult(receiver.getStaticType(), result, __eval.__getEval()));
                }
                throw new UndeclaredField(label, receiver.getValue().getType(), this);
            }
            if (receiver.getStaticType().isSourceLocation()) {
                __eval.__setValue(__eval.newResult(receiver.fieldAccess(label, __eval.__getEnv().getStore()), __eval.__getValue()));
                return __eval.recur(this, receiver.fieldUpdate(label, __eval.__getValue(), __eval.__getEnv().getStore()));
            }
            if (receiver.getStaticType().isDateTime()) {
                __eval.__setValue(__eval.newResult(receiver.fieldAccess(label, __eval.__getEnv().getStore()), __eval.__getValue()));
                return __eval.recur(this, receiver.fieldUpdate(label, __eval.__getValue(), __eval.__getEnv().getStore()));
            }
            throw new UndeclaredField(label, receiver.getStaticType(), this);
        }

        @Override
        public Result<IBool> isDefined(IEvaluator<Result<IValue>> __eval) {
            return FieldAccess.makeResult(TF.boolType(), this.getReceiver().interpret(__eval.getEvaluator()).isDefined(this.getField()).getValue(), __eval.getEvaluator());
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            Result<IValue> receiver = this.getReceiver().interpret(__eval);
            String label = Names.name(this.getField());
            if (receiver == null || receiver.getValue() == null) {
                throw new UndeclaredVariable(label, this.getReceiver());
            }
            Type receiverType = receiver.getStaticType();
            if (receiverType.isTuple()) {
                int index = receiverType.getFieldIndex(label);
                IValue result = ((ITuple)receiver.getValue()).get(index);
                Type type = receiverType.getFieldType(index);
                return ResultFactory.makeResult(type, result, __eval);
            }
            if (receiverType.isExternalType() && receiverType instanceof NonTerminalType) {
                return receiver.fieldAccess(label, __eval.getCurrentEnvt().getStore());
            }
            if (receiverType.isConstructor() || receiverType.isAbstractData()) {
                IConstructor cons = (IConstructor)receiver.getValue();
                Type node = cons.getConstructorType();
                Type kwType = __eval.getCurrentEnvt().getConstructorFunction(node).getKeywordArgumentTypes(__eval.getCurrentEnvt());
                if (!kwType.hasField(label) && !node.hasField(label)) {
                    throw new UndeclaredField(label, receiverType, this);
                }
                if (kwType.hasField(label)) {
                    return ResultFactory.makeResult(kwType.getFieldType(label), cons.asWithKeywordParameters().getParameter(label), __eval);
                }
                int index = node.getFieldIndex(label);
                return ResultFactory.makeResult(node.getFieldType(index), cons.get(index), __eval);
            }
            if (receiverType.isSourceLocation()) {
                return receiver.fieldAccess(label, new TypeStore(new TypeStore[0]));
            }
            throw new UndeclaredField(label, receiverType, this);
        }
    }

    public static class Constructor
    extends Assignable.Constructor {
        public Constructor(ISourceLocation __param1, IConstructor tree, Name __param2, List<org.rascalmpl.ast.Assignable> __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public Result<IValue> assignment(AssignableEvaluator __eval) {
            Type valueType = __eval.__getValue().getStaticType();
            if (!(valueType.isNode() || valueType.isAbstractData() || valueType.isConstructor())) {
                throw new UnexpectedType(AssignableEvaluator.__getTf().nodeType(), __eval.__getValue().getStaticType(), this);
            }
            IConstructor node = (IConstructor)__eval.__getValue().getValue();
            Type nodeType = node.getType();
            if (nodeType.isAbstractData()) {
                nodeType = ((IConstructor)__eval.__getValue().getValue()).getConstructorType();
            }
            if (!node.getName().equals(Names.name(this.getName()))) {
                throw RuntimeExceptionFactory.nameMismatch(node.getName(), Names.name(this.getName()), this.getName(), __eval.__getEval().getStackTrace());
            }
            List<org.rascalmpl.ast.Assignable> arguments = this.getArguments();
            if (node.arity() != arguments.size()) {
                throw RuntimeExceptionFactory.arityMismatch(node.arity(), arguments.size(), (AbstractAST)this, __eval.__getEval().getStackTrace());
            }
            IValue[] results = new IValue[arguments.size()];
            Type[] resultTypes = new Type[arguments.size()];
            for (int i = 0; i < arguments.size(); ++i) {
                Type argType = !nodeType.isConstructor() ? AssignableEvaluator.__getTf().valueType() : nodeType.getFieldType(i);
                IValue arg = node.get(i);
                Result<IValue> result = ResultFactory.makeResult(argType, arg, __eval.__getEval());
                AssignableEvaluator ae = new AssignableEvaluator(__eval.__getEnv(), null, result, __eval.__getEval());
                Result<IValue> argResult = arguments.get(i).assignment(ae);
                results[i] = argResult.getValue();
                resultTypes[i] = argType;
            }
            if (!nodeType.isAbstractData() && !nodeType.isConstructor()) {
                return ResultFactory.makeResult(nodeType, __eval.__getEval().getValueFactory().node(node.getName(), results), __eval.__getEval());
            }
            Type constructor = __eval.__getEval().getCurrentEnvt().getConstructor(node.getName(), AssignableEvaluator.__getTf().tupleType(resultTypes));
            if (constructor == null) {
                throw new ImplementationError("could not find constructor for " + node.getName() + " : " + AssignableEvaluator.__getTf().tupleType(resultTypes));
            }
            return ResultFactory.makeResult(constructor.getAbstractDataType(), __eval.__getEval().getValueFactory().constructor(constructor, results), __eval.__getEval());
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            throw new ImplementationError("Constructor assignable does not represent a value");
        }
    }

    public static class Bracket
    extends Assignable.Bracket {
        public Bracket(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Assignable __param2) {
            super(__param1, tree, __param2);
        }
    }

    public static class Annotation
    extends Assignable.Annotation {
        public Annotation(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Assignable __param2, Name __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public Result<IValue> assignment(AssignableEvaluator __eval) {
            String label = Names.name(this.getAnnotation());
            Result<IValue> result = this.getReceiver().interpret((Evaluator)__eval.__getEval());
            if (result == null || result.getValue() == null) {
                throw new UninitializedVariable(label, this.getReceiver());
            }
            try {
                __eval.__setValue(__eval.newResult(result.getAnnotation(label, __eval.__getEnv()), __eval.__getValue()));
            }
            catch (Throw throw_) {
                // empty catch block
            }
            return __eval.recur(this, result.setAnnotation(label, __eval.__getValue(), __eval.__getEnv()));
        }

        @Override
        public Result<IBool> isDefined(IEvaluator<Result<IValue>> __eval) {
            return Annotation.makeResult(TF.boolType(), this.getReceiver().interpret(__eval.getEvaluator()).has(this.getAnnotation()).getValue(), __eval.getEvaluator());
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            Result<IValue> receiver = this.getReceiver().interpret(__eval);
            String label = Names.name(this.getAnnotation());
            if (!__eval.getCurrentEnvt().declaresAnnotation(receiver.getStaticType(), label)) {
                throw new UndeclaredAnnotation(label, receiver.getStaticType(), this);
            }
            Type type = __eval.getCurrentEnvt().getAnnotationType(receiver.getStaticType(), label);
            Object value = ((IConstructor)receiver.getValue()).asWithKeywordParameters().getParameter(label);
            return ResultFactory.makeResult(type, value, __eval);
        }
    }
}

