/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.semantics.dynamic;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.exceptions.FactParseError;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.io.StandardTextReader;
import io.usethesource.vallang.type.Type;
import java.io.IOException;
import java.io.StringReader;
import org.rascalmpl.ast.DateAndTime;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.staticErrors.DateTimeSyntax;

public abstract class DateAndTime
extends org.rascalmpl.ast.DateAndTime {
    public DateAndTime(ISourceLocation __param1, IConstructor tree) {
        super(__param1, tree);
    }

    public static class Lexical
    extends DateAndTime.Lexical {
        public Lexical(ISourceLocation __param1, IConstructor tree, String __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            String dtPart = this.getString().substring(1);
            String datePart = dtPart.substring(0, dtPart.indexOf("T"));
            String timePart = dtPart.substring(dtPart.indexOf("T") + 1);
            timePart = timePart.substring(0, timePart.length() - 1);
            return this.createVisitedDateTime(__eval, datePart, timePart, this);
        }

        @Override
        public Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return TF.dateTimeType();
        }

        public Result<IValue> createVisitedDateTime(IEvaluator<Result<IValue>> eval, String datePart, String timePart, DateAndTime.Lexical x) {
            try {
                StandardTextReader parser = new StandardTextReader();
                IValue result = parser.read(VF, new StringReader("$" + datePart + "T" + timePart + "$"));
                return Lexical.makeResult(TF.dateTimeType(), result, eval);
            }
            catch (FactTypeUseException e) {
                throw new DateTimeSyntax(e.getMessage(), eval.getCurrentAST().getLocation());
            }
            catch (FactParseError e) {
                throw new DateTimeSyntax(e.getMessage(), eval.getCurrentAST().getLocation());
            }
            catch (IOException e) {
                throw new ImplementationError(e.getMessage());
            }
        }
    }
}

