/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.semantics.dynamic;

import io.usethesource.vallang.IValue;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.staticErrors.NonVoidTypeRequired;
import org.rascalmpl.semantics.dynamic.Comprehension;
import org.rascalmpl.semantics.dynamic.ComprehensionWriter;

public class SetComprehensionWriter
extends ComprehensionWriter {
    public SetComprehensionWriter(List<Expression> resultExprs, IEvaluator<Result<IValue>> ev) {
        super(resultExprs, ev);
        this.writer = this.VF.setWriter();
        this.elementType1 = this.TF.voidType();
    }

    @Override
    public void append() {
        for (Expression resExpr : this.resultExprs) {
            if (resExpr.isSplice() || resExpr.isSplicePlus()) {
                Result<IValue> set = resExpr.getArgument().interpret(this.ev);
                if (set.getStaticType().isSet() || set.getStaticType().isList()) {
                    this.elementType1 = this.elementType1.lub(set.getStaticType().getElementType());
                    this.writer.insertAll((Iterable)((Object)set.getValue()));
                    continue;
                }
                this.elementType1 = this.elementType1.lub(set.getStaticType());
                this.writer.insert(set.getValue());
                continue;
            }
            Result<IValue> res = resExpr.interpret(this.ev);
            if (res == null || res.getStaticType().isBottom()) {
                throw new NonVoidTypeRequired(this.ev.getCurrentAST());
            }
            this.elementType1 = this.elementType1.lub(res.getStaticType());
            this.writer.insert(res.getValue());
        }
    }

    @Override
    public Result<IValue> done() {
        return this.writer == null ? Comprehension.makeResult(this.TF.setType(this.TF.voidType()), this.VF.set(new IValue[0]), this.getContext((AbstractAST)this.resultExprs.get(0))) : Comprehension.makeResult(this.TF.setType(this.elementType1), this.writer.done(), this.getContext((AbstractAST)this.resultExprs.get(0)));
    }
}

