/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.unicode;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.rascalmpl.unicode.ByteOrderMarker;
import org.rascalmpl.unicode.ConcatInputStream;
import org.rascalmpl.unicode.UnicodeDetector;

public class UnicodeInputStreamReader
extends Reader {
    private Reader wrapped;
    private InputStream original;
    private String encoding;

    public UnicodeInputStreamReader(InputStream in) {
        this.original = in;
    }

    public UnicodeInputStreamReader(InputStream in, String encoding) {
        this.original = in;
        this.encoding = encoding;
    }

    public UnicodeInputStreamReader(InputStream in, Charset charset) {
        this(in, charset == null ? null : charset.name());
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.wrapped == null) {
            if (this.encoding != null) {
                this.wrapped = UnicodeInputStreamReader.removeBOM(this.original, this.encoding);
                this.original = null;
            } else {
                this.wrapped = UnicodeInputStreamReader.detectCharset(this.original);
                this.original = null;
            }
        }
        return this.wrapped.read(cbuf, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.wrapped != null) {
            this.wrapped.close();
        } else {
            this.original.close();
        }
    }

    private static Reader removeBOM(InputStream in, String encoding) throws IOException {
        int bufferSize;
        byte[] detectionBuffer = new byte[UnicodeDetector.getMaximumBOMLength()];
        ByteOrderMarker b = UnicodeDetector.detectBom(detectionBuffer, bufferSize = in.read(detectionBuffer));
        if (b != null) {
            Charset ref = Charset.forName(encoding);
            if (UnicodeDetector.isAmbigiousBOM(b.getCharset(), ref)) {
                b = ByteOrderMarker.fromString(encoding);
            }
            if (b.getCharset().equals(ref) || b.getGroup().equals(ref)) {
                ByteArrayInputStream prefix = new ByteArrayInputStream(detectionBuffer, b.getHeaderLength(), bufferSize - b.getHeaderLength());
                return new InputStreamReader((InputStream)new ConcatInputStream(prefix, in), b.getCharset());
            }
            throw new UnsupportedEncodingException("The requested encoding was " + encoding + " but the file contained a BOM for " + b.getCharset().name() + ".");
        }
        ByteArrayInputStream prefix = new ByteArrayInputStream(detectionBuffer, 0, bufferSize);
        return new InputStreamReader((InputStream)new ConcatInputStream(prefix, in), encoding);
    }

    private static Reader detectCharset(InputStream in) throws IOException {
        int bufferSize;
        byte[] detectionBuffer = new byte[UnicodeDetector.getSuggestedDetectionSampleSize()];
        ByteOrderMarker b = UnicodeDetector.detectBom(detectionBuffer, bufferSize = in.read(detectionBuffer));
        if (b != null) {
            ByteArrayInputStream prefix = new ByteArrayInputStream(detectionBuffer, b.getHeaderLength(), bufferSize - b.getHeaderLength());
            return new InputStreamReader((InputStream)new ConcatInputStream(prefix, in), b.getCharset());
        }
        Charset cs = UnicodeDetector.detectByContent(detectionBuffer, bufferSize);
        if (cs == null) {
            cs = Charset.defaultCharset();
        }
        ByteArrayInputStream prefix = new ByteArrayInputStream(detectionBuffer, 0, bufferSize);
        return new InputStreamReader((InputStream)new ConcatInputStream(prefix, in), cs);
    }
}

