/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Scheduler;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.util.SecondsTicker;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ExpiringFunctionResultCache<TResult> {
    private final Cache<Object, TResult> entries;
    private final ReferenceQueue<Parameters> cleared;

    public ExpiringFunctionResultCache(int secondsTimeout, int maxEntries) {
        this.entries = ExpiringFunctionResultCache.configure(secondsTimeout, maxEntries).softValues().build();
        this.cleared = new ReferenceQueue();
        ExpiringFunctionResultCache.scheduleCleanup(this);
    }

    private static Caffeine<Object, Object> configure(int secondsTimeout, int maxEntries) {
        Caffeine<Object, Object> result = Caffeine.newBuilder();
        if (secondsTimeout > 0) {
            result = result.ticker(ExpiringFunctionResultCache::simulateNanoTicks).expireAfterAccess(Duration.ofSeconds(secondsTimeout));
        }
        if (maxEntries > 0) {
            result = result.maximumSize(maxEntries);
        }
        return result.executor(Runnable::run).scheduler(Scheduler.systemScheduler());
    }

    private static long simulateNanoTicks() {
        return TimeUnit.SECONDS.toNanos(SecondsTicker.current());
    }

    public @Nullable TResult lookup(IValue[] args, @Nullable Map<String, IValue> kwParameters) {
        return this.entries.getIfPresent(Parameters.forLookup(args, kwParameters));
    }

    public TResult store(IValue[] args, @Nullable Map<String, IValue> kwParameters, TResult result) {
        return (TResult)this.entries.get(new ParametersRef(Parameters.forStorage(args, kwParameters), this.cleared), k -> result);
    }

    public void clear() {
        this.entries.invalidateAll();
    }

    private static void scheduleCleanup(@UnknownInitialization ExpiringFunctionResultCache<?> cache) {
        ExpiringFunctionResultCache.doCleanup(new WeakReference(cache));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCleanup(WeakReference<ExpiringFunctionResultCache<?>> cache) {
        ExpiringFunctionResultCache actualCache = (ExpiringFunctionResultCache)cache.get();
        if (actualCache == null) {
            return;
        }
        CompletableFuture.delayedExecutor(3L, TimeUnit.SECONDS).execute(() -> ExpiringFunctionResultCache.doCleanup(cache));
        ReferenceQueue<Parameters> referenceQueue = actualCache.cleared;
        synchronized (referenceQueue) {
            Reference<Parameters> gced;
            while ((gced = actualCache.cleared.poll()) != null) {
                actualCache.entries.invalidate(gced);
            }
        }
    }

    private static class ParametersRef
    extends SoftReference<Parameters> {
        private final int hashCode;

        public ParametersRef(Parameters obj, ReferenceQueue<? super Parameters> queue) {
            super(obj, queue);
            this.hashCode = obj.storedHash;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Parameters) {
                return obj.equals(this);
            }
            if (obj instanceof ParametersRef && ((ParametersRef)obj).hashCode == this.hashCode) {
                Parameters our = (Parameters)this.get();
                return our != null && our.equals(((ParametersRef)obj).get());
            }
            return false;
        }
    }

    private static class Parameters {
        private final int storedHash;
        private final IValue[] params;
        private final Map<String, IValue> keyArgs;

        private Parameters(IValue[] params, Map<String, IValue> keyArgs) {
            this.params = params;
            this.keyArgs = keyArgs;
            this.storedHash = 1 + 31 * Arrays.hashCode(this.params) + keyArgs.hashCode();
        }

        public static Parameters forLookup(IValue[] params, @Nullable Map<String, IValue> keyArgs) {
            if (keyArgs == null || keyArgs.isEmpty()) {
                keyArgs = Collections.emptyMap();
            }
            return new Parameters(params, keyArgs);
        }

        public static Parameters forStorage(IValue[] params, @Nullable Map<String, IValue> keyArgs) {
            if (keyArgs == null || keyArgs.isEmpty()) {
                keyArgs = Collections.emptyMap();
            }
            IValue[] newParams = new IValue[params.length];
            System.arraycopy(params, 0, newParams, 0, params.length);
            return new Parameters(newParams, keyArgs);
        }

        public int hashCode() {
            return this.storedHash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ParametersRef && ((ParametersRef)obj).hashCode == this.storedHash) {
                return this.equals(((ParametersRef)obj).get());
            }
            if (obj instanceof Parameters) {
                Parameters other = (Parameters)obj;
                return other.storedHash == this.storedHash && Arrays.equals(this.params, other.params) && this.keyArgs.equals(other.keyArgs);
            }
            return false;
        }
    }
}

