/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.base64;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.rascalmpl.util.base64.Base64CharWriter;
import org.rascalmpl.util.base64.Base64DecodingInputStream;
import org.rascalmpl.util.base64.Base64EncodingOutputStream;
import org.rascalmpl.util.base64.ByteReader;

public class StreamingBase64 {
    public static OutputStream encode(Writer target) {
        return StreamingBase64.encode(target, true);
    }

    public static OutputStream encode(Writer target, boolean padding) {
        return StreamingBase64.encode(Base64CharWriter.latinBytesTo(target), padding);
    }

    public static OutputStream encode(StringBuilder target) {
        return StreamingBase64.encode(target, true);
    }

    public static OutputStream encode(StringBuilder target, boolean padding) {
        return StreamingBase64.encode(Base64CharWriter.latinBytesTo(target), padding);
    }

    private static OutputStream encode(Base64CharWriter target, boolean padding) {
        return new Base64EncodingOutputStream(target, padding);
    }

    public static void encode(InputStream source, StringBuilder target, boolean padding) throws IOException {
        Base64EncodingOutputStream.direct(source, Base64CharWriter.latinBytesTo(target), padding);
    }

    public static void encode(InputStream source, Writer target, boolean padding) throws IOException {
        Base64EncodingOutputStream.direct(source, Base64CharWriter.latinBytesTo(target), padding);
    }

    public static InputStream decode(Reader source) {
        return StreamingBase64.decode(ByteReader.fromLatin(source));
    }

    public static InputStream decode(String source) {
        return StreamingBase64.decode(ByteReader.fromLatin(source));
    }

    public static InputStream decode(byte[] source) {
        return StreamingBase64.decode(ByteReader.fromBytes(source));
    }

    private static InputStream decode(ByteReader source) {
        return new Base64DecodingInputStream(source);
    }

    public static void decode(Reader source, OutputStream target) throws IOException {
        Base64DecodingInputStream.direct(ByteReader.fromLatin(source), target);
    }

    public static void decode(String source, OutputStream target) throws IOException {
        Base64DecodingInputStream.direct(ByteReader.fromLatin(source), target);
    }

    public static void decode(byte[] source, OutputStream target) throws IOException {
        Base64DecodingInputStream.direct(ByteReader.fromBytes(source), target);
    }
}

