/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.capsule.core.trie;

import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicReference;

public interface ArrayView<T>
extends Iterable<T> {
    public int size();

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    public T get(int var1);

    default public void set(int index, T item) {
        throw new UnsupportedOperationException();
    }

    default public void set(int index, T item, AtomicReference<?> writeCapabilityToken) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public ListIterator<T> iterator() {
        return new ListIterator<T>(){
            private volatile int current = 0;
            private volatile int previous = -1;

            @Override
            public boolean hasNext() {
                return this.current < ArrayView.this.size();
            }

            @Override
            public T next() {
                this.previous = this.current++;
                return ArrayView.this.get(this.previous);
            }

            @Override
            public boolean hasPrevious() {
                return this.current >= 0;
            }

            @Override
            public T previous() {
                this.previous = this.current--;
                return ArrayView.this.get(this.previous);
            }

            @Override
            public int nextIndex() {
                return this.current + 1;
            }

            @Override
            public int previousIndex() {
                return this.current - 1;
            }

            @Override
            public void set(T t2) {
                if (this.previous == -1) {
                    throw new IllegalStateException();
                }
                ArrayView.this.set(this.previous, t2);
            }

            @Override
            public void add(T t2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> ArrayView<T> empty() {
        return new ArrayView<T>(){

            @Override
            public int size() {
                return 0;
            }

            @Override
            public T get(int index) {
                throw new IndexOutOfBoundsException();
            }
        };
    }
}

