/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.fields;

import io.usethesource.capsule.Map;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.impl.fields.AbstractDefaultWithKeywordParameters;
import io.usethesource.vallang.io.StandardTextWriter;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.visitors.IValueVisitor;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

public class ConstructorWithKeywordParametersFacade
implements IConstructor {
    protected final IConstructor content;
    protected final Map.Immutable<String, IValue> parameters;

    public ConstructorWithKeywordParametersFacade(IConstructor content, Map.Immutable<String, IValue> parameters) {
        this.content = content;
        this.parameters = parameters;
    }

    @Override
    public INode setChildren(IValue[] childArray) {
        return this.content.setChildren(childArray).asWithKeywordParameters().setParameters(this.parameters);
    }

    @Override
    public Type getType() {
        return this.content.getType();
    }

    @Override
    public <T, E extends Throwable> T accept(IValueVisitor<T, E> v) throws E {
        return v.visitConstructor(this);
    }

    @Override
    public IValue get(int i) {
        return this.content.get(i);
    }

    @Override
    public IConstructor set(int i, IValue newChild) {
        IConstructor newContent = this.content.set(i, newChild);
        return new ConstructorWithKeywordParametersFacade(newContent, this.parameters);
    }

    @Override
    public int arity() {
        return this.content.arity();
    }

    @Override
    public String toString() {
        return StandardTextWriter.valueToString(this);
    }

    @Override
    public String getName() {
        return this.content.getName();
    }

    @Override
    public Iterable<IValue> getChildren() {
        return this.content.getChildren();
    }

    @Override
    public Iterator<IValue> iterator() {
        return this.content.iterator();
    }

    @Override
    public IConstructor replace(int first, int second, int end, IList repl) {
        throw new UnsupportedOperationException("Replace not supported on constructor.");
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            ConstructorWithKeywordParametersFacade other = (ConstructorWithKeywordParametersFacade)o;
            return this.content.equals(other.content) && this.parameters.equals(other.parameters);
        }
        return false;
    }

    @Override
    public boolean match(IValue other) {
        if (other instanceof ConstructorWithKeywordParametersFacade) {
            return this.content.match(((ConstructorWithKeywordParametersFacade)other).content);
        }
        if (other instanceof IConstructor) {
            return IConstructor.super.match(other);
        }
        return false;
    }

    public int hashCode() {
        return 131 + 3 * this.content.hashCode() + 101 * this.parameters.hashCode();
    }

    @Override
    public boolean mayHaveKeywordParameters() {
        return true;
    }

    @Override
    public IWithKeywordParameters<? extends IConstructor> asWithKeywordParameters() {
        return new AbstractDefaultWithKeywordParameters<IConstructor>(this.content, this.parameters){

            @Override
            protected IConstructor wrap(IConstructor content, Map.Immutable<String, IValue> parameters) {
                return new ConstructorWithKeywordParametersFacade(content, parameters);
            }

            @Override
            public boolean hasParameters() {
                return this.parameters != null && this.parameters.size() > 0;
            }

            @Override
            public Set<String> getParameterNames() {
                return Collections.unmodifiableSet(this.parameters.keySet());
            }

            @Override
            @Pure
            public Map<String, IValue> getParameters() {
                return Collections.unmodifiableMap(this.parameters);
            }
        };
    }

    @Override
    public Type getConstructorType() {
        return this.content.getConstructorType();
    }

    @Override
    public Type getUninstantiatedConstructorType() {
        return this.content.getUninstantiatedConstructorType();
    }

    @Override
    public IValue get(String label) {
        return this.content.get(label);
    }

    @Override
    public IConstructor set(String label, IValue newChild) {
        return new ConstructorWithKeywordParametersFacade(this.content.set(label, newChild), this.parameters);
    }

    @Override
    public boolean has(String label) {
        return this.content.has(label);
    }

    @Override
    public Type getChildrenTypes() {
        return this.content.getChildrenTypes();
    }
}

