/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.dap;

import engineering.swat.watch.DaemonThreadPool;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.lsp4j.debug.TerminatedEventArguments;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.rascalmpl.dap.RascalDebugAdapter;
import org.rascalmpl.dap.RascalDebugAdapterLauncher;
import org.rascalmpl.ideservices.IDEServices;
import org.rascalmpl.interpreter.Evaluator;

public class DebugSocketServer {
    private final IDEServices services;
    private final ServerSocket serverSocket;
    private volatile @Nullable Socket clientSocket;
    private volatile @Nullable IDebugProtocolClient debugClient;
    private volatile @Nullable ExecutorService threadPool;

    public DebugSocketServer(Evaluator evaluator, IDEServices services) {
        this.services = services;
        try {
            this.serverSocket = new ServerSocket(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.registerDebugServerPort(services);
        this.startListening(evaluator);
    }

    private void startListening(Evaluator evaluator) {
        Thread t2 = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        Socket newClient = this.serverSocket.accept();
                        if (this.clientSocket == null || this.clientSocket.isClosed()) {
                            this.clientSocket = newClient;
                            this.threadPool = DaemonThreadPool.buildConstrainedCached("rascal-debug", Math.max(2, Math.min(6, Runtime.getRuntime().availableProcessors() - 2)));
                            this.debugClient = RascalDebugAdapterLauncher.start(evaluator, this.clientSocket, this, this.services, this.threadPool);
                            continue;
                        }
                        newClient.close();
                    }
                }
                catch (IOException e) {
                    this.services.warning(e.getMessage(), RascalDebugAdapter.DEBUGGER_LOC);
                    continue;
                }
                break;
            }
        });
        t2.setDaemon(true);
        t2.start();
    }

    private void registerDebugServerPort(IDEServices services) {
        services.registerDebugServerPort((int)ProcessHandle.current().pid(), this.getPort());
    }

    public boolean isClientConnected() {
        Socket socket = this.clientSocket;
        return socket != null && !socket.isClosed();
    }

    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    public void terminateDebugSession() {
        IDebugProtocolClient client = this.debugClient;
        if (client != null) {
            TerminatedEventArguments args = new TerminatedEventArguments();
            args.setRestart(false);
            client.terminated(args);
            this.debugClient = null;
        }
    }

    public void closeClientSocket() {
        try {
            Socket socket = this.clientSocket;
            if (socket != null && !socket.isClosed()) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    this.services.warning("Error closing client socket", RascalDebugAdapter.DEBUGGER_LOC);
                }
            }
            this.threadPool.shutdownNow();
        }
        finally {
            this.clientSocket = null;
            this.debugClient = null;
            this.threadPool = null;
        }
    }
}

