/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.dap;

import io.usethesource.vallang.ISourceLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.rascalmpl.dap.variable.RascalVariable;
import org.rascalmpl.dap.variable.VariableSubElementsCounter;
import org.rascalmpl.dap.variable.VariableSubElementsCounterVisitor;
import org.rascalmpl.dap.variable.VariableSubfieldsVisitor;
import org.rascalmpl.debug.IRascalFrame;
import org.rascalmpl.ideservices.IDEServices;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.result.IRascalResult;
import org.rascalmpl.uri.URIUtil;

public class SuspendedState {
    private final Evaluator evaluator;
    private final IDEServices services;
    private volatile IRascalFrame[] currentStackFrames;
    private final Map<Integer, RascalVariable> variables;
    private final Map<Integer, IRascalFrame> scopes;
    private volatile int referenceIDCounter;
    private volatile boolean isSuspended;

    public SuspendedState(Evaluator evaluator, IDEServices services) {
        this.evaluator = evaluator;
        this.services = services;
        this.variables = new ConcurrentHashMap<Integer, RascalVariable>();
        this.scopes = new ConcurrentHashMap<Integer, IRascalFrame>();
    }

    public void suspended() {
        this.currentStackFrames = (IRascalFrame[])this.evaluator.getCurrentStack().toArray(IRascalFrame[]::new);
        this.referenceIDCounter = 0;
        this.variables.clear();
        this.scopes.clear();
        this.isSuspended = true;
    }

    public ISourceLocation getCurrentLocation() {
        return this.evaluator.getCurrentPointOfExecution() != null ? this.evaluator.getCurrentPointOfExecution() : URIUtil.rootLocation("stdin");
    }

    public void resumed() {
        this.isSuspended = false;
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public IRascalFrame[] getCurrentStackFrames() {
        return this.currentStackFrames;
    }

    public IRascalFrame getCurrentStackFrame() {
        IRascalFrame[] stackCopy = this.currentStackFrames;
        return stackCopy[stackCopy.length - 1];
    }

    public int addScope(IRascalFrame frame) {
        int nextReferenceId = ++this.referenceIDCounter;
        this.scopes.put(nextReferenceId, frame);
        return nextReferenceId;
    }

    public List<RascalVariable> getVariables(int referenceID, int startIndex, int maxCount) {
        if (referenceID < 0) {
            return Collections.emptyList();
        }
        ArrayList<RascalVariable> variableList = new ArrayList<RascalVariable>();
        if (this.scopes.containsKey(referenceID)) {
            IRascalFrame frame = this.scopes.get(referenceID);
            ArrayList<String> frameVariables = new ArrayList<String>(frame.getFrameVariables());
            frameVariables.sort(String::compareTo);
            int endIndex = maxCount == -1 ? frameVariables.size() : Math.min(frameVariables.size(), startIndex + maxCount);
            for (String varname : frameVariables.subList(startIndex, endIndex)) {
                IRascalResult result = frame.getFrameVariable(varname);
                RascalVariable refResult = new RascalVariable(result.getDynamicType(), varname, result.getValue(), this.services);
                if (refResult.hasSubFields()) {
                    this.addVariable(refResult);
                    VariableSubElementsCounter counter = result.getValue().accept(new VariableSubElementsCounterVisitor());
                    refResult.setIndexedVariables(counter.getIndexedVariables());
                    refResult.setNamedVariables(counter.getNamedVariables());
                }
                variableList.add(refResult);
            }
            return variableList;
        }
        if (!this.variables.containsKey(referenceID)) {
            return variableList;
        }
        RascalVariable var = this.variables.get(referenceID);
        return var.getValue().accept(new VariableSubfieldsVisitor(this, var.getType(), startIndex, maxCount, this.services));
    }

    public void addVariable(RascalVariable variable) {
        int nextReferenceID = ++this.referenceIDCounter;
        variable.setReferenceID(nextReferenceID);
        this.variables.put(nextReferenceID, variable);
    }
}

