/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.load;

import io.usethesource.vallang.ISourceLocation;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.rascalmpl.interpreter.load.IRascalSearchPathContributor;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;

public class RascalSearchPath {
    private final ArrayList<IRascalSearchPathContributor> contributors = new ArrayList();
    private final URIResolverRegistry reg = URIResolverRegistry.getInstance();

    public void addPathContributor(IRascalSearchPathContributor contrib) {
        if (!this.contributors.contains(contrib)) {
            this.contributors.add(0, contrib);
        }
    }

    public ISourceLocation resolveModule(String module) {
        module = this.moduleToFile(module);
        try {
            for (ISourceLocation dir : this.collect()) {
                ISourceLocation full = this.getFullURI(module, dir);
                if (!this.reg.exists(full)) continue;
                return full;
            }
            return null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private String moduleToDir(String module) {
        return module.replaceAll("::", "/");
    }

    private String moduleToFile(String module) {
        if (!module.endsWith(".rsc")) {
            module = module.concat(".rsc");
        }
        return module.replaceAll("::", "/");
    }

    public ISourceLocation resolvePath(String path) {
        try {
            for (ISourceLocation dir : this.collect()) {
                ISourceLocation full = this.getFullURI(path, dir);
                if (!this.reg.exists(full)) continue;
                return full;
            }
            return null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public ISourceLocation getRootForModule(String module) {
        try {
            for (ISourceLocation dir : this.collect()) {
                ISourceLocation full = this.getFullURI(this.moduleToFile(module), dir);
                if (!this.reg.exists(full)) continue;
                return dir;
            }
            return null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public List<ISourceLocation> collect() {
        LinkedList<ISourceLocation> paths = new LinkedList<ISourceLocation>();
        for (IRascalSearchPathContributor c : this.contributors) {
            c.contributePaths(paths);
        }
        return paths;
    }

    public List<String> listModuleEntries(String moduleRoot) {
        assert (!moduleRoot.endsWith("::"));
        try {
            String modulePath = this.moduleToDir(moduleRoot);
            ArrayList<String> result = new ArrayList<String>();
            for (ISourceLocation dir : this.collect()) {
                ISourceLocation full = this.getFullURI(modulePath, dir);
                if (!this.reg.exists(full)) continue;
                try {
                    String[] entries = this.reg.listEntries(full);
                    if (entries == null) continue;
                    for (String module : entries) {
                        if (module.endsWith(".rsc")) {
                            result.add(module.substring(0, module.length() - ".rsc".length()));
                            continue;
                        }
                        if (module.indexOf(46) != -1 || !this.reg.isDirectory(this.getFullURI(module, full))) continue;
                        result.add(module + "::");
                    }
                }
                catch (IOException iOException) {
                }
            }
            return result;
        }
        catch (URISyntaxException e) {
            return Collections.emptyList();
        }
    }

    private ISourceLocation getFullURI(String path, ISourceLocation dir) throws URISyntaxException {
        return URIUtil.getChildLocation(dir, path);
    }

    public URIResolverRegistry getRegistry() {
        return this.reg;
    }

    public void remove(IRascalSearchPathContributor contrib) {
        this.contributors.remove(contrib);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("RascalSearchPath[ ");
        for (IRascalSearchPathContributor contrib : this.contributors) {
            sb.append(contrib.getName()).append(" ");
        }
        sb.append("])");
        return sb.toString();
    }
}

