/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.exceptions.UndeclaredAbstractDataTypeException;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeStore;
import java.util.Map;
import java.util.Set;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.KeywordFormal;
import org.rascalmpl.ast.Name;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.env.ModuleEnvironment;
import org.rascalmpl.interpreter.result.ConstructorFunction;
import org.rascalmpl.interpreter.result.NodeResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.UndeclaredField;
import org.rascalmpl.interpreter.staticErrors.UndeclaredKeywordParameter;
import org.rascalmpl.interpreter.staticErrors.UndeclaredType;
import org.rascalmpl.interpreter.staticErrors.UnexpectedKeywordArgumentType;
import org.rascalmpl.interpreter.staticErrors.UnexpectedType;
import org.rascalmpl.interpreter.staticErrors.UnsupportedOperation;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.RascalValueFactory;

public class ConstructorResult
extends NodeResult {
    public ConstructorResult(Type type, IConstructor cons, IEvaluatorContext ctx) {
        super(type, cons, ctx);
    }

    @Override
    public IConstructor getValue() {
        return (IConstructor)super.getValue();
    }

    @Override
    public Result<IBool> is(Name name) {
        return ResultFactory.bool(this.getValue().getName().equals(Names.name(name)), this.ctx);
    }

    @Override
    public Result<IBool> has(Name name) {
        String sname = Names.name(name);
        return ResultFactory.bool(this.getValue().has(sname) || this.ctx.getCurrentEnvt().getStore().getKeywordParameterType(this.getValue().getConstructorType(), sname) != null, this.ctx);
    }

    @Override
    public Result<IBool> isDefined(Name name) {
        try {
            String sname = Names.name(name);
            return ResultFactory.bool(this.getValue().has(sname) || this.getValue().asWithKeywordParameters().hasParameter(sname), this.ctx);
        }
        catch (Throw e) {
            return ResultFactory.bool(false, this.ctx);
        }
    }

    @Override
    public Result<IValue> call(Type[] argTypes, IValue[] argValues, Map<String, IValue> keyArgValues) {
        throw new UnsupportedOperation("Can not call a constructed " + this.getStaticType() + " node as a function", this.ctx.getCurrentAST());
    }

    @Override
    public <U extends IValue> Result<U> fieldAccess(String name, TypeStore store) {
        Type consType = this.getValue().getConstructorType();
        try {
            if (this.getStaticType().hasField(name, store)) {
                return this.positionalFieldAccess(consType, name);
            }
            if (this.getValue().getUninstantiatedConstructorType().hasKeywordField(name, store)) {
                return this.keywordFieldAccess(consType, name, store);
            }
            for (Type alt : store.lookupAlternatives(this.getValue().getUninstantiatedConstructorType().getAbstractDataType())) {
                if (!store.hasKeywordParameter(alt, name)) continue;
                throw RuntimeExceptionFactory.noSuchField(name, this.ctx.getCurrentAST(), null);
            }
            throw new UndeclaredField(name, this.getStaticType(), this.ctx.getCurrentAST());
        }
        catch (UndeclaredAbstractDataTypeException e) {
            throw new UndeclaredType(this.getStaticType().getName(), this.ctx.getCurrentAST());
        }
    }

    public <U extends IValue> Result<U> positionalFieldAccess(Type consType, String name) {
        if (consType.hasField(name)) {
            int index = consType.getFieldIndex(name);
            return ResultFactory.makeResult(consType.getFieldType(index), this.getValue().get(index), this.ctx);
        }
        throw RuntimeExceptionFactory.noSuchField(name, this.ctx.getCurrentAST(), null);
    }

    public <U extends IValue> Result<U> keywordFieldAccess(Type consType, String name, TypeStore store) {
        try {
            if (this.getValue().mayHaveKeywordParameters()) {
                Type kwType = store.getKeywordParameterType(this.getValue().getUninstantiatedConstructorType(), name);
                if (kwType == null) {
                    throw new UndeclaredKeywordParameter(this.getValue().getUninstantiatedConstructorType().getName(), name, this.ctx.getCurrentAST());
                }
                Object parameter = this.getValue().asWithKeywordParameters().getParameter(name);
                if (parameter == null) {
                    ConstructorFunction cons = this.ctx.getCurrentEnvt().getConstructorFunction(consType);
                    if (cons != null) {
                        return cons.computeDefaultKeywordParameter(name, this.getValue(), this.ctx.getCurrentEnvt());
                    }
                    return this.computeGenericDefaultKeywordParameter(name);
                }
                return ResultFactory.makeResult(kwType, parameter, this.ctx);
            }
            throw new UndeclaredField(name, this.getStaticType(), this.ctx.getCurrentAST());
        }
        catch (UndeclaredAbstractDataTypeException e) {
            throw new UndeclaredType(this.getStaticType().toString(), this.ctx.getCurrentAST());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result<IValue> computeGenericDefaultKeywordParameter(String label) {
        Set<ModuleEnvironment.GenericKeywordParameters> kwps = this.ctx.getCurrentEnvt().lookupGenericKeywordParameters(this.getStaticType());
        IWithKeywordParameters<? extends IConstructor> wkw = this.getValue().asWithKeywordParameters();
        Environment old = this.ctx.getCurrentEnvt();
        for (ModuleEnvironment.GenericKeywordParameters gkw : kwps) {
            Environment env = new Environment(gkw.getEnv(), URIUtil.rootLocation("initializer"), "kwp initializer");
            try {
                this.ctx.setCurrentEnvt(env);
                for (KeywordFormal kwparam : gkw.getFormals()) {
                    Result<IValue> kwResult;
                    String name = Names.name(kwparam.getName());
                    Type kwType = gkw.getTypes().get(name);
                    if (kwType == null) continue;
                    if (wkw.hasParameter(name)) {
                        Object r = wkw.getParameter(name);
                        if (!r.getType().isSubtypeOf(kwType)) {
                            throw new UnexpectedKeywordArgumentType(name, kwType, r.getType(), this.ctx.getCurrentAST());
                        }
                        kwResult = ResultFactory.makeResult(kwType, r, this.ctx);
                    } else {
                        Expression def = kwparam.getExpression();
                        kwResult = def.interpret(this.ctx.getEvaluator());
                    }
                    if (name.equals(label)) {
                        Result<IValue> result = kwResult;
                        return result;
                    }
                    env.declareVariable(kwResult.getStaticType(), name);
                    env.storeVariable(name, kwResult);
                }
            }
            finally {
                this.ctx.setCurrentEnvt(old);
            }
        }
        throw new UndeclaredField(label, this.getStaticType(), this.ctx.getCurrentAST());
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> fieldUpdate(String name, Result<V> repl, TypeStore store) {
        ConstructorFunction cons = this.ctx.getCurrentEnvt().getConstructorFunction(this.getValue().getConstructorType());
        Type kwTypes = cons.getKeywordArgumentTypes(this.ctx.getCurrentEnvt());
        if (!this.getStaticType().hasField(name, store) && store.hasKeywordParameter(this.getStaticType(), name)) {
            throw new UndeclaredField(name, this.getStaticType(), this.ctx.getCurrentAST());
        }
        Type nodeType = this.getValue().getConstructorType();
        if (!nodeType.hasField(name) && !kwTypes.hasField(name)) {
            throw RuntimeExceptionFactory.noSuchField(name, this.ctx.getCurrentAST(), null);
        }
        if (kwTypes.hasField(name)) {
            Type fieldType = kwTypes.getFieldType(name);
            if (!repl.getStaticType().isSubtypeOf(fieldType)) {
                throw new UnexpectedType(fieldType, repl.getStaticType(), this.ctx.getCurrentAST());
            }
            return ResultFactory.makeResult(this.getStaticType(), this.getValue().asWithKeywordParameters().setParameter(name, (IValue)repl.getValue()), this.ctx);
        }
        int index = nodeType.getFieldIndex(name);
        Type fieldType = nodeType.getFieldType(index);
        if (!repl.getStaticType().isSubtypeOf(fieldType)) {
            throw new UnexpectedType(fieldType, repl.getStaticType(), this.ctx.getCurrentAST());
        }
        return ResultFactory.makeResult(this.getStaticType(), this.getValue().set(index, (IValue)repl.getValue()), this.ctx);
    }

    @Override
    public <U extends IValue> Result<U> getAnnotation(String annoName, Environment env) {
        if (this.getValue().getType().isSubtypeOf(RascalValueFactory.Tree) && "loc".equals(annoName)) {
            annoName = "src";
        }
        try {
            return this.keywordFieldAccess(this.getValue().getConstructorType(), annoName, env.getStore());
        }
        catch (UndeclaredField e) {
            throw RuntimeExceptionFactory.noSuchAnnotation(annoName, this.ctx.getCurrentAST(), this.ctx.getStackTrace());
        }
    }
}

