/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.util.Map;
import org.rascalmpl.ast.Name;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.result.ElementResult;
import org.rascalmpl.interpreter.result.IntegerResult;
import org.rascalmpl.interpreter.result.LessThanOrEqualResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.UnexpectedType;
import org.rascalmpl.interpreter.staticErrors.UnsupportedSubscriptArity;
import org.rascalmpl.interpreter.utils.Names;

public class NodeResult
extends ElementResult<INode> {
    public NodeResult(Type type, INode node, IEvaluatorContext ctx) {
        super(type, node, ctx);
    }

    @Override
    public Result<IBool> isKeyDefined(Result<?>[] subscripts) {
        if (subscripts.length != 1) {
            throw new UnsupportedSubscriptArity(this.getStaticType(), subscripts.length, this.ctx.getCurrentAST());
        }
        Result<?> key = subscripts[0];
        if (!key.getStaticType().isSubtypeOf(this.getTypeFactory().integerType())) {
            throw new UnexpectedType(this.getTypeFactory().integerType(), key.getStaticType(), this.ctx.getCurrentAST());
        }
        int idx = ((IInteger)key.getValue()).intValue();
        int len = ((INode)this.getValue()).arity();
        if (idx >= 0 && idx >= len || idx < 0 && idx < -len) {
            return ResultFactory.makeResult(this.getTypeFactory().boolType(), this.getValueFactory().bool(false), this.ctx);
        }
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), this.getValueFactory().bool(true), this.ctx);
    }

    @Override
    public <U extends IValue> Result<U> fieldAccess(String name, TypeStore store) {
        Object parameter;
        if (this.value instanceof IConstructor) {
            Object parameter2;
            Type consType = ((IConstructor)this.value).getConstructorType();
            if (consType.hasField(name, store)) {
                int index = consType.getFieldIndex(name);
                return ResultFactory.makeResult(consType.getFieldType(index), ((INode)this.getValue()).get(index), this.ctx);
            }
            if (((INode)this.value).mayHaveKeywordParameters() && (parameter2 = ((INode)this.value).asWithKeywordParameters().getParameter(name)) != null) {
                return ResultFactory.makeResult(this.getTypeFactory().valueType(), parameter2, this.ctx);
            }
        }
        if (((INode)this.value).mayHaveKeywordParameters() && (parameter = ((INode)this.value).asWithKeywordParameters().getParameter(name)) != null) {
            return ResultFactory.makeResult(this.getTypeFactory().valueType(), parameter, this.ctx);
        }
        throw RuntimeExceptionFactory.noSuchField(name, this.ctx.getCurrentAST(), this.ctx.getStackTrace());
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> fieldUpdate(String name, Result<V> repl, TypeStore store) {
        if (((INode)this.value).mayHaveKeywordParameters()) {
            return ResultFactory.makeResult(this.type, ((INode)this.value).asWithKeywordParameters().setParameter(name, (IValue)repl.getValue()), this.ctx);
        }
        return ResultFactory.makeResult(this.type, this.value, this.ctx);
    }

    @Override
    public <V extends IValue> Result<IBool> equals(Result<V> that) {
        return that.equalToNode(this);
    }

    @Override
    public <V extends IValue> Result<IBool> nonEquals(Result<V> that) {
        return that.nonEqualToNode(this);
    }

    @Override
    public <V extends IValue> LessThanOrEqualResult lessThanOrEqual(Result<V> result) {
        return result.lessThanOrEqualNode(this);
    }

    @Override
    public Result<IBool> is(Name name) {
        return ResultFactory.bool(((INode)this.getValue()).getName().equals(Names.name(name)), this.ctx);
    }

    @Override
    public Result<IBool> has(Name name) {
        return this.isDefined(name);
    }

    @Override
    public Result<IBool> isDefined(Name name) {
        String sname = Names.name(name);
        if (this.value instanceof IConstructor && ((IConstructor)this.value).has(sname)) {
            return ResultFactory.bool(true, this.ctx);
        }
        return ResultFactory.bool(((INode)this.getValue()).asWithKeywordParameters().hasParameter(sname), this.ctx);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> subscript(Result<?>[] subscripts) {
        if (subscripts.length != 1) {
            throw new UnsupportedSubscriptArity(this.getStaticType(), subscripts.length, this.ctx.getCurrentAST());
        }
        if (!subscripts[0].getStaticType().isInteger()) {
            throw new UnexpectedType(this.getTypeFactory().integerType(), subscripts[0].getStaticType(), this.ctx.getCurrentAST());
        }
        IInteger index = (IInteger)((IntegerResult)subscripts[0]).getValue();
        int idx = index.intValue();
        if (idx < 0) {
            idx += ((INode)this.getValue()).arity();
        }
        if (idx >= ((INode)this.getValue()).arity() || idx < 0) {
            throw RuntimeExceptionFactory.indexOutOfBounds(index, this.ctx.getCurrentAST(), this.ctx.getStackTrace());
        }
        Type elementType = this.getTypeFactory().valueType();
        return ResultFactory.makeResult(elementType, ((INode)this.getValue()).get(idx), this.ctx);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> slice(Result<?> first, Result<?> second, Result<?> end) {
        return super.slice(first, second, end, ((INode)this.getValue()).arity());
    }

    @Override
    public Result<IValue> makeSlice(int first, int second, int end) {
        IListWriter w = this.getValueFactory().listWriter();
        int increment = second - first;
        if (first != end && increment != 0) {
            if (first <= end) {
                for (int i = first; i >= 0 && i < end; i += increment) {
                    w.append(((INode)this.getValue()).get(i));
                }
            } else {
                for (int j = first; j >= 0 && j > end && j < ((INode)this.getValue()).arity(); j += increment) {
                    w.append(((INode)this.getValue()).get(j));
                }
            }
        }
        TypeFactory tf = TypeFactory.getInstance();
        return ResultFactory.makeResult(tf.listType(tf.valueType()), w.done(), this.ctx);
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualNode(NodeResult that) {
        int rightArity;
        INode left = (INode)that.getValue();
        INode right = (INode)this.getValue();
        int compare = left.getName().compareTo(right.getName());
        if (compare <= -1) {
            return new LessThanOrEqualResult(true, false, this.ctx);
        }
        if (compare >= 1) {
            return new LessThanOrEqualResult(false, false, this.ctx);
        }
        int leftArity = left.arity();
        if (leftArity < (rightArity = right.arity())) {
            return new LessThanOrEqualResult(true, false, this.ctx);
        }
        if (leftArity > rightArity) {
            return new LessThanOrEqualResult(false, false, this.ctx);
        }
        for (int i = 0; i < Math.min(leftArity, rightArity); ++i) {
            IValue leftArg = left.get(i);
            IValue rightArg = right.get(i);
            LessThanOrEqualResult loe = ResultFactory.makeResult(leftArg.getType(), leftArg, this.ctx).lessThanOrEqual(ResultFactory.makeResult(rightArg.getType(), rightArg, this.ctx));
            if (loe.getLess() && !loe.getEqual()) {
                return new LessThanOrEqualResult(true, false, this.ctx);
            }
            if (loe.getEqual()) continue;
            return new LessThanOrEqualResult(false, false, this.ctx);
        }
        if ((!left.mayHaveKeywordParameters() || !left.asWithKeywordParameters().hasParameters()) && right.mayHaveKeywordParameters() && right.asWithKeywordParameters().hasParameters()) {
            return new LessThanOrEqualResult(true, false, this.ctx);
        }
        if (left.mayHaveKeywordParameters() && left.asWithKeywordParameters().hasParameters() && (!right.mayHaveKeywordParameters() || !right.asWithKeywordParameters().hasParameters())) {
            return new LessThanOrEqualResult(false, false, this.ctx);
        }
        if (left.mayHaveKeywordParameters() && right.mayHaveKeywordParameters() && left.asWithKeywordParameters().hasParameters() && right.asWithKeywordParameters().hasParameters()) {
            Map<String, IValue> paramsLeft = left.asWithKeywordParameters().getParameters();
            Map<String, IValue> paramsRight = right.asWithKeywordParameters().getParameters();
            if (paramsLeft.size() < paramsRight.size()) {
                return new LessThanOrEqualResult(true, false, this.ctx);
            }
            if (paramsLeft.size() > paramsRight.size()) {
                return new LessThanOrEqualResult(false, false, this.ctx);
            }
            if (paramsRight.keySet().containsAll(paramsLeft.keySet()) && !paramsRight.keySet().equals(paramsLeft.keySet())) {
                return new LessThanOrEqualResult(true, false, this.ctx);
            }
            if (paramsLeft.keySet().containsAll(paramsLeft.keySet()) && !paramsRight.keySet().equals(paramsLeft.keySet())) {
                return new LessThanOrEqualResult(false, false, this.ctx);
            }
            for (String k : paramsLeft.keySet()) {
                IValue paramLeft = paramsLeft.get(k);
                IValue paramRight = paramsRight.get(k);
                LessThanOrEqualResult loe = ResultFactory.makeResult(paramLeft.getType(), paramLeft, this.ctx).lessThanOrEqual(ResultFactory.makeResult(paramRight.getType(), paramRight, this.ctx));
                if (loe.getLess() && !loe.getEqual()) {
                    return new LessThanOrEqualResult(true, false, this.ctx);
                }
                if (loe.getEqual()) continue;
                return new LessThanOrEqualResult(false, false, this.ctx);
            }
        }
        return new LessThanOrEqualResult(false, true, this.ctx);
    }

    @Override
    protected Result<IBool> equalToNode(NodeResult that) {
        return that.equalityBoolean(this);
    }

    @Override
    protected Result<IBool> nonEqualToNode(NodeResult that) {
        return that.nonEqualityBoolean(this);
    }

    @Override
    public <U extends IValue> Result<U> getAnnotation(String annoName, Environment env) {
        return this.fieldAccess(annoName, env.getStore());
    }
}

