/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.utils;

import io.usethesource.vallang.ISourceLocation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.jar.JarURIResolver;

public class RascalManifest {
    public static final String DEFAULT_MAIN_MODULE = "Plugin";
    public static final String DEFAULT_MAIN_FUNCTION = "main";
    public static final String DEFAULT_SRC = "src";
    protected static final String SOURCE = "Source";
    protected static final String META_INF = "META-INF";
    public static final String META_INF_RASCAL_MF = "META-INF/RASCAL.MF";
    public static final String META_INF_MANIFEST_MF = "META-INF/MANIFEST.MF";
    protected static final String MAIN_MODULE = "Main-Module";
    protected static final String MAIN_FUNCTION = "Main-Function";
    protected static final String PROJECT_NAME = "Project-Name";

    public static String getRascalVersionNumber() {
        try {
            Enumeration<URL> resources = RascalManifest.class.getClassLoader().getResources(META_INF_MANIFEST_MF);
            while (resources.hasMoreElements()) {
                String result;
                Manifest manifest = new Manifest(resources.nextElement().openStream());
                String bundleName = manifest.getMainAttributes().getValue("Name");
                if (bundleName == null || !bundleName.equals("rascal") || (result = manifest.getMainAttributes().getValue("Specification-Version")) == null) continue;
                return result;
            }
            return "Not specified";
        }
        catch (IOException e) {
            return "unknown (due to " + e.getMessage();
        }
    }

    public String getManifestVersionNumber(ISourceLocation project) throws IOException {
        String result;
        Manifest mf = new Manifest(this.javaManifest(project));
        String bundleName = mf.getMainAttributes().getValue("Name");
        if (bundleName != null && bundleName.equals("rascal") && (result = mf.getMainAttributes().getValue("Specification-Version")) != null) {
            return result;
        }
        return "unknown";
    }

    public Manifest getDefaultManifest(String projectName) {
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.put(Attributes.Name.MANIFEST_VERSION, "0.0.1");
        mainAttributes.put(new Attributes.Name(SOURCE), DEFAULT_SRC);
        mainAttributes.put(new Attributes.Name(MAIN_MODULE), DEFAULT_MAIN_MODULE);
        mainAttributes.put(new Attributes.Name(MAIN_FUNCTION), DEFAULT_MAIN_FUNCTION);
        mainAttributes.put(new Attributes.Name(PROJECT_NAME), projectName);
        return manifest;
    }

    public boolean hasManifest(ISourceLocation root) {
        return this.hasManifest(this.manifest(root));
    }

    public boolean hasManifest(Class<?> clazz) {
        return this.hasManifest(this.manifest(clazz));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasManifest(InputStream is) {
        try {
            boolean bl = is != null;
            return bl;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public List<String> getSourceRoots(Class<?> clazz) {
        return this.getManifestSourceRoots(this.manifest(clazz));
    }

    public List<String> getSourceRoots(JarInputStream jarStream) {
        return this.getManifestSourceRoots(this.manifest(jarStream));
    }

    public String getMainFunction(Class<?> clazz) {
        return this.getManifestMainFunction(this.manifest(clazz));
    }

    public String getMainFunction(JarInputStream jarStream) {
        return this.getManifestMainFunction(this.manifest(jarStream));
    }

    public String getProjectName(Class<?> clazz) {
        return this.getManifestProjectName(this.manifest(clazz));
    }

    public String getManifestProjectName(InputStream manifest) {
        return this.getManifestAttribute(manifest, PROJECT_NAME, "");
    }

    public String getMainFunction(File jarFile) {
        return this.getManifestMainFunction(this.manifest(jarFile));
    }

    public String getProjectName(File jarFile) {
        return this.getManifestProjectName(this.manifest(jarFile));
    }

    public String getMainModule(JarInputStream jarStream) {
        return this.getManifestMainModule(this.manifest(jarStream));
    }

    public String getProjectName(JarInputStream jarStream) {
        return this.getManifestProjectName(this.manifest(jarStream));
    }

    public String getProjectName(InputStream in) {
        return this.getManifestProjectName(in);
    }

    public String getMainModule(File jarFile) {
        return this.getManifestMainModule(this.manifest(jarFile));
    }

    public String getMainModule(Class<?> clazz) {
        return this.getManifestMainModule(this.manifest(clazz));
    }

    public boolean hasMainModule(Class<?> clazz) {
        return this.getManifestMainModule(this.manifest(clazz)) != null;
    }

    public List<String> getManifestSourceRoots(InputStream manifestFile) {
        return this.getManifestAttributeList(manifestFile, SOURCE, DEFAULT_SRC);
    }

    public List<String> getSourceRoots(File file) {
        return this.getManifestSourceRoots(this.manifest(file));
    }

    public String getManifestMainModule(InputStream project) {
        return this.getManifestAttribute(project, MAIN_MODULE, null);
    }

    public String getManifestMainFunction(InputStream project) {
        return this.getManifestAttribute(project, MAIN_FUNCTION, null);
    }

    public InputStream manifest(Class<?> clazz) {
        return clazz.getResourceAsStream("/META-INF/RASCAL.MF");
    }

    public InputStream manifest(ISourceLocation root) {
        try {
            return URIResolverRegistry.getInstance().getInputStream(URIUtil.getChildLocation(JarURIResolver.jarify(root), META_INF_RASCAL_MF));
        }
        catch (IOException e) {
            return null;
        }
    }

    public InputStream javaManifest(ISourceLocation root) {
        try {
            return URIResolverRegistry.getInstance().getInputStream(URIUtil.getChildLocation(JarURIResolver.jarify(root), META_INF_MANIFEST_MF));
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getProjectName(ISourceLocation root) {
        return this.getManifestProjectName(this.manifest(root));
    }

    public List<String> getSourceRoots(ISourceLocation root) {
        return this.getManifestSourceRoots(this.manifest(root));
    }

    public InputStream manifest(JarInputStream stream) {
        JarEntry next = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            while ((next = stream.getNextJarEntry()) != null) {
                int len;
                if (!next.getName().equals(META_INF_RASCAL_MF)) continue;
                byte[] buf = new byte[1024];
                while ((len = stream.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                return new ByteArrayInputStream(out.toByteArray());
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    public InputStream manifest(File jarFile) {
        InputStream inputStream;
        JarFile file = new JarFile(jarFile);
        try {
            inputStream = file.getInputStream(new ZipEntry(META_INF_RASCAL_MF));
        }
        catch (Throwable throwable) {
            try {
                try {
                    file.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        file.close();
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getManifestAttributeList(InputStream mf, String label, String def) {
        if (mf != null) {
            try {
                Manifest manifest = new Manifest(mf);
                String source = manifest.getMainAttributes().getValue(label);
                if (source != null && !source.trim().isEmpty()) {
                    List<String> list = Arrays.asList(RascalManifest.trim(source.split(",")));
                    return list;
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    mf.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (def == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getManifestAttribute(InputStream is, String label, String def) {
        if (is != null) {
            try {
                Manifest manifest = new Manifest(is);
                String result = manifest.getMainAttributes().getValue(label);
                if (result != null) {
                    String string = result.trim();
                    return string;
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return def;
    }

    private static String[] trim(String[] elems) {
        for (int i = 0; i < elems.length; ++i) {
            elems[i] = elems[i].trim();
        }
        return elems;
    }
}

