/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.util;

import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class ObjectReader {
    private static final IValue[] EMPTY = new IValue[0];
    private final IValueFactory vf;

    public ObjectReader(IValueFactory vf) {
        this.vf = vf;
    }

    private Map<String, IValue> getFields(Object o, Class<?> clazz, Set<Class<?>> includes, Map<Object, IValue> cache, Stack<Object> stack) {
        HashMap<String, IValue> results = new HashMap<String, IValue>();
        while (clazz != Object.class) {
            Field[] fields;
            for (Field f : fields = clazz.getDeclaredFields()) {
                try {
                    f.setAccessible(true);
                    IValue res = this.readObject(f.get(o), includes, cache, stack);
                    if (res == null) continue;
                    results.put(f.getName(), res);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    return null;
                }
            }
            clazz = clazz.getSuperclass();
        }
        return results;
    }

    public IValue readObject(Object o, Set<String> types, ClassLoader loader) {
        HashSet included = new HashSet();
        for (String name : types) {
            try {
                included.add(loader.loadClass(name));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return this.readObject(o, included, new HashMap<Object, IValue>(), new Stack<Object>());
    }

    private IValue readObject(Object o, Set<Class<?>> includes, Map<Object, IValue> cache, Stack<Object> stack) {
        if (o == null) {
            return null;
        }
        IValue result = cache.get(o);
        if (result != null) {
            return result;
        }
        if (stack.contains(o)) {
            return null;
        }
        stack.push(o);
        Class<?> clazz = o.getClass();
        if (clazz.isArray()) {
            result = this.readArray((Object[])o, includes, cache, stack);
        } else if (clazz == URI.class) {
            result = this.vf.sourceLocation((URI)o);
        } else if (clazz == File.class) {
            result = this.vf.sourceLocation(((File)o).getAbsolutePath());
        } else if (clazz == Integer.TYPE || clazz == Integer.class) {
            result = this.vf.integer((Integer)o);
        } else if (clazz == Long.TYPE || clazz == Long.class) {
            result = this.vf.integer((Long)o);
        } else if (clazz == Character.TYPE || clazz == Character.class) {
            result = this.vf.integer(((Character)o).charValue());
        } else if (clazz == Byte.TYPE || clazz == Byte.class) {
            result = this.vf.integer(((Byte)o).byteValue());
        } else if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            result = this.vf.bool((Boolean)o);
        } else if (clazz == Float.TYPE || clazz == Float.class) {
            result = this.vf.real(((Float)o).floatValue());
        } else if (clazz == Double.TYPE || clazz == Double.class) {
            result = this.vf.real((Double)o);
        } else if (clazz == String.class) {
            result = this.vf.string((String)o);
        } else {
            if (o instanceof IValue) {
                return (IValue)o;
            }
            if (o instanceof Set) {
                result = this.readSet((Set)o, includes, cache, stack);
            } else if (o instanceof Map) {
                result = this.readMap((Map)o, includes, cache, stack);
            } else if (o instanceof List) {
                result = this.readList((List)o, includes, cache, stack);
            } else if (this.instanceOfCheck(o, includes)) {
                Map<String, IValue> fields = this.getFields(o, o.getClass(), includes, cache, stack);
                result = this.vf.node(clazz.getCanonicalName(), EMPTY, fields);
            }
        }
        cache.put(o, result);
        stack.pop();
        return result;
    }

    private IValue readList(List<?> o, Set<Class<?>> includes, Map<Object, IValue> cache, Stack<Object> stack) {
        IListWriter w = this.vf.listWriter();
        for (Object e : o) {
            IValue elem = this.readObject(e, includes, cache, stack);
            if (elem == null) continue;
            w.insert(elem);
        }
        Object result = w.done();
        return result;
    }

    private IValue readMap(Map<?, ?> o, Set<Class<?>> includes, Map<Object, IValue> cache, Stack<Object> stack) {
        Object result;
        IMapWriter w = this.vf.mapWriter();
        try {
            for (Map.Entry<?, ?> e : o.entrySet()) {
                Object ov;
                IValue val;
                Object ok = e.getKey();
                IValue key = this.readObject(ok, includes, cache, stack);
                if (key == null || (val = this.readObject(ov = e.getValue(), includes, cache, stack)) == null) continue;
                w.put(key, val);
            }
            result = w.done();
        }
        catch (UnsupportedOperationException e) {
            String name = o.getClass().getCanonicalName();
            Map<String, IValue> fields = this.getFields(o, o.getClass(), includes, cache, stack);
            result = this.vf.node(name, EMPTY, fields);
        }
        return result;
    }

    private IValue readSet(Set<?> o, Set<Class<?>> includes, Map<Object, IValue> cache, Stack<Object> stack) {
        ISetWriter w = this.vf.setWriter();
        for (Object e : o) {
            IValue elem = this.readObject(e, includes, cache, stack);
            if (elem == null) continue;
            w.insert(elem);
        }
        Object result = w.done();
        return result;
    }

    private IValue readArray(Object[] o, Set<Class<?>> includes, Map<Object, IValue> cache, Stack<Object> stack) {
        IListWriter w = this.vf.listWriter();
        for (Object e : o) {
            IValue elem = this.readObject(e, includes, cache, stack);
            if (elem == null) continue;
            w.insert(elem);
        }
        Object result = w.done();
        return result;
    }

    private boolean instanceOfCheck(Object o, Set<Class<?>> includes) {
        for (Class<?> clazz : includes) {
            if (!clazz.isAssignableFrom(o.getClass())) continue;
            return true;
        }
        return false;
    }
}

