/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.util;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.TypeFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.uri.URIResolverRegistry;

public class ShellExec {
    private static Map<IInteger, Process> runningProcesses = new ConcurrentHashMap<IInteger, Process>();
    private static Map<IInteger, IInteger> processExitCodes = new ConcurrentHashMap<IInteger, IInteger>();
    private static Map<IInteger, InputStreamReader> processInputStreams = new HashMap<IInteger, InputStreamReader>();
    private static Map<IInteger, BufferedReader> processErrorStreams = new HashMap<IInteger, BufferedReader>();
    private static Map<IInteger, OutputStreamWriter> processOutputStreams = new HashMap<IInteger, OutputStreamWriter>();
    private static IInteger processCounter = null;
    private final IValueFactory vf;

    public ShellExec(IValueFactory vf) {
        this.vf = vf;
    }

    public IInteger createProcess(IString processCommand, ISourceLocation workingDir, IList arguments, IMap envVars) {
        return this.createProcessInternal(processCommand, arguments, envVars, workingDir);
    }

    private IString toString(IValue o) {
        TypeFactory TF = TypeFactory.getInstance();
        try {
            if (o.getType().isSourceLocation()) {
                ISourceLocation p = URIResolverRegistry.getInstance().logicalToPhysical((ISourceLocation)o);
                if (!"file".equals(p.getScheme())) {
                    throw RuntimeExceptionFactory.illegalArgument(o, "only file:/// URI are supported or logical schemes that derived from file");
                }
                return this.vf.string(new File(p.getURI()).getAbsolutePath());
            }
            if (o.getType().isSubtypeOf(TF.listType(TF.sourceLocationType()))) {
                return this.vf.string(((IList)o).stream().map(this::toString).map(IString::getValue).collect(Collectors.joining(File.pathSeparator)));
            }
            if (o.getType().isSubtypeOf(TF.setType(TF.sourceLocationType()))) {
                return this.vf.string(((IList)o).stream().map(this::toString).map(IString::getValue).collect(Collectors.joining(File.pathSeparator)));
            }
            if (o.getType().isString()) {
                return (IString)o;
            }
            return this.vf.string(o.toString());
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(e);
        }
    }

    public IInteger createProcess(ISourceLocation processCommand, ISourceLocation workingDir, IList arguments, IMap envVars) {
        try {
            processCommand = URIResolverRegistry.getInstance().logicalToPhysical(processCommand);
            arguments = arguments.stream().map(v -> this.toString((IValue)v)).collect(this.vf.listWriter());
            envVars = envVars.stream().map(t2 -> this.vf.tuple(((ITuple)t2).get(0), this.toString(((ITuple)t2).get(1)))).collect(this.vf.mapWriter());
            if ("file".equals(processCommand.getScheme())) {
                return this.createProcessInternal(this.toString(processCommand), arguments, envVars, workingDir);
            }
            throw RuntimeExceptionFactory.illegalArgument((IValue)processCommand, "createProcess only supports the file:/// scheme for command arguments, or logical schemes derived from it.");
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(e);
        }
    }

    public IBool isAlive(IInteger pid) {
        Process p = runningProcesses.get(pid);
        return p != null ? this.vf.bool(p.isAlive()) : this.vf.bool(false);
    }

    public IBool isZombie(IInteger pid) {
        Process p = runningProcesses.get(pid);
        return this.vf.bool(p != null && !p.isAlive());
    }

    public IInteger exitCode(IInteger pid) {
        Process p = runningProcesses.get(pid);
        if (p == null) {
            IInteger storedExitCode = processExitCodes.get(pid);
            if (storedExitCode == null) {
                throw RuntimeExceptionFactory.illegalArgument((IValue)pid, "unknown process");
            }
            return storedExitCode;
        }
        try {
            return this.vf.integer(p.waitFor());
        }
        catch (InterruptedException e) {
            throw RuntimeExceptionFactory.javaException(e, null, null);
        }
    }

    private synchronized IInteger createProcessInternal(IString processCommand, IList arguments, IMap envVars, ISourceLocation workingDir) {
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add(processCommand.getValue());
            if (arguments != null) {
                for (int n = 0; n < arguments.length(); ++n) {
                    if (!(arguments.get(n) instanceof IString)) {
                        throw RuntimeExceptionFactory.illegalArgument(arguments.get(n), null, null);
                    }
                    args.add(((IString)arguments.get(n)).getValue());
                }
            }
            ProcessBuilder pb = new ProcessBuilder(args);
            HashMap<String, String> vars = new HashMap<String, String>();
            if (envVars != null && envVars.size() > 0) {
                for (Object varKey : envVars) {
                    if (varKey instanceof IString) {
                        Object strKey = (IString)varKey;
                        IValue varVal = envVars.get((IValue)varKey);
                        if (varVal instanceof IString) {
                            IString strVal = (IString)varVal;
                            vars.put(strKey.getValue(), strVal.getValue());
                            continue;
                        }
                        throw RuntimeExceptionFactory.illegalArgument(varVal, null, null);
                    }
                    throw RuntimeExceptionFactory.illegalArgument((IValue)varKey, null, null);
                }
            }
            Map<String, String> currentEnv = pb.environment();
            try {
                for (Object strKey : vars.keySet()) {
                    currentEnv.put((String)strKey, (String)vars.get(strKey));
                }
            }
            catch (UnsupportedOperationException uoe) {
                throw RuntimeExceptionFactory.permissionDenied(this.vf.string("Modifying environment variables is not allowed on this machine."), null, null);
            }
            catch (IllegalArgumentException iae) {
                throw RuntimeExceptionFactory.permissionDenied(this.vf.string("Modifying environment variables is not allowed on this machine."), null, null);
            }
            workingDir = URIResolverRegistry.getInstance().logicalToPhysical(workingDir);
            File cwd = null;
            if (workingDir != null && workingDir.getScheme().equals("file")) {
                cwd = new File(workingDir.getPath());
                pb.directory(cwd);
            }
            Process newProcess = pb.start();
            if (processCounter == null) {
                processCounter = this.vf.integer(0);
            }
            processCounter = processCounter.add(this.vf.integer(1));
            runningProcesses.put(processCounter, newProcess);
            return processCounter;
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void killProcess(final IInteger processId, IBool force) {
        Process runningProcess;
        if (!runningProcesses.containsKey(processId)) {
            throw RuntimeExceptionFactory.illegalArgument(processId, null, null);
        }
        if (processInputStreams.containsKey(processId)) {
            try {
                processInputStreams.get(processId).close();
            }
            catch (IOException iOException) {
            }
            finally {
                processInputStreams.remove(processId);
            }
        }
        if (processErrorStreams.containsKey(processId)) {
            try {
                processErrorStreams.get(processId).close();
            }
            catch (IOException iOException) {
            }
            finally {
                processErrorStreams.remove(processId);
            }
        }
        if (processOutputStreams.containsKey(processId)) {
            try {
                processOutputStreams.get(processId).close();
            }
            catch (IOException iOException) {
            }
            finally {
                processOutputStreams.remove(processId);
            }
        }
        if ((runningProcess = runningProcesses.get(processId)).isAlive()) {
            if (force.getValue()) {
                runningProcess.destroyForcibly();
            } else {
                runningProcess.destroy();
            }
        }
        Thread waitForCleared = new Thread("zombie process clean up"){

            @Override
            public void run() {
                while (true) {
                    try {
                        runningProcess.waitFor();
                        processExitCodes.put(processId, ShellExec.this.vf.integer(runningProcess.exitValue()));
                        runningProcesses.remove(processId);
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        };
        waitForCleared.setDaemon(true);
        waitForCleared.start();
    }

    public synchronized IString readFrom(IInteger processId) {
        if (!runningProcesses.containsKey(processId)) {
            throw RuntimeExceptionFactory.illegalArgument(processId, null, null);
        }
        try {
            Process runningProcess = runningProcesses.get(processId);
            InputStreamReader isr = null;
            if (processInputStreams.containsKey(processId)) {
                isr = processInputStreams.get(processId);
            } else {
                isr = new InputStreamReader(runningProcess.getInputStream());
                processInputStreams.put(processId, isr);
            }
            StringBuffer line = new StringBuffer();
            while (isr.ready()) {
                line.append((char)isr.read());
            }
            return this.vf.string(line.toString());
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.javaException(e, null, null);
        }
    }

    public synchronized IString readWithWait(IInteger processId, IInteger wait) {
        if (!runningProcesses.containsKey(processId)) {
            throw RuntimeExceptionFactory.illegalArgument(processId, null, null);
        }
        try {
            Process runningProcess = runningProcesses.get(processId);
            InputStreamReader isr = null;
            if (processInputStreams.containsKey(processId)) {
                isr = processInputStreams.get(processId);
            } else {
                isr = new InputStreamReader(runningProcess.getInputStream());
                processInputStreams.put(processId, isr);
            }
            StringBuffer line = new StringBuffer();
            int nrOfWaits = 0;
            while (nrOfWaits < 2) {
                if (isr.ready()) {
                    nrOfWaits = 0;
                    line.append((char)isr.read());
                    continue;
                }
                Thread.sleep(wait.intValue());
                ++nrOfWaits;
            }
            return this.vf.string(line.toString());
        }
        catch (IOException | InterruptedException e) {
            throw RuntimeExceptionFactory.javaException(e, null, null);
        }
    }

    public synchronized IString readFromErr(IInteger processId) {
        if (!runningProcesses.containsKey(processId)) {
            throw RuntimeExceptionFactory.illegalArgument(processId, null, null);
        }
        try {
            Process runningProcess = runningProcesses.get(processId);
            BufferedReader isr = null;
            if (processErrorStreams.containsKey(processId)) {
                isr = processErrorStreams.get(processId);
            } else {
                isr = new BufferedReader(new InputStreamReader(runningProcess.getErrorStream()));
                processErrorStreams.put(processId, isr);
            }
            StringBuffer line = new StringBuffer();
            while (isr.ready()) {
                line.append((char)isr.read());
            }
            return this.vf.string(line.toString());
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.javaException(e, null, null);
        }
    }

    public synchronized IString readLineFromErr(IInteger processId, IInteger wait, IInteger maxTries) {
        if (!runningProcesses.containsKey(processId)) {
            throw RuntimeExceptionFactory.illegalArgument(processId, null, null);
        }
        try {
            Process runningProcess = runningProcesses.get(processId);
            BufferedReader isr = null;
            if (processErrorStreams.containsKey(processId)) {
                isr = processErrorStreams.get(processId);
            } else {
                isr = new BufferedReader(new InputStreamReader(runningProcess.getErrorStream()));
                processErrorStreams.put(processId, isr);
            }
            for (long max = maxTries.longValue(); !isr.ready() && max > 0L; --max) {
                try {
                    Thread.sleep(wait.longValue());
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.vf.string(isr.readLine());
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.javaException(e, null, null);
        }
    }

    public synchronized IString readEntireStream(IInteger processId) {
        IString iString;
        if (!runningProcesses.containsKey(processId)) {
            throw RuntimeExceptionFactory.illegalArgument(processId, null, null);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(runningProcesses.get(processId).getInputStream()));
        try {
            StringBuffer lines = new StringBuffer();
            String line = "";
            while (null != (line = br.readLine())) {
                lines.append(line);
                lines.append('\n');
            }
            iString = this.vf.string(lines.toString());
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw RuntimeExceptionFactory.javaException(e, null, null);
            }
        }
        br.close();
        return iString;
    }

    public synchronized IString readEntireErrStream(IInteger processId) {
        IString iString;
        if (!runningProcesses.containsKey(processId)) {
            throw RuntimeExceptionFactory.illegalArgument(processId, null, null);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(runningProcesses.get(processId).getErrorStream()));
        try {
            StringBuffer lines = new StringBuffer();
            String line = "";
            while (null != (line = br.readLine())) {
                lines.append(line);
                lines.append('\n');
            }
            iString = this.vf.string(lines.toString());
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw RuntimeExceptionFactory.javaException(e, null, null);
            }
        }
        br.close();
        return iString;
    }

    public void writeTo(IInteger processId, IString msg) {
        if (!runningProcesses.containsKey(processId)) {
            throw RuntimeExceptionFactory.illegalArgument(processId, null, null);
        }
        try {
            Process runningProcess = runningProcesses.get(processId);
            OutputStreamWriter osw = null;
            if (processOutputStreams.containsKey(processId)) {
                osw = processOutputStreams.get(processId);
            } else {
                osw = new OutputStreamWriter(runningProcess.getOutputStream());
                processOutputStreams.put(processId, osw);
            }
            osw.append(msg.getValue());
            osw.flush();
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.javaException(e, null, null);
        }
    }
}

