/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.result.struct;

import org.rascalmpl.parser.gtd.result.AbstractContainerNode;
import org.rascalmpl.parser.gtd.result.AbstractNode;
import org.rascalmpl.parser.gtd.util.ArrayList;

public class Link {
    private static final int PREFIX_EMPTINESS_UNKNOWN = 0;
    private static final int PREFIX_CALCULATING = 1;
    private static final int PREFIX_CAN_BE_EMPTY = 2;
    private static final int PREFIX_NOT_EMPTY = 3;
    private static final int CACHEABLE_UNKNOWN = 0;
    private static final int CACHEABLE_CALCULATING = 1;
    private static final int CACHEABLE_YES = 2;
    private static final int CACHEABLE_NO = 3;
    private final ArrayList<Link> prefixes;
    private final AbstractNode node;
    private int emptyPrefix;
    private int cacheable;

    public Link(ArrayList<Link> prefixes, AbstractNode node) {
        this.prefixes = prefixes;
        this.node = node;
        this.emptyPrefix = 0;
        this.cacheable = 0;
    }

    public ArrayList<Link> getPrefixes() {
        return this.prefixes;
    }

    public AbstractNode getNode() {
        return this.node;
    }

    public boolean isCacheable() {
        switch (this.cacheable) {
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
            case 1: {
                this.cacheable = 3;
                return false;
            }
            case 0: {
                this.cacheable = 1;
                this.cacheable = this.checkCacheable() ? 2 : 3;
                return this.cacheable == 2;
            }
        }
        throw new IllegalStateException("Unknown cacheable state: " + this.cacheable);
    }

    private boolean checkCacheable() {
        int type = this.node.getTypeIdentifier();
        if (type == 2 || type == 3 || type == 9 || type == 1) {
            return true;
        }
        if (this.node.isEmpty()) {
            if (this.prefixes == null || this.prefixes.size() == 0) {
                return this.allAltsCacheable(this.node);
            }
            for (int i = this.prefixes.size() - 1; i >= 0; --i) {
                Link prefix = this.prefixes.get(i);
                if (prefix == null || prefix.isCacheable()) continue;
                return false;
            }
            return true;
        }
        if (!this.canPrefixBeEmpty()) {
            return true;
        }
        if (this.prefixes == null || this.prefixes.size() == 0) {
            return this.allAltsCacheable(this.node);
        }
        return false;
    }

    private boolean allAltsCacheable(AbstractNode node) {
        if (!(node instanceof AbstractContainerNode)) {
            return true;
        }
        AbstractContainerNode containerNode = (AbstractContainerNode)node;
        if (containerNode.getFirstAlternative() != null && !containerNode.getFirstAlternative().isCacheable()) {
            return false;
        }
        ArrayList<Link> alts = containerNode.getAdditionalAlternatives();
        if (alts == null) {
            return true;
        }
        for (int i = alts.size() - 1; i >= 0; --i) {
            if (alts.get(i).isCacheable()) continue;
            return false;
        }
        return true;
    }

    public boolean canPrefixBeEmpty() {
        switch (this.emptyPrefix) {
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
            case 1: {
                this.emptyPrefix = 2;
                return true;
            }
            case 0: {
                this.emptyPrefix = 1;
                this.emptyPrefix = this.checkPrefixBeEmpty() ? 2 : 3;
                return this.emptyPrefix == 2;
            }
        }
        throw new IllegalStateException("Unknown prefix emptiness state: " + this.emptyPrefix);
    }

    private boolean checkPrefixBeEmpty() {
        if (this.prefixes == null || this.prefixes.size() == 0) {
            return true;
        }
        boolean anyNonEmpty = false;
        for (int i = this.prefixes.size() - 1; i >= 0; --i) {
            Link prefix = this.prefixes.get(i);
            if (prefix == null) continue;
            if (!prefix.node.isEmpty()) {
                anyNonEmpty = true;
                continue;
            }
            if (prefix.canPrefixBeEmpty()) {
                return true;
            }
            anyNonEmpty = true;
        }
        return !anyNonEmpty;
    }

    public String toString() {
        return "Link[node=" + this.node + ", prefixes=" + (this.prefixes == null ? 0 : this.prefixes.size()) + "]";
    }
}

