/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.shell;

import engineering.swat.watch.DaemonThreadPool;
import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jline.terminal.Terminal;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.library.util.PathConfig;
import org.rascalmpl.repl.streams.StreamUtil;
import org.rascalmpl.shell.AbstractCommandlineTool;
import org.rascalmpl.shell.CommandlineParser;
import org.rascalmpl.shell.RascalShell;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.IRascalValueFactory;

public class RascalCompile
extends AbstractCommandlineTool {
    private static final String mainModule = "lang::rascalcore::check::Checker";
    private static final String[] imports = new String[]{"org/rascalmpl/compiler", "org/rascalmpl/typepal"};
    private static final URIResolverRegistry reg = URIResolverRegistry.getInstance();
    private static final IRascalValueFactory vf = IRascalValueFactory.getInstance();

    public static void main(String[] args) throws IOException {
        RascalShell.setupJavaProcessForREPL();
        Terminal term = RascalShell.connectToTerminal();
        IRascalMonitor monitor = IRascalMonitor.buildConsoleMonitor(term);
        PrintWriter err = monitor instanceof Writer ? StreamUtil.generateErrorStream(term, (Writer)((Object)monitor)) : new PrintWriter(System.err, true);
        PrintWriter out = monitor instanceof PrintWriter ? (PrintWriter)((Object)monitor) : new PrintWriter(System.out, false);
        try {
            CommandlineParser parser = new CommandlineParser(out);
            Type kwParams = RascalCompile.reproduceCheckerMainParameterTypes();
            Map<String, IValue> parsedArgs = parser.parseKeywordCommandLineArgs("RascalCompile", args, kwParams);
            System.exit(RascalCompile.runMain(parsedArgs, term, monitor, err, out));
        }
        catch (Throwable e) {
            err.println(e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void removeParallelismArguments(Map<String, IValue> parsedArgs) {
        parsedArgs.remove("parallel");
        parsedArgs.remove("parallelMax");
        parsedArgs.remove("parallelPreChecks");
    }

    public static int runMain(Map<String, IValue> parsedArgs, Terminal term, IRascalMonitor monitor, PrintWriter err, PrintWriter out) {
        boolean isParallel = RascalCompile.isTrueParameter(parsedArgs, "parallel");
        int parAmount = RascalCompile.parallelAmount(RascalCompile.intParameter(parsedArgs, "parallelMax").intValue());
        IList modules = RascalCompile.listParameter(parsedArgs, "modules");
        IList preChecks = isParallel ? RascalCompile.listParameter(parsedArgs, "parallelPreChecks") : vf.list(new IValue[0]);
        RascalCompile.removeParallelismArguments(parsedArgs);
        if (!isParallel || modules.size() <= 5 || parAmount <= 1) {
            return RascalCompile.main(mainModule, imports, parsedArgs, term, monitor, err, out);
        }
        return RascalCompile.parallelMain(parsedArgs, preChecks, parAmount, mainModule, imports, term, monitor, err, out);
    }

    private static int parallelMain(Map<String, IValue> parsedArgs, IList preChecks, int parAmount, String mainModule, String[] imports, Terminal term, IRascalMonitor monitor, PrintWriter err, PrintWriter out) {
        IList modules = (IList)parsedArgs.get("modules");
        if (modules.isEmpty()) {
            return 0;
        }
        parsedArgs.put("modules", preChecks);
        out.println("Prechecking " + preChecks.size() + " modules ");
        if (RascalCompile.main(mainModule, imports, parsedArgs, term, monitor, err, out) != 0) {
            System.exit(1);
        }
        out.println("Precheck is done.");
        out.flush();
        modules = modules.subtract(preChecks);
        List<IList> chunks = RascalCompile.splitTodoList(parAmount, modules);
        IList bins = chunks.stream().map(RascalCompile.handleExceptions(l -> Files.createTempDirectory("rascal-checker", new FileAttribute[0]))).map(RascalCompile.handleExceptions(p -> URIUtil.createFileLocation(p))).collect(vf.listWriter());
        ISourceLocation bin = (ISourceLocation)parsedArgs.get("pcfg").asWithKeywordParameters().getParameter("bin");
        bins.stream().map(ISourceLocation.class::cast).forEach(RascalCompile.handleConsumerExceptions(b -> reg.copy(bin, (ISourceLocation)b, true, true)));
        ExecutorService exec = DaemonThreadPool.buildConstrainedCached("rascal-compile", parAmount);
        ArrayList<Future<Integer>> workers = new ArrayList<Future<Integer>>(parAmount);
        int i = 0;
        while (i < parAmount) {
            int index = i++;
            IList chunk = chunks.get(index);
            IValue chunkBin = bins.get(index);
            HashMap<String, IValue> chunkArgs = new HashMap<String, IValue>(parsedArgs);
            chunkArgs.put("modules", chunk);
            IValue pcfg = (IValue)chunkArgs.get("pcfg");
            pcfg = pcfg.asWithKeywordParameters().setParameter("bin", chunkBin);
            chunkArgs.put("pcfg", pcfg);
            workers.add(exec.submit(() -> {
                out.println("Starting worker " + index + " on " + chunk.size() + " modules.");
                return RascalCompile.main(mainModule, imports, chunkArgs, term, monitor, err, out);
            }));
        }
        Integer sum = workers.stream().map(RascalCompile.handleExceptions(f -> (Integer)f.get())).reduce(0, Integer::sum);
        bins.stream().map(ISourceLocation.class::cast).forEach(RascalCompile.handleConsumerExceptions(b -> reg.copy((ISourceLocation)b, bin, true, true)));
        return sum;
    }

    private static boolean isTrueParameter(Map<String, IValue> args, String arg) {
        return RascalCompile.isTrue(args.get(arg));
    }

    private static IList listParameter(Map<String, IValue> args, String arg) {
        return args.get(arg) == null ? vf.list(new IValue[0]) : (IList)args.get(arg);
    }

    private static IInteger intParameter(Map<String, IValue> args, String arg) {
        return args.get(arg) == null ? vf.integer(0) : (IInteger)args.get(arg);
    }

    private static boolean isTrue(IValue x) {
        return x != null ? ((IBool)x).getValue() : false;
    }

    private static Type reproduceCheckerMainParameterTypes() {
        TypeFactory tf = TypeFactory.getInstance();
        Type ll = tf.listType(tf.sourceLocationType());
        Type b = tf.boolType();
        Type i = tf.integerType();
        return tf.tupleType(PathConfig.PathConfigType, "pcfg", ll, "modules", b, "logPathConfig", b, "logImports", b, "verbose", b, "logWrittenFiles", b, "warnUnused", b, "warnUnusedFormals", b, "warnUnusedVariables", b, "warnUnusedPatternFormals", b, "infoModuleChecked", b, "errorsAsWarnings", b, "warningsAsErrors", b, "parallel", i, "parallelMax", ll, "parallelPreChecks");
    }

    private static int parallelAmount(int parallelMax) {
        long result = Runtime.getRuntime().availableProcessors();
        if (result < 2L) {
            return 1;
        }
        if ((result = Math.min(result, Runtime.getRuntime().maxMemory() / 0x200000L)) < 2L) {
            return 1;
        }
        return (int)Math.min((long)parallelMax, result);
    }

    private static List<IList> splitTodoList(int procs, IList modules) {
        List todoList = modules.stream().map(ISourceLocation.class::cast).collect(Collectors.toList());
        todoList.sort((a, b) -> a.getPath().compareTo(b.getPath()));
        int chunkSize = todoList.size() / procs;
        int remainder = todoList.size() % procs;
        ArrayList<IList> result = new ArrayList<IList>(todoList.size() / chunkSize + 1);
        for (int from = 0; from < todoList.size(); from += chunkSize + (remainder-- > 0 ? 1 : 0)) {
            int to = from + chunkSize + (remainder > 0 ? 1 : 0);
            result.add(RascalCompile.toIList(todoList.subList(from, to)));
        }
        return result;
    }

    private static <T extends IValue> IList toIList(Collection<T> coll) {
        return RascalCompile.toList(coll.stream());
    }

    private static <T extends IValue> IList toList(Stream<T> stream) {
        return stream.collect(vf.listWriter());
    }

    private static <T, R, E extends Exception> Function<T, R> handleExceptions(FunctionWithException<T, R, E> fe) {
        return arg -> {
            try {
                return fe.apply(arg);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    private static <T, E extends Exception> Consumer<T> handleConsumerExceptions(ConsumerWithException<T, E> fe) {
        return arg -> {
            try {
                fe.apply(arg);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    @FunctionalInterface
    private static interface ConsumerWithException<T, E extends Exception> {
        public void apply(T var1) throws E;
    }

    @FunctionalInterface
    private static interface FunctionWithException<T, R, E extends Exception> {
        public R apply(T var1) throws E;
    }
}

