/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.zip;

import io.usethesource.vallang.ISourceLocation;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.zip.CompressedFSTree;
import org.rascalmpl.uri.zip.ZipFileResolver;
import org.rascalmpl.uri.zip.ZipInputStreamFileTree;

public class ZipInputStreamResolver
extends ZipFileResolver {
    private final URIResolverRegistry CTX;

    public ZipInputStreamResolver(URIResolverRegistry registry) {
        this.CTX = registry;
    }

    @Override
    protected CompressedFSTree getFileHierchyCache(ISourceLocation zipLocation) {
        try {
            ISourceLocation lookupKey = URIUtil.changeQuery(zipLocation, "mod=" + this.CTX.lastModified(zipLocation));
            return this.fsCache.get(lookupKey, j -> {
                try {
                    return new ZipInputStreamFileTree(this.CTX.getInputStream(zipLocation), this.CTX.created(zipLocation), this.CTX.lastModified(zipLocation), this.CTX.size(zipLocation));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private ZipEntry skipToEntry(ZipInputStream stream, ISourceLocation jarLocation, String subPath) throws IOException {
        int pos = this.getFileHierchyCache(jarLocation).getPosition(subPath);
        if (pos != -1) {
            ZipEntry entry;
            do {
                entry = stream.getNextEntry();
            } while (pos-- > 0);
            return entry;
        }
        return null;
    }

    @Override
    public InputStream getInputStream(ISourceLocation zipLocation, String subPath) throws IOException {
        final ZipInputStream stream = new ZipInputStream(this.CTX.getInputStream(zipLocation));
        if (this.skipToEntry(stream, zipLocation, subPath) != null) {
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    byte[] result = new byte[1];
                    if (stream.read(result, 0, 1) != -1) {
                        return result[0] & 0xFF;
                    }
                    return -1;
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    return stream.read(b, off, len);
                }

                @Override
                public int read(byte[] b) throws IOException {
                    return stream.read(b, 0, b.length);
                }

                @Override
                public void close() throws IOException {
                    stream.close();
                }

                @Override
                public int available() throws IOException {
                    return stream.available();
                }

                @Override
                public long skip(long n) throws IOException {
                    return stream.skip(n);
                }
            };
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

