/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.base64;

import java.io.IOException;
import java.io.Writer;

public interface Base64CharWriter
extends AutoCloseable {
    public void write(byte[] var1, int var2) throws IOException;

    @Override
    default public void close() throws IOException {
    }

    public static Base64CharWriter latinBytesTo(Writer target) {
        return (buffer, length) -> {
            char[] copy = new char[length];
            for (int i = 0; i < length; ++i) {
                copy[i] = (char)(buffer[i] & 0xFF);
            }
            target.write(copy, 0, length);
        };
    }

    public static Base64CharWriter latinBytesTo(StringBuilder target) {
        return (buffer, length) -> {
            for (int i = 0; i < length; ++i) {
                target.append((char)(buffer[i] & 0xFF));
            }
        };
    }
}

