/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.maven;

import java.net.http.HttpClient;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.settings.Server;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.rascalmpl.util.maven.FileRepositoryDownloader;
import org.rascalmpl.util.maven.HttpRepositoryDownloader;
import org.rascalmpl.util.maven.Repo;
import org.rascalmpl.util.maven.RepositoryDownloader;

public class RepositoryDownloaderFactory {
    private HttpClient client;

    public RepositoryDownloaderFactory(HttpClient client) {
        this.client = client;
    }

    public RepositoryDownloader createDownloader(Repo repo, @Nullable Server server) throws InvalidRepositoryException {
        if (repo.getUrl().startsWith("file:")) {
            return new FileRepositoryDownloader(repo);
        }
        if (repo.getUrl().startsWith("http:") || repo.getUrl().startsWith("https:")) {
            return new HttpRepositoryDownloader(repo, server, this.client);
        }
        throw new InvalidRepositoryException("Unsupported repository URL: " + repo.getUrl(), repo.getMavenRepository());
    }
}

