/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.visualize.dot;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.rascalmpl.util.visualize.dot.DotStatement;
import org.rascalmpl.util.visualize.dot.NodeId;

public class DotSubgraph
implements DotStatement {
    private String id;
    private List<DotStatement> statements;

    public DotSubgraph(String id) {
        this.id = id;
        this.statements = new ArrayList<DotStatement>();
    }

    public void addStatement(DotStatement statement) {
        this.statements.add(statement);
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void writeSource(PrintWriter writer) {
        writer.write("subgraph");
        if (this.id != null) {
            NodeId.writeId(writer, this.id);
            writer.write(" ");
        }
        writer.println(" {");
        for (DotStatement statement : this.statements) {
            writer.write("    ");
            statement.writeSource(writer);
            writer.println(";");
        }
        writer.println("    }");
    }
}

