---
title: "module DateTime"
id: DateTime
slug: /Library//DateTime
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

Library functions for date and time.
#### Usage

```rascal
import DateTime;
```

#### Dependencies
```rascal
import List;
```

#### Description


The following library functions are defined for datetime:
* [Interval](..//Library/DateTime.md#DateTime-Interval)
* [duration](..//Library/DateTime.md#DateTime-duration)
* [Duration](..//Library/DateTime.md#DateTime-Duration)
* [interval](..//Library/DateTime.md#DateTime-interval)
* [arbDateTime](..//Library/DateTime.md#DateTime-arbDateTime)
* [createDate](..//Library/DateTime.md#DateTime-createDate)
* [createDateTime](..//Library/DateTime.md#DateTime-createDateTime)
* [createDuration](..//Library/DateTime.md#DateTime-createDuration)
* [createDurationInternal](..//Library/DateTime.md#DateTime-createDurationInternal)
* [createInterval](..//Library/DateTime.md#DateTime-createInterval)
* [createTime](..//Library/DateTime.md#DateTime-createTime)
* [dateRangeByDay](..//Library/DateTime.md#DateTime-dateRangeByDay)
* [daysDiff](..//Library/DateTime.md#DateTime-daysDiff)
* [daysInInterval](..//Library/DateTime.md#DateTime-daysInInterval)
* [decrementDays](..//Library/DateTime.md#DateTime-decrementDays)
* [decrementHours](..//Library/DateTime.md#DateTime-decrementHours)
* [decrementMilliseconds](..//Library/DateTime.md#DateTime-decrementMilliseconds)
* [decrementMinutes](..//Library/DateTime.md#DateTime-decrementMinutes)
* [decrementMonths](..//Library/DateTime.md#DateTime-decrementMonths)
* [decrementSeconds](..//Library/DateTime.md#DateTime-decrementSeconds)
* [decrementYears](..//Library/DateTime.md#DateTime-decrementYears)
* [incrementDays](..//Library/DateTime.md#DateTime-incrementDays)
* [incrementHours](..//Library/DateTime.md#DateTime-incrementHours)
* [incrementMilliseconds](..//Library/DateTime.md#DateTime-incrementMilliseconds)
* [incrementMinutes](..//Library/DateTime.md#DateTime-incrementMinutes)
* [incrementMonths](..//Library/DateTime.md#DateTime-incrementMonths)
* [incrementSeconds](..//Library/DateTime.md#DateTime-incrementSeconds)
* [incrementYears](..//Library/DateTime.md#DateTime-incrementYears)
* [joinDateAndTime](..//Library/DateTime.md#DateTime-joinDateAndTime)
* [now](..//Library/DateTime.md#DateTime-now)
* [parseDate](..//Library/DateTime.md#DateTime-parseDate)
* [parseDateInLocale](..//Library/DateTime.md#DateTime-parseDateInLocale)
* [parseDateTime](..//Library/DateTime.md#DateTime-parseDateTime)
* [parseDateTimeInLocale](..//Library/DateTime.md#DateTime-parseDateTimeInLocale)
* [parseTime](..//Library/DateTime.md#DateTime-parseTime)
* [parseTimeInLocale](..//Library/DateTime.md#DateTime-parseTimeInLocale)
* [printDate](..//Library/DateTime.md#DateTime-printDate)
* [printDateInLocale](..//Library/DateTime.md#DateTime-printDateInLocale)
* [printDateTime](..//Library/DateTime.md#DateTime-printDateTime)
* [printDateTimeInLocale](..//Library/DateTime.md#DateTime-printDateTimeInLocale)
* [printTime](..//Library/DateTime.md#DateTime-printTime)
* [printTimeInLocale](..//Library/DateTime.md#DateTime-printTimeInLocale)
* [splitDateTime](..//Library/DateTime.md#DateTime-splitDateTime)


## function now {#DateTime-now}

Get the current datetime.

```rascal
datetime now()
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>now();
datetime: $2025-12-12T12:57:14.323+00:00$
```

## function createDate {#DateTime-createDate}

Create a new date.

```rascal
datetime createDate(int year, int month, int day)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>createDate(2012,1,1);
datetime: $2012-01-01$
```

## function createTime {#DateTime-createTime}

Create a new time (with optional timezone offset).

```rascal
datetime createTime(int hour, int minute, int second, int millisecond)

datetime createTime(int hour, int minute, int second, int millisecond, 
                                int timezoneHourOffset, int timezoneMinuteOffset)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>createTime(8,15,30,55);
datetime: $T08:15:30.055+00:00$
rascal>createTime(8,15,30,55,2,0);
datetime: $T08:15:30.055+02:00$
```

## function createDateTime {#DateTime-createDateTime}

Create a new datetime (with optional timezone offset).

```rascal
datetime createDateTime(int year, int month, int day, int hour, int minute, 
                                    int second, int millisecond)

datetime createDateTime(int year, int month, int day, int hour, int minute, 
                                    int second, int millisecond, int timezoneHourOffset, 
                                    int timezoneMinuteOffset)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>createDateTime(2012,1,1,8,15,30,55);
datetime: $2012-01-01T08:15:30.055+00:00$
rascal>createDateTime(2012,1,1,8,15,30,55,2,0);
datetime: $2012-01-01T08:15:30.055+02:00$
```

## function joinDateAndTime {#DateTime-joinDateAndTime}

Create a new datetime by combining a date and a time.

```rascal
datetime joinDateAndTime(datetime date, datetime time)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>D = createDate(2012, 1, 1);
datetime: $2012-01-01$
rascal>T = createTime(8, 15, 45, 30);
datetime: $T08:15:45.030+00:00$
rascal>joinDateAndTime(D, T);
datetime: $2012-01-01T08:15:45.030+00:00$
```

## function splitDateTime {#DateTime-splitDateTime}

Split an existing datetime into a tuple with the date and the time.

```rascal
tuple[datetime date, datetime time] splitDateTime(datetime dt)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>N = now();
datetime: $2025-12-12T12:57:14.471+00:00$
rascal>splitDateTime(N);
tuple[datetime date,datetime time]: <$2025-12-12$,$T12:57:14.471+00:00$>
```

## function incrementYears {#DateTime-incrementYears}

Increment the years by given amount or by 1.

```rascal
datetime incrementYears(datetime dt, int n)

datetime incrementYears(datetime dt)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>N = now();
datetime: $2025-12-12T12:57:14.502+00:00$
rascal>incrementYears(N);
datetime: $2026-12-12T12:57:14.502+00:00$
rascal>incrementYears(N, 5);
datetime: $2030-12-12T12:57:14.502+00:00$
```

## function incrementMonths {#DateTime-incrementMonths}

Increment the months by a given amount or by 1.

```rascal
datetime incrementMonths(datetime dt, int n)

datetime incrementMonths(datetime dt)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>N = now();
datetime: $2025-12-12T12:57:14.533+00:00$
rascal>incrementMonths(N);
datetime: $2026-01-12T12:57:14.533+00:00$
rascal>incrementMonths(N, 5);
datetime: $2026-05-12T12:57:14.533+00:00$
```

## function incrementDays {#DateTime-incrementDays}

Increment the days by given amount or by 1.

```rascal
datetime incrementDays(datetime dt, int n)

datetime incrementDays(datetime dt)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>N = now();
datetime: $2025-12-12T12:57:14.561+00:00$
rascal>incrementDays(N);
datetime: $2025-12-13T12:57:14.561+00:00$
rascal>incrementDays(N, 5);
datetime: $2025-12-17T12:57:14.561+00:00$
```

## function incrementHours {#DateTime-incrementHours}

Increment the hours by a given amount or by 1.`

```rascal
datetime incrementHours(datetime dt, int n)

datetime incrementHours(datetime dt)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>N = now();
datetime: $2025-12-12T12:57:14.588+00:00$
rascal>incrementHours(N);
datetime: $2025-12-12T13:57:14.588+00:00$
rascal>incrementHours(N, 5);
datetime: $2025-12-12T17:57:14.588+00:00$
```

## function incrementMinutes {#DateTime-incrementMinutes}

Increment the minutes by a given amount or by 1.

```rascal
datetime incrementMinutes(datetime dt, int n)

datetime incrementMinutes(datetime dt)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>N = now();
datetime: $2025-12-12T12:57:14.617+00:00$
rascal>incrementMinutes(N);
datetime: $2025-12-12T12:58:14.617+00:00$
rascal>incrementMinutes(N, 5);
datetime: $2025-12-12T13:02:14.617+00:00$
```

## function incrementSeconds {#DateTime-incrementSeconds}

Increment the seconds by a given amount or by 1.

```rascal
datetime incrementSeconds(datetime dt, int n)

datetime incrementSeconds(datetime dt)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>N = now();
datetime: $2025-12-12T12:57:14.645+00:00$
rascal>incrementSeconds(N);
datetime: $2025-12-12T12:57:15.645+00:00$
rascal>incrementSeconds(N, 5);
datetime: $2025-12-12T12:57:19.645+00:00$
```

## function incrementMilliseconds {#DateTime-incrementMilliseconds}

Increment the milliseconds by a given amount or by 1.

```rascal
datetime incrementMilliseconds(datetime dt, int n)

datetime incrementMilliseconds(datetime dt)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>N = now();
datetime: $2025-12-12T12:57:14.688+00:00$
rascal>incrementMilliseconds(N);
datetime: $2025-12-12T12:57:14.689+00:00$
rascal>incrementMilliseconds(N, 5);
datetime: $2025-12-12T12:57:14.693+00:00$
```

## function decrementYears {#DateTime-decrementYears}

Decrement the years by a given amount or by 1.

```rascal
datetime decrementYears(datetime dt, int n)

datetime decrementYears(datetime dt)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>N = now();
datetime: $2025-12-12T12:57:14.715+00:00$
rascal>decrementYears(N);
datetime: $2024-12-12T12:57:14.715+00:00$
rascal>decrementYears(N, 5);
datetime: $2020-12-12T12:57:14.715+00:00$
```

## function decrementMonths {#DateTime-decrementMonths}

Decrement the months by a given amount or by 1.

```rascal
datetime decrementMonths(datetime dt, int n)

datetime decrementMonths(datetime dt)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>N = now();
datetime: $2025-12-12T12:57:14.743+00:00$
rascal>decrementMonths(N);
datetime: $2025-11-12T12:57:14.743+00:00$
rascal>decrementMonths(N, 5);
datetime: $2025-07-12T12:57:14.743+00:00$
```

## function decrementDays {#DateTime-decrementDays}

Decrement the days by a given amount or by 1.

```rascal
datetime decrementDays(datetime dt, int n)

datetime decrementDays(datetime dt)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>N = now();
datetime: $2025-12-12T12:57:14.770+00:00$
rascal>decrementDays(N);
datetime: $2025-12-11T12:57:14.770+00:00$
rascal>decrementDays(N, 3);
datetime: $2025-12-09T12:57:14.770+00:00$
```

## function decrementHours {#DateTime-decrementHours}

Decrement the hours by a given amount or by 1.

```rascal
datetime decrementHours(datetime dt, int n)

datetime decrementHours(datetime dt)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>N = now();
datetime: $2025-12-12T12:57:14.798+00:00$
rascal>decrementHours(N);
datetime: $2025-12-12T11:57:14.798+00:00$
rascal>decrementHours(N, 5);
datetime: $2025-12-12T07:57:14.798+00:00$
```

## function decrementMinutes {#DateTime-decrementMinutes}

Decrement the minutes by a given amount or by 1.

```rascal
datetime decrementMinutes(datetime dt, int n)

datetime decrementMinutes(datetime dt)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>N = now();
datetime: $2025-12-12T12:57:14.825+00:00$
rascal>decrementMinutes(N);
datetime: $2025-12-12T12:56:14.825+00:00$
rascal>decrementMinutes(N, 5);
datetime: $2025-12-12T12:52:14.825+00:00$
```

## function decrementSeconds {#DateTime-decrementSeconds}

Decrement the seconds by a given amount or by 1.

```rascal
datetime decrementSeconds(datetime dt, int n)

datetime decrementSeconds(datetime dt)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>N = now();
datetime: $2025-12-12T12:57:14.852+00:00$
rascal>decrementSeconds(N);
datetime: $2025-12-12T12:57:13.852+00:00$
rascal>decrementSeconds(N, 5);
datetime: $2025-12-12T12:57:09.852+00:00$
```

## function decrementMilliseconds {#DateTime-decrementMilliseconds}

Decrement the milliseconds by a given amount or by 1.

```rascal
datetime decrementMilliseconds(datetime dt, int n)

datetime decrementMilliseconds(datetime dt)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>N = now();
datetime: $2025-12-12T12:57:14.883+00:00$
rascal>decrementMilliseconds(N);
datetime: $2025-12-12T12:57:14.882+00:00$
rascal>decrementMilliseconds(N, 5);
datetime: $2025-12-12T12:57:14.878+00:00$
```

## data interval {#DateTime-interval}
A closed interval on the time axis.

```rascal
data interval  
     = Interval(datetime begin, datetime end)
     ;
```

## function createInterval {#DateTime-createInterval}

Given two datetime values, create an interval.

```rascal
interval createInterval(datetime begin, datetime end)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>B = now();
datetime: $2025-12-12T12:57:14.912+00:00$
rascal>E = incrementDays(B, 2);
datetime: $2025-12-14T12:57:14.912+00:00$
rascal>createInterval(B, E);
interval: Interval($2025-12-12T12:57:14.912+00:00$,$2025-12-14T12:57:14.912+00:00$)
```

## data Duration {#DateTime-Duration}
A duration of time, measured in individual years, months, etc.

```rascal
data Duration  
     = duration(int years, int months, int days, int hours, int minutes, int seconds, int milliseconds)
     ;
```

## function createDurationInternal {#DateTime-createDurationInternal}

```rascal
tuple[int,int,int,int,int,int,int] createDurationInternal(datetime begin, datetime end)
```

## function createDuration {#DateTime-createDuration}

Create a new duration representing the duration between the begin and end dates.

```rascal
Duration createDuration(datetime begin, datetime end)

Duration createDuration(interval i)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>B = now();
datetime: $2025-12-12T12:57:14.940+00:00$
rascal>E1 = incrementHours(B);
datetime: $2025-12-12T13:57:14.940+00:00$
rascal>createDuration(B, E1);
Duration: duration(0,0,0,1,0,0,0)
rascal>E2 = incrementMinutes(B);
datetime: $2025-12-12T12:58:14.940+00:00$
rascal>createDuration(B, E2);
Duration: duration(0,0,0,0,1,0,0)
```

## function daysInInterval {#DateTime-daysInInterval}

Return the number of days in an interval, including the begin and end days.

```rascal
int daysInInterval(interval i)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>B = now();
datetime: $2025-12-12T12:57:14.969+00:00$
rascal>E = incrementDays(B, 2);
datetime: $2025-12-14T12:57:14.969+00:00$
rascal>I = createInterval(B, E);
interval: Interval($2025-12-12T12:57:14.969+00:00$,$2025-12-14T12:57:14.969+00:00$)
rascal>daysInInterval(I);
int: 2
```

## function daysDiff {#DateTime-daysDiff}

Return the difference between two dates and/or datetimes in days.

```rascal
int daysDiff(datetime begin, datetime end)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>B = now();
datetime: $2025-12-12T12:57:14.998+00:00$
rascal>E = incrementDays(B, 2);
datetime: $2025-12-14T12:57:14.998+00:00$
rascal>daysDiff(B, E);
int: 2
```

## function dateRangeByDay {#DateTime-dateRangeByDay}

Given an interval, return a list of days.

```rascal
list[datetime] dateRangeByDay(interval i)
```


Given an interval `i`, return a list of days `[i.begin, ..., i.end]`.

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>B = now();
datetime: $2025-12-12T12:57:15.025+00:00$
rascal>E = incrementDays(B, 2);
datetime: $2025-12-14T12:57:15.025+00:00$
rascal>I = createInterval(B, E);
interval: Interval($2025-12-12T12:57:15.025+00:00$,$2025-12-14T12:57:15.025+00:00$)
rascal>dateRangeByDay(I);
list[datetime]: [$2025-12-12$,$2025-12-13$,$2025-12-14$]
```

## function parseDate {#DateTime-parseDate}

Parse an input date given as a string using the given format string.

```rascal
datetime parseDate(str inputDate, str formatString)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>parseDate("2011-12-23", "yyyy-MM-dd");
datetime: $2011-12-23$
rascal>parseDate("20111223", "yyyyMMdd");
datetime: $2011-12-23$
```

## function parseDateInLocale {#DateTime-parseDateInLocale}

Parse an input date given as a string using a specific locale and format string.

```rascal
datetime parseDateInLocale(str inputDate, str formatString, str locale)
```

## function parseTime {#DateTime-parseTime}

Parse an input time given as a string using the given format string.

```rascal
datetime parseTime(str inputTime, str formatString)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>parseTime("11/21/19", "HH/mm/ss");
datetime: $T11:21:19.000+00:00$
```

## function parseTimeInLocale {#DateTime-parseTimeInLocale}

Parse an input time given as a string using a specific locale and format string.

```rascal
datetime parseTimeInLocale(str inputTime, str formatString, str locale)
```

## function parseDateTime {#DateTime-parseDateTime}

Parse an input datetime given as a string using the given format string.

```rascal
datetime parseDateTime(str inputDateTime, str formatString)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>parseDateTime("2011/12/23/11/19/54", "YYYY/MM/dd/HH/mm/ss");
datetime: $2010-12-26T11:19:54.000+00:00$
```

## function parseDateTimeInLocale {#DateTime-parseDateTimeInLocale}

Parse an input datetime given as a string using a specific locale and format string.

```rascal
datetime parseDateTimeInLocale(str inputDateTime, str formatString, str locale)
```

## function printDate {#DateTime-printDate}

Print an input date using the given format string.

```rascal
str printDate(datetime inputDate, str formatString)

str printDate(datetime inputDate)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>printDate(now());
str: "2025-12-12"
───
2025-12-12
───
rascal>printDate(now(), "YYYYMMdd");
str: "20251212"
───
20251212
───
```

## function printDateInLocale {#DateTime-printDateInLocale}

Print an input date using a specific locale and format string.

```rascal
str printDateInLocale(datetime inputDate, str formatString, str locale)

str printDateInLocale(datetime inputDate, str locale)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>printDateInLocale(now(), "Europe/Netherlands");
str: "2025-12-12"
───
2025-12-12
───
rascal>printDateInLocale(now(), "French");
str: "2025-12-12"
───
2025-12-12
───
```

## function printTime {#DateTime-printTime}

Print an input time using the given format string.

```rascal
str printTime(datetime inputTime, str formatString)

str printTime(datetime inputTime)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>N = now();
datetime: $2025-12-12T12:57:15.220+00:00$
rascal>printTime(N);
str: "12:57:15.220+0000"
───
12:57:15.220+0000
───
rascal>printTime(N, "HH/mm/ss");
str: "12/57/15"
───
12/57/15
───
```

## function printTimeInLocale {#DateTime-printTimeInLocale}

Print an input time using a specific locale and format string.

```rascal
str printTimeInLocale(datetime inputTime, str formatString, str locale)

str printTimeInLocale(datetime inputTime, str locale)
```

## function printDateTime {#DateTime-printDateTime}

Print an input datetime using the given format string.

```rascal
str printDateTime(datetime inputDateTime, str formatString)

str printDateTime(datetime inputDateTime)
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>N = now();
datetime: $2025-12-12T12:57:15.258+00:00$
rascal>printDateTime(N);
str: "2025-12-12 12:57:15.258+0000"
───
2025-12-12 12:57:15.258+0000
───
rascal>printDateTime(N, "yyyy-MM-dd\'T\'HH:mm:ss.SSSZZ");
str: "2025-12-12T12:57:15.258+0000"
───
2025-12-12T12:57:15.258+0000
───
rascal>printDateTime(N, "YYYY/MM/dd/HH/mm/ss");
str: "2025/12/12/12/57/15"
───
2025/12/12/12/57/15
───
```

## function printDateTimeInLocale {#DateTime-printDateTimeInLocale}

Print an input datetime using a specific locale and format string.

```rascal
str printDateTimeInLocale(datetime inputDateTime, str formatString, str locale)

str printDateTimeInLocale(datetime inputDateTime, str locale)
```

## function arbDateTime {#DateTime-arbDateTime}

Create a new arbitrary datetime.

```rascal
datetime arbDateTime()
```

#### Examples



```rascal-shell 
rascal>import DateTime;
ok
rascal>arbDateTime();
datetime: $2009-12-13T10:02:58.000+00:00$
```

